/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.BaseTransactionalContextInterceptor;
import org.infinispan.invocation.Flag;
import org.infinispan.remoting.RpcManager;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.transaction.TransactionTable;

public class InvocationContextInterceptor
extends BaseTransactionalContextInterceptor {
    private RpcManager rpcManager;

    @Inject
    public void setDependencies(RpcManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleAll(ctx, command, ctx.getGlobalTransaction(), false);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleAll(ctx, command, ctx.getGlobalTransaction(), true);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleAll(ctx, command, ctx.getGlobalTransaction(), false);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleAll(ctx, command, ctx.getGlobalTransaction(), false);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleAll(ctx, command, ctx.getGlobalTransaction(), false);
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), true);
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), true);
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), true);
    }

    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.handleAll(ctx, command, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object handleAll(InvocationContext ctx, VisitableCommand command, GlobalTransaction gtx, boolean scrubContextOnCompletion) throws Throwable {
        Object realGtx;
        boolean resumeSuspended;
        Transaction suspendedTransaction;
        block29: {
            boolean suppressExceptions = false;
            suspendedTransaction = null;
            resumeSuspended = false;
            if (this.trace) {
                this.log.trace("Invoked with command " + command + " and InvocationContext [" + ctx + "]");
            }
            try {
                if (this.txManager != null) {
                    Transaction tx = this.getTransaction();
                    realGtx = this.getGlobalTransaction(tx, gtx);
                    if (tx == null && realGtx != null && ((GlobalTransaction)realGtx).isRemote()) {
                        tx = this.txTable.getLocalTransaction(gtx);
                    }
                    this.setTransactionalContext(tx, (GlobalTransaction)realGtx, null, ctx);
                } else {
                    this.setTransactionalContext(null, null, null, ctx);
                }
                if (ctx.hasFlag(Flag.FAIL_SILENTLY)) {
                    this.log.debug("FAIL_SILENTLY flag is present - suspending any ongoing transaction.");
                    suppressExceptions = true;
                    if (ctx.getTransaction() != null) {
                        suspendedTransaction = this.txManager.suspend();
                        this.setTransactionalContext(null, null, null, ctx);
                        if (this.trace) {
                            this.log.trace("Suspending transaction " + suspendedTransaction);
                        }
                        resumeSuspended = true;
                    } else if (this.trace) {
                        this.log.trace("No ongoing transaction to suspend");
                    }
                }
                try {
                    realGtx = this.invokeNextInterceptor(ctx, command);
                }
                catch (Throwable th) {
                    Throwable retval = th;
                    if (!suppressExceptions) {
                        Throwable t = retval;
                        if (!(t instanceof RuntimeException)) throw t;
                        if (t.getCause() == null) throw t;
                        throw t.getCause();
                    }
                    Object var10_14 = null;
                    Object var12_12 = null;
                    if (scrubContextOnCompletion) {
                        this.setTransactionalContext(null, null, null, ctx);
                    }
                    if (this.trace) {
                        this.log.trace("Resetting invocation-scope flags");
                    }
                    ctx.resetFlags();
                    if (resumeSuspended) {
                        this.txManager.resume(suspendedTransaction);
                    } else if (ctx.getTransaction() != null && TransactionTable.isValid(ctx.getTransaction())) {
                        this.copyInvocationScopeFlagsToTxScope(ctx);
                    }
                    ctx.clearLookedUpEntries();
                    return var10_14;
                }
                Object var12_11 = null;
                if (!scrubContextOnCompletion) break block29;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (scrubContextOnCompletion) {
                    this.setTransactionalContext(null, null, null, ctx);
                }
                if (this.trace) {
                    this.log.trace("Resetting invocation-scope flags");
                }
                ctx.resetFlags();
                if (resumeSuspended) {
                    this.txManager.resume(suspendedTransaction);
                } else if (ctx.getTransaction() != null && TransactionTable.isValid(ctx.getTransaction())) {
                    this.copyInvocationScopeFlagsToTxScope(ctx);
                }
                ctx.clearLookedUpEntries();
                throw throwable;
            }
            this.setTransactionalContext(null, null, null, ctx);
        }
        if (this.trace) {
            this.log.trace("Resetting invocation-scope flags");
        }
        ctx.resetFlags();
        if (resumeSuspended) {
            this.txManager.resume(suspendedTransaction);
        } else if (ctx.getTransaction() != null && TransactionTable.isValid(ctx.getTransaction())) {
            this.copyInvocationScopeFlagsToTxScope(ctx);
        }
        ctx.clearLookedUpEntries();
        return realGtx;
    }

    private GlobalTransaction getGlobalTransaction(Transaction tx, GlobalTransaction gtx) {
        if (gtx == null) {
            gtx = this.txTable.getCurrentTransaction(tx, false);
        }
        if (gtx != null) {
            gtx.setRemote(this.isRemoteGlobalTx(gtx));
        }
        return gtx;
    }

    private Transaction getTransaction() throws SystemException {
        if (this.txManager == null) {
            if (this.trace) {
                this.log.trace("no transaction manager configured, setting tx as null.");
            }
            return null;
        }
        return this.txManager.getTransaction();
    }

    private boolean isRemoteGlobalTx(GlobalTransaction gtx) {
        return gtx != null && gtx.getAddress() != null && !gtx.getAddress().equals(this.rpcManager.getTransport().getAddress());
    }

    private void copyInvocationScopeFlagsToTxScope(InvocationContext ctx) {
        TransactionContext tCtx = ctx.getTransactionContext();
        if (tCtx != null) {
            if (ctx.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                tCtx.setFlags(Flag.CACHE_MODE_LOCAL);
            }
            if (ctx.hasFlag(Flag.SKIP_CACHE_STATUS_CHECK)) {
                tCtx.setFlags(Flag.SKIP_CACHE_STATUS_CHECK);
            }
        }
    }
}

