/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationInterceptor
extends BaseRpcInterceptor {
    private final AtomicLong invalidations = new AtomicLong(0L);
    protected Map<GlobalTransaction, List<VisitableCommand>> txMods;
    private CommandsFactory commandsFactory;
    private boolean statsEnabled;

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Start
    private void initTxMap() {
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal()) {
            this.replicateCall(ctx, command, this.defaultSynchronous);
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object[] keys = command.getMap() == null ? null : command.getMap().keySet().toArray();
        return this.handleInvalidate(ctx, command, keys);
    }

    @Override
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Transaction tx = ctx.getTransaction();
        if (tx != null) {
            if (this.trace) {
                this.log.trace("Entering InvalidationInterceptor's prepare phase");
            }
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            TransactionContext transactionContext = ctx.getTransactionContext();
            if (transactionContext == null) {
                throw new IllegalStateException("cannot find transaction transactionContext for " + gtx);
            }
            if (transactionContext.hasModifications()) {
                List<WriteCommand> mods;
                if (transactionContext.hasLocalModifications()) {
                    mods = Arrays.asList(command.getModifications());
                    mods.removeAll(transactionContext.getLocalModifications());
                } else {
                    mods = Arrays.asList(command.getModifications());
                }
                this.broadcastInvalidate(mods, tx, ctx);
            } else if (this.trace) {
                this.log.trace("Nothing to invalidate - no modifications in the transaction.");
            }
        }
        return retval;
    }

    private Object handleInvalidate(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful()) {
            Transaction tx = ctx.getTransaction();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Is a CRUD method");
            }
            if (keys != null && keys.length != 0) {
                if (tx == null || !TransactionTable.isValid(tx)) {
                    this.invalidateAcrossCluster(this.isSynchronous(ctx), ctx, keys);
                } else if (this.isLocalModeForced(ctx)) {
                    ctx.getTransactionContext().addLocalModification(command);
                }
            }
        }
        return retval;
    }

    private void broadcastInvalidate(List<WriteCommand> modifications, Transaction tx, InvocationContext ctx) throws Throwable {
        if (ctx.getTransaction() != null && !this.isLocalModeForced(ctx)) {
            if (modifications == null || modifications.isEmpty()) {
                return;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                this.log.debug("Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else {
                try {
                    this.invalidateAcrossCluster(this.defaultSynchronous, ctx, filterVisitor.result.toArray());
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (SystemException se) {
                        throw new RuntimeException("setting tx rollback failed ", se);
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException("Unable to broadcast invalidation messages", t);
                }
            }
        }
    }

    protected void invalidateAcrossCluster(boolean synchronous, InvocationContext ctx, Object[] keys) throws Throwable {
        if (!this.isLocalModeForced(ctx)) {
            this.incrementInvalidations();
            InvalidateCommand command = this.commandsFactory.buildInvalidateCommand(keys);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cache [" + this.rpcManager.getTransport().getAddress() + "] replicating " + command);
            }
            this.replicateCall(ctx, command, synchronous);
        }
    }

    private void incrementInvalidations() {
        if (this.statsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    @ManagedOperation
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    @ManagedAttribute
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @ManagedAttribute(description="number of invalidations")
    public long getInvalidations() {
        return this.invalidations.get();
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        public boolean containsPutForExternalRead;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.result.add(command.getKey());
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.result.add(command.getKey());
            return null;
        }
    }
}

