/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.invocation.Flag;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;

public class DistributionInterceptor
extends BaseRpcInterceptor {
    DistributionManager dm;
    CommandsFactory cf;
    DataContainer dataContainer;
    boolean isL1CacheEnabled;
    boolean needReliableReturnValues;
    static final RecipientGenerator CLEAR_COMMAND_GENERATOR = new RecipientGenerator(){
        private final Object[] EMPTY_ARRAY = new Object[0];

        @Override
        public List<Address> generateRecipients() {
            return null;
        }

        @Override
        public Object[] getKeys() {
            return this.EMPTY_ARRAY;
        }
    };

    @Inject
    public void injectDependencies(DistributionManager distributionManager, CommandsFactory cf, DataContainer dataContainer) {
        this.dm = distributionManager;
        this.cf = cf;
        this.dataContainer = dataContainer;
    }

    @Start
    public void start() {
        this.isL1CacheEnabled = this.configuration.isL1CacheEnabled();
        this.needReliableReturnValues = !this.configuration.isUnsafeUnreliableReturnValues();
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (returnValue == null && ctx.lookupEntry(command.getKey()) == null) {
            returnValue = this.remoteGetAndStoreInL1(ctx, command.getKey());
        }
        return returnValue;
    }

    private Object remoteGetAndStoreInL1(InvocationContext ctx, Object key) throws Throwable {
        if (ctx.isOriginLocal() && !this.dm.isLocal(key) && this.isNotInL1(key)) {
            InternalCacheEntry ice;
            if (this.trace) {
                this.log.trace((Object)"Doing a remote get for key {0}", key);
            }
            if ((ice = this.dm.retrieveFromRemoteSource(key)) != null) {
                if (this.isL1CacheEnabled) {
                    if (this.trace) {
                        this.log.trace((Object)"Caching remotely retrieved entry for key {0} in L1", key);
                    }
                    long lifespan = ice.getLifespan() < 0L ? this.configuration.getL1Lifespan() : Math.min(ice.getLifespan(), this.configuration.getL1Lifespan());
                    PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(ice.getKey(), ice.getValue(), lifespan, -1L);
                    this.invokeNextInterceptor(ctx, put);
                } else if (this.trace) {
                    this.log.trace((Object)"Not caching remotely retrieved entry for key {0} in L1", key);
                }
                return ice.getValue();
            }
        } else if (this.trace) {
            this.log.trace((Object)"Not doing a remote get for key {0} since entry is mapped to current node, or is in L1", key);
        }
        return null;
    }

    private boolean isNotInL1(Object key) {
        return !this.isL1CacheEnabled || !this.dataContainer.containsKey(key);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()));
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new MultipleKeysRecipientGenerator(command.getMap().keySet()));
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()));
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, CLEAR_COMMAND_GENERATOR);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()));
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.skipReplicationOfTransactionMethod(ctx)) {
            ArrayList<Address> recipients = new ArrayList<Address>(ctx.getTransactionContext().getTransactionParticipants());
            this.replicateCall(ctx, recipients, command, this.configuration.isSyncCommitPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        TransactionContext transactionContext = ctx.getTransactionContext();
        if (transactionContext.hasLocalModifications()) {
            PrepareCommand replicablePrepareCommand = command.copy();
            replicablePrepareCommand.removeModifications(transactionContext.getLocalModifications());
            command = replicablePrepareCommand;
        }
        boolean sync = this.isSynchronous(ctx);
        if (!this.skipReplicationOfTransactionMethod(ctx)) {
            if (this.trace) {
                this.log.trace((Object)("[" + this.rpcManager.getTransport().getAddress() + "] Running remote prepare for global tx {1}.  Synchronous? {2}"), this.rpcManager.getTransport().getAddress(), command.getGlobalTransaction(), sync);
            }
            ArrayList<Address> recipients = new ArrayList<Address>(ctx.getTransactionContext().getTransactionParticipants());
            this.replicateCall(ctx, recipients, command, sync, false);
        }
        return retVal;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.skipReplicationOfTransactionMethod(ctx) && !ctx.isLocalRollbackOnly()) {
            ArrayList<Address> recipients = new ArrayList<Address>(ctx.getTransactionContext().getTransactionParticipants());
            this.replicateCall(ctx, recipients, command, this.configuration.isSyncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void remoteGetBeforeWrite(InvocationContext ctx, boolean isConditionalCommand, Object ... keys) throws Throwable {
        if (this.isNeedReliableReturnValues(ctx) || isConditionalCommand && ctx.getTransaction() != null) {
            for (Object k : keys) {
                this.remoteGetAndStoreInL1(ctx, k);
            }
        }
    }

    private boolean isNeedReliableReturnValues(InvocationContext ctx) {
        return !ctx.hasFlag(Flag.UNSAFE_UNRELIABLE_RETURN_VALUES) && this.needReliableReturnValues;
    }

    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command, RecipientGenerator recipientGenerator) throws Throwable {
        boolean local = this.isLocalModeForced(ctx);
        this.remoteGetBeforeWrite(ctx, command.isConditional(), recipientGenerator.getKeys());
        if (local && ctx.getTransaction() == null) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful()) {
            if (ctx.getTransaction() == null) {
                if (ctx.isOriginLocal()) {
                    List<Address> rec = recipientGenerator.generateRecipients();
                    if (this.trace) {
                        this.log.trace((Object)"Invoking command {0} on hosts {1}", command, rec);
                    }
                    if (this.isL1CacheEnabled && rec != null) {
                        InvalidateCommand ic = this.cf.buildInvalidateFromL1Command(recipientGenerator.getKeys());
                        this.replicateCall(ctx, ic, this.isSynchronous(ctx), false);
                    }
                    this.replicateCall(ctx, rec, command, this.isSynchronous(ctx), false);
                }
            } else if (local) {
                ctx.getTransactionContext().addLocalModification(command);
            } else {
                ctx.getTransactionContext().addTransactionParticipants(recipientGenerator.generateRecipients());
            }
        }
        return returnValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        Collection<Object> keys;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            HashSet<Address> addresses = new HashSet<Address>();
            Map<Object, List<Address>> recipients = DistributionInterceptor.this.dm.locateAll(this.keys);
            for (List<Address> a : recipients.values()) {
                addresses.addAll(a);
            }
            return Immutables.immutableListConvert(addresses);
        }

        @Override
        public Object[] getKeys() {
            return this.keys.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        Object key;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
        }

        @Override
        public List<Address> generateRecipients() {
            return DistributionInterceptor.this.dm.locate(this.key);
        }

        @Override
        public Object[] getKeys() {
            return new Object[]{this.key};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RecipientGenerator {
        public List<Address> generateRecipients();

        public Object[] getKeys();
    }
}

