/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.TxInterceptor;

public class DistTxInterceptor
extends TxInterceptor {
    DistributionManager dm;
    ReplayCommandVisitor replayCommandVisitor = new ReplayCommandVisitor();

    @Inject
    public void injectDistributionManager(DistributionManager dm) {
        this.dm = dm;
    }

    protected VisitableCommand getCommandToReplay(VisitableCommand command) {
        try {
            return (VisitableCommand)command.acceptVisitor(null, this.replayCommandVisitor);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    class ReplayCommandVisitor
    extends AbstractVisitor {
        ReplayCommandVisitor() {
        }

        public Object visitPutMapCommand(InvocationContext ignored, PutMapCommand command) {
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (Map.Entry<Object, Object> entry : command.getMap().entrySet()) {
                if (!DistTxInterceptor.this.dm.isLocal(entry.getKey())) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            if (newMap.isEmpty()) {
                return null;
            }
            if (newMap.size() == command.getMap().size()) {
                return command;
            }
            return DistTxInterceptor.this.commandsFactory.buildPutMapCommand(newMap, command.getLifespanMillis(), command.getMaxIdleTimeMillis());
        }

        public Object visitPutKeyValueCommand(InvocationContext ignored, PutKeyValueCommand command) {
            return this.visitDataWriteCommand(command);
        }

        public Object visitRemoveCommand(InvocationContext ignored, RemoveCommand command) {
            return this.visitDataWriteCommand(command);
        }

        public Object visitReplaceCommand(InvocationContext ignored, ReplaceCommand command) {
            return this.visitDataWriteCommand(command);
        }

        private VisitableCommand visitDataWriteCommand(DataWriteCommand command) {
            return DistTxInterceptor.this.dm.isLocal(command.getKey()) ? command : null;
        }

        public Object handleDefault(InvocationContext ignored, VisitableCommand command) {
            return command;
        }
    }
}

