/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.transaction.TransactionTable;

public abstract class BaseTransactionalContextInterceptor
extends CommandInterceptor {
    protected TransactionTable txTable;
    protected TransactionManager txManager;

    @Inject
    public void injectDependencies(TransactionTable txTable, TransactionManager txManager) {
        this.txManager = txManager;
        this.txTable = txTable;
    }

    protected void setTransactionalContext(Transaction tx, GlobalTransaction gtx, TransactionContext tCtx, InvocationContext ctx) {
        if (this.trace) {
            this.log.trace("Setting up transactional context.");
            this.log.trace("Setting tx as " + tx + " and gtx as " + gtx);
        }
        ctx.setTransaction(tx);
        ctx.setGlobalTransaction(gtx);
        if (tCtx == null) {
            if (gtx != null) {
                ctx.setTransactionContext(this.txTable.getTransactionContext(gtx));
            } else if (tx == null) {
                ctx.setTransactionContext(null);
            }
        } else {
            ctx.setTransactionContext(tCtx);
        }
    }

    protected boolean isRollingBack(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 9 || status == 4;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", e);
            return false;
        }
    }
}

