/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.config.ConfigurationException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.FIFODataContainer;
import org.infinispan.container.LRUDataContainer;
import org.infinispan.container.SimpleDataContainer;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={DataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        switch (this.configuration.getEvictionStrategy()) {
            case NONE: {
                return (T)new SimpleDataContainer();
            }
            case FIFO: {
                return (T)new FIFODataContainer();
            }
            case LRU: {
                return (T)new LRUDataContainer();
            }
        }
        throw new ConfigurationException("Unknown eviction strategy " + (Object)((Object)this.configuration.getEvictionStrategy()));
    }
}

