/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConsistentHash
implements ConsistentHash {
    private SortedMap<Integer, Address> caches = new TreeMap<Integer, Address>();
    static final int HASH_SPACE = 1000000;

    @Override
    public void setCaches(Collection<Address> caches) {
        int increaseFactor;
        this.caches.clear();
        int nextIndex = increaseFactor = 1000000 / caches.size();
        for (Address a : caches) {
            this.caches.put(nextIndex, a);
            nextIndex += increaseFactor;
        }
    }

    @Override
    public List<Address> locate(Object key, int replicationCount) {
        Address val;
        int hash = Math.abs(key.hashCode());
        int index = hash % 1000000;
        LinkedHashSet<Address> results = new LinkedHashSet<Address>();
        SortedMap<Integer, Address> tailmap = this.caches.tailMap(index);
        int count = 0;
        for (Map.Entry<Integer, Address> entry : tailmap.entrySet()) {
            val = entry.getValue();
            results.add(val);
            if (++count < replicationCount) continue;
            break;
        }
        if (count < replicationCount) {
            for (Map.Entry<Integer, Address> entry : this.caches.entrySet()) {
                val = entry.getValue();
                results.add(val);
                if (++count < replicationCount) continue;
                break;
            }
        }
        return Immutables.immutableListConvert(results);
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys, int replCount) {
        HashMap<Object, List<Address>> locations = new HashMap<Object, List<Address>>();
        for (Object k : keys) {
            locations.put(k, this.locate(k, replCount));
        }
        return locations;
    }
}

