/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.AbstractContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.util.BidirectionalLinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionContextImpl
extends AbstractContext
implements TransactionContext {
    private Transaction ltx = null;
    private List<WriteCommand> modificationList;
    private List<WriteCommand> localModifications;
    private List<Object> dummyEntriesCreatedByCacheLoader;
    private List<Object> removedKeys = null;
    private GlobalTransaction gtx;

    @Override
    protected final int getLockSetSize() {
        return 8;
    }

    public TransactionContextImpl(Transaction tx) throws SystemException, RollbackException {
        this.ltx = tx;
        this.lookedUpEntries = new BidirectionalLinkedHashMap(8);
    }

    @Override
    public void reset() {
        super.reset();
        this.modificationList = null;
        this.localModifications = null;
        if (this.dummyEntriesCreatedByCacheLoader != null) {
            this.dummyEntriesCreatedByCacheLoader.clear();
        }
        if (this.removedKeys != null) {
            this.removedKeys.clear();
        }
        this.lookedUpEntries = new BidirectionalLinkedHashMap(8);
    }

    @Override
    public GlobalTransaction getGobalTransaction() {
        return this.gtx;
    }

    @Override
    public Set<Address> getTransactionParticipants() {
        return null;
    }

    @Override
    public void addTransactionParticipants(Collection<Address> addresses) {
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        this.lookedUpEntries.putAll(entries);
    }

    @Override
    public void addModification(WriteCommand command) {
        if (command == null) {
            return;
        }
        if (this.modificationList == null) {
            this.modificationList = new LinkedList<WriteCommand>();
        }
        this.modificationList.add(command);
    }

    @Override
    public List<WriteCommand> getModifications() {
        if (this.modificationList == null) {
            return Collections.emptyList();
        }
        return this.modificationList;
    }

    @Override
    public void addLocalModification(WriteCommand command) {
        if (command == null) {
            throw new NullPointerException("Command is null!");
        }
        if (this.localModifications == null) {
            this.localModifications = new LinkedList<WriteCommand>();
        }
        this.localModifications.add(command);
    }

    @Override
    public List<WriteCommand> getLocalModifications() {
        if (this.localModifications == null) {
            return Collections.emptyList();
        }
        return this.localModifications;
    }

    @Override
    public void addRemovedEntry(Object key) {
        if (key == null) {
            throw new NullPointerException("Key is null!");
        }
        if (this.removedKeys == null) {
            this.removedKeys = new LinkedList<Object>();
        }
        this.removedKeys.add(key);
    }

    @Override
    public List<Object> getRemovedEntries() {
        if (this.removedKeys == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Object>(this.removedKeys);
    }

    @Override
    public void setTransaction(Transaction tx) {
        this.ltx = tx;
    }

    @Override
    public void setGlobalTransaction(GlobalTransaction gtx) {
        this.gtx = gtx;
    }

    @Override
    public Transaction getTransaction() {
        return this.ltx;
    }

    @Override
    public boolean isForceAsyncReplication() {
        return this.isContextFlagSet(AbstractContext.ContextFlags.FORCE_ASYNCHRONOUS);
    }

    @Override
    public void setForceAsyncReplication(boolean forceAsyncReplication) {
        this.setContextFlag(AbstractContext.ContextFlags.FORCE_ASYNCHRONOUS, forceAsyncReplication);
        if (forceAsyncReplication) {
            this.unsetContextFlag(AbstractContext.ContextFlags.FORCE_SYNCHRONOUS);
        }
    }

    @Override
    public boolean isForceSyncReplication() {
        return this.isContextFlagSet(AbstractContext.ContextFlags.FORCE_SYNCHRONOUS);
    }

    @Override
    public void setForceSyncReplication(boolean forceSyncReplication) {
        this.setContextFlag(AbstractContext.ContextFlags.FORCE_SYNCHRONOUS, forceSyncReplication);
        if (forceSyncReplication) {
            this.unsetContextFlag(AbstractContext.ContextFlags.FORCE_ASYNCHRONOUS);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionContext (").append(System.identityHashCode(this)).append(") nmodificationList: ").append(this.modificationList);
        return sb.toString();
    }

    @Override
    public void addDummyEntryCreatedByCacheLoader(Object key) {
        if (this.dummyEntriesCreatedByCacheLoader == null) {
            this.dummyEntriesCreatedByCacheLoader = new LinkedList<Object>();
        }
        this.dummyEntriesCreatedByCacheLoader.add(key);
    }

    @Override
    public List<Object> getDummyEntriesCreatedByCacheLoader() {
        if (this.dummyEntriesCreatedByCacheLoader == null) {
            return Collections.emptyList();
        }
        return this.dummyEntriesCreatedByCacheLoader;
    }

    @Override
    public boolean hasModifications() {
        return this.modificationList != null && !this.modificationList.isEmpty();
    }

    @Override
    public boolean hasLocalModifications() {
        return this.localModifications != null && !this.localModifications.isEmpty();
    }

    @Override
    public boolean hasAnyModifications() {
        return this.hasModifications() || this.hasLocalModifications();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransactionContextImpl that = (TransactionContextImpl)o;
        if (this.dummyEntriesCreatedByCacheLoader != null ? !((Object)this.dummyEntriesCreatedByCacheLoader).equals(that.dummyEntriesCreatedByCacheLoader) : that.dummyEntriesCreatedByCacheLoader != null) {
            return false;
        }
        if (this.gtx != null ? !this.gtx.equals(that.gtx) : that.gtx != null) {
            return false;
        }
        if (this.localModifications != null ? !((Object)this.localModifications).equals(that.localModifications) : that.localModifications != null) {
            return false;
        }
        if (this.ltx != null ? !this.ltx.equals(that.ltx) : that.ltx != null) {
            return false;
        }
        if (this.modificationList != null ? !((Object)this.modificationList).equals(that.modificationList) : that.modificationList != null) {
            return false;
        }
        return !(this.removedKeys != null ? !((Object)this.removedKeys).equals(that.removedKeys) : that.removedKeys != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ltx != null ? this.ltx.hashCode() : 0);
        result = 31 * result + (this.modificationList != null ? ((Object)this.modificationList).hashCode() : 0);
        result = 31 * result + (this.localModifications != null ? ((Object)this.localModifications).hashCode() : 0);
        result = 31 * result + (this.dummyEntriesCreatedByCacheLoader != null ? ((Object)this.dummyEntriesCreatedByCacheLoader).hashCode() : 0);
        result = 31 * result + (this.removedKeys != null ? ((Object)this.removedKeys).hashCode() : 0);
        result = 31 * result + (this.gtx != null ? this.gtx.hashCode() : 0);
        return result;
    }
}

