/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Map;
import javax.transaction.Transaction;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.AbstractContext;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.InfinispanCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationContextImpl
extends AbstractContext
implements InvocationContext {
    private Transaction transaction;
    private GlobalTransaction globalTransaction;
    protected volatile TransactionContext transactionContext;

    public InvocationContextImpl() {
        this.setContextFlag(AbstractContext.ContextFlags.ORIGIN_LOCAL);
    }

    @Override
    protected final int getLockSetSize() {
        return 4;
    }

    private void initLookedUpEntries() {
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new BidirectionalLinkedHashMap(4);
        }
    }

    @Override
    public boolean hasLockedKey(Object key) {
        if (this.transactionContext != null) {
            return this.transactionContext.hasLockedKey(key);
        }
        return super.hasLockedKey(key);
    }

    @Override
    public CacheEntry lookupEntry(Object k) {
        if (this.transactionContext != null) {
            return this.transactionContext.lookupEntry(k);
        }
        return this.lookedUpEntries == null ? null : (CacheEntry)this.lookedUpEntries.get(k);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.transactionContext != null) {
            this.transactionContext.removeLookedUpEntry(key);
        } else if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.transactionContext != null) {
            this.transactionContext.putLookedUpEntry(key, e);
        } else {
            this.initLookedUpEntries();
            this.lookedUpEntries.put(key, e);
        }
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> lookedUpEntries) {
        if (this.transactionContext != null) {
            this.transactionContext.putLookedUpEntries(lookedUpEntries);
        } else {
            this.initLookedUpEntries();
            this.lookedUpEntries.putAll(lookedUpEntries);
        }
    }

    @Override
    public void clearLookedUpEntries() {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.clear();
        }
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        if (this.transactionContext != null) {
            return this.transactionContext.getLookedUpEntries();
        }
        return this.lookedUpEntries == null ? InfinispanCollections.emptyBidirectionalMap() : this.lookedUpEntries;
    }

    @Override
    public InvocationContext copy() {
        InvocationContextImpl copy = new InvocationContextImpl();
        this.copyInto(copy);
        copy.globalTransaction = this.globalTransaction;
        copy.transaction = this.transaction;
        copy.transactionContext = this.transactionContext;
        return copy;
    }

    @Override
    public void setLocalRollbackOnly(boolean localRollbackOnly) {
        this.setContextFlag(AbstractContext.ContextFlags.LOCAL_ROLLBACK_ONLY, localRollbackOnly);
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    @Override
    public void setGlobalTransaction(GlobalTransaction globalTransaction) {
        this.globalTransaction = globalTransaction;
    }

    @Override
    public boolean isOriginLocal() {
        return this.isContextFlagSet(AbstractContext.ContextFlags.ORIGIN_LOCAL);
    }

    @Override
    public void setOriginLocal(boolean originLocal) {
        this.setContextFlag(AbstractContext.ContextFlags.ORIGIN_LOCAL, originLocal);
    }

    @Override
    public boolean isLocalRollbackOnly() {
        return this.isContextFlagSet(AbstractContext.ContextFlags.LOCAL_ROLLBACK_ONLY);
    }

    @Override
    public void reset() {
        super.reset();
        this.transaction = null;
        this.globalTransaction = null;
        this.transactionContext = null;
        this.setContextFlag(AbstractContext.ContextFlags.ORIGIN_LOCAL);
        this.lookedUpEntries = null;
    }

    @Override
    public void setState(InvocationContext template) {
        if (template == null) {
            throw new NullPointerException("Template InvocationContext passed in to InvocationContext.setState() passed in is null");
        }
        this.setGlobalTransaction(template.getGlobalTransaction());
        this.setLocalRollbackOnly(template.isLocalRollbackOnly());
        this.setFlags(template.getFlags());
        this.setOriginLocal(template.isOriginLocal());
        this.setTransaction(template.getTransaction());
    }

    @Override
    public boolean isValidTransaction() {
        return this.transaction != null && TransactionTable.isValid(this.transaction);
    }

    @Override
    public boolean isContainsModifications() {
        return this.transactionContext == null ? super.isContainsModifications() : this.transactionContext.isContainsModifications();
    }

    @Override
    public void setContainsModifications(boolean b) {
        if (this.transactionContext == null) {
            super.setContainsModifications(b);
        } else {
            this.transactionContext.setContainsModifications(b);
        }
    }

    @Override
    public boolean isContainsLocks() {
        return this.transactionContext == null ? super.isContainsLocks() : this.transactionContext.isContainsLocks();
    }

    @Override
    public void setContainsLocks(boolean b) {
        if (this.transactionContext == null) {
            super.setContainsLocks(b);
        } else {
            this.transactionContext.setContainsLocks(b);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvocationContextImpl that = (InvocationContextImpl)o;
        if (this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null) {
            return false;
        }
        if (this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null) {
            return false;
        }
        return !(this.transactionContext != null ? !this.transactionContext.equals(that.transactionContext) : that.transactionContext != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 31 * result + (this.transactionContext != null ? this.transactionContext.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "InvocationContextImpl{transaction=" + this.transaction + ", globalTransaction=" + this.globalTransaction + ", transactionContext=" + this.transactionContext + ", flags=" + this.flags + ", contextFlags=" + this.contextFlags + ", lookedUpEntries size=" + (this.lookedUpEntries == null ? 0 : this.lookedUpEntries.size()) + '}';
    }
}

