/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;

public class TransientCacheEntry
extends AbstractInternalCacheEntry {
    long maxIdle = -1L;
    long lastUsed;

    TransientCacheEntry() {
        this.touch();
    }

    TransientCacheEntry(Object key, Object value, long maxIdle) {
        super(key, value);
        this.maxIdle = maxIdle;
        this.touch();
    }

    TransientCacheEntry(Object key, Object value, long maxIdle, long lastUsed) {
        super(key, value);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    public final void touch() {
        this.lastUsed = System.currentTimeMillis();
    }

    public final boolean canExpire() {
        return true;
    }

    public boolean isExpired() {
        return this.maxIdle > -1L && System.currentTimeMillis() > this.maxIdle + this.lastUsed;
    }

    public InternalCacheEntry setMaxIdle(long maxIdle) {
        if (maxIdle < 0L) {
            return new ImmortalCacheEntry(this.key, this.value);
        }
        this.maxIdle = maxIdle;
        return this;
    }

    public InternalCacheEntry setLifespan(long lifespan) {
        if (lifespan > -1L) {
            TransientMortalCacheEntry tmce = new TransientMortalCacheEntry(this.key, this.value);
            tmce.setLifespan(lifespan);
            return tmce;
        }
        return this;
    }

    public long getCreated() {
        return -1L;
    }

    public final long getLastUsed() {
        return this.lastUsed;
    }

    public long getLifespan() {
        return -1L;
    }

    public long getExpiryTime() {
        return -1L;
    }

    public final long getMaxIdle() {
        return this.maxIdle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientCacheEntry that = (TransientCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.lastUsed != that.lastUsed) {
            return false;
        }
        return this.maxIdle == that.maxIdle;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        return result;
    }
}

