/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;

public class InternalEntryFactory {
    public static final InternalCacheEntry create(Object key, Object value) {
        return new ImmortalCacheEntry(key, value);
    }

    public static final InternalCacheEntry create(Object key, Object value, long lifespan) {
        return lifespan > -1L ? new MortalCacheEntry(key, value, lifespan) : new ImmortalCacheEntry(key, value);
    }

    public static final InternalCacheEntry create(Object key, Object value, long lifespan, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheEntry(key, value);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheEntry(key, value, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheEntry(key, value, maxIdle);
        }
        return new TransientMortalCacheEntry(key, value, maxIdle, lifespan);
    }

    public static final InternalCacheEntry create(Object key, Object value, long created, long lifespan, long lastUsed, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheEntry(key, value);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheEntry(key, value, lifespan, created);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheEntry(key, value, maxIdle, lastUsed);
        }
        return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, lastUsed, created);
    }
}

