/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.container.FIFODataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;

public class LRUDataContainer
extends FIFODataContainer {
    public InternalCacheEntry get(Object k) {
        int h = this.hash(k.hashCode());
        FIFODataContainer.Segment s = this.segmentFor(h);
        FIFODataContainer.LinkedEntry le = s.get(k, h);
        InternalCacheEntry ice = null;
        if (le != null) {
            ice = le.e;
            if (le.isMarked()) {
                this.unlink(le);
            }
        }
        if (ice != null) {
            if (ice.isExpired()) {
                this.remove(k);
                ice = null;
            } else {
                ice.touch();
                this.updateLinks(le);
            }
        }
        return ice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        int h = this.hash(k.hashCode());
        FIFODataContainer.Segment s = this.segmentFor(h);
        s.lock();
        boolean newEntry = false;
        try {
            InternalCacheEntry ice;
            FIFODataContainer.LinkedEntry le = s.get(k, h);
            InternalCacheEntry internalCacheEntry = ice = le == null ? null : le.e;
            if (ice == null) {
                newEntry = true;
                ice = InternalEntryFactory.create(k, v, lifespan, maxIdle);
                le = new FIFODataContainer.LinkedEntry();
            } else {
                ice.setValue(v);
                ice = ice.setLifespan(lifespan).setMaxIdle(maxIdle);
            }
            le.e = ice;
            s.locklessPut(k, h, le);
            if (newEntry) {
                this.linkAtEnd(le);
            } else {
                this.updateLinks(le);
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            s.unlock();
            throw throwable;
        }
        s.unlock();
    }

    protected final void updateLinks(FIFODataContainer.LinkedEntry le) {
        this.unlink(le);
        this.linkAtEnd(le);
    }
}

