/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing.element;

import java.util.Properties;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.config.parsing.XmlParserBase;
import org.infinispan.loader.CacheLoader;
import org.infinispan.loader.CacheLoaderConfig;
import org.infinispan.loader.CacheStoreConfig;
import org.infinispan.loader.decorators.AsyncStoreConfig;
import org.infinispan.loader.decorators.SingletonStoreConfig;
import org.infinispan.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LoadersElementParser
extends XmlParserBase {
    public CacheLoaderManagerConfig parseLoadersElement(Element element) {
        String shared;
        CacheLoaderManagerConfig cacheLoaderConfig = new CacheLoaderManagerConfig();
        String passivation = this.getAttributeValue(element, "passivation");
        if (this.existsAttribute(passivation)) {
            cacheLoaderConfig.setPassivation(this.getBoolean(passivation));
        }
        if (this.existsAttribute(shared = this.getAttributeValue(element, "shared"))) {
            cacheLoaderConfig.setShared(this.getBoolean(shared));
        }
        boolean preload = this.getBoolean(this.getAttributeValue(element, "preload"));
        cacheLoaderConfig.setPreload(preload);
        NodeList cacheLoaderNodes = element.getElementsByTagName("loader");
        for (int i = 0; i < cacheLoaderNodes.getLength(); ++i) {
            Element indivElement = (Element)cacheLoaderNodes.item(i);
            CacheLoaderConfig iclc = this.parseIndividualCacheLoaderConfig(indivElement);
            cacheLoaderConfig.addCacheLoaderConfig(iclc);
        }
        return cacheLoaderConfig;
    }

    private CacheLoaderConfig parseIndividualCacheLoaderConfig(Element indivElement) {
        CacheLoaderConfig clc;
        String clClass = this.getAttributeValue(indivElement, "class");
        if (!this.existsAttribute(clClass)) {
            throw new ConfigurationException("Missing 'class'  attribute for cache loader configuration");
        }
        try {
            CacheLoader cl = (CacheLoader)Util.getInstance(clClass);
            clc = Util.getInstance(cl.getConfigurationClass());
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate cache loader or configuration", e);
        }
        clc.setCacheLoaderClassName(clClass);
        Element propertiesElement = this.getSingleElementInCoreNS("properties", indivElement);
        Properties props = XmlConfigHelper.extractProperties(propertiesElement);
        if (props != null) {
            XmlConfigHelper.setValues(clc, props, false, true);
        }
        if (clc instanceof CacheStoreConfig) {
            String purgeOnStartup;
            String ignoreModifications;
            CacheStoreConfig csc = (CacheStoreConfig)clc;
            String fetchPersistentState = this.getAttributeValue(indivElement, "fetchPersistentState");
            if (this.existsAttribute(fetchPersistentState)) {
                csc.setFetchPersistentState(this.getBoolean(fetchPersistentState));
            }
            if (this.existsAttribute(ignoreModifications = this.getAttributeValue(indivElement, "ignoreModifications"))) {
                csc.setIgnoreModifications(this.getBoolean(ignoreModifications));
            }
            if (this.existsAttribute(purgeOnStartup = this.getAttributeValue(indivElement, "purgeOnStartup"))) {
                csc.setPurgeOnStartup(this.getBoolean(purgeOnStartup));
            }
            csc.setSingletonStoreConfig(this.parseSingletonStoreConfig(this.getSingleElementInCoreNS("singletonStore", indivElement)));
            csc.setAsyncStoreConfig(this.parseAsyncStoreConfig(this.getSingleElementInCoreNS("async", indivElement)));
        }
        return clc;
    }

    public SingletonStoreConfig parseSingletonStoreConfig(Element element) {
        SingletonStoreConfig ssc = new SingletonStoreConfig();
        if (element == null) {
            ssc.setSingletonStoreEnabled(false);
        } else {
            boolean singletonStoreEnabled = this.getBoolean(this.getAttributeValue(element, "enabled"));
            ssc.setSingletonStoreEnabled(singletonStoreEnabled);
            String tmp = this.getAttributeValue(element, "pushStateWhenCoordinator");
            if (this.existsAttribute(tmp)) {
                ssc.setPushStateWhenCoordinator(this.getBoolean(tmp));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(element, "pushStateTimeout"))) {
                ssc.setPushStateTimeout(this.getLong(tmp));
            }
        }
        return ssc;
    }

    public AsyncStoreConfig parseAsyncStoreConfig(Element element) {
        AsyncStoreConfig asc = new AsyncStoreConfig();
        if (element == null) {
            asc.setEnabled(false);
        } else {
            boolean async = this.getBoolean(this.getAttributeValue(element, "enabled"));
            asc.setEnabled(async);
            if (async) {
                String tmp = this.getAttributeValue(element, "batchSize");
                if (this.existsAttribute(tmp)) {
                    asc.setBatchSize(this.getInt(tmp));
                }
                if (this.existsAttribute(tmp = this.getAttributeValue(element, "pollWait"))) {
                    asc.setPollWait(this.getLong(tmp));
                }
                if (this.existsAttribute(tmp = this.getAttributeValue(element, "queueSize"))) {
                    asc.setQueueSize(this.getInt(tmp));
                }
                if (this.existsAttribute(tmp = this.getAttributeValue(element, "threadPoolSize"))) {
                    asc.setThreadPoolSize(this.getInt(tmp));
                }
            }
        }
        return asc;
    }
}

