/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.parsing.XmlConfigHelper;

public abstract class PluggableConfigurationComponent
extends AbstractNamedCacheConfigurationBean {
    protected Properties properties = EMPTY_PROPERTIES;

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.testImmutability("properties");
        this.properties = properties;
    }

    public void setProperties(String properties) throws IOException {
        if (properties == null) {
            return;
        }
        this.testImmutability("properties");
        properties = XmlConfigHelper.escapeBackslashes(properties);
        ByteArrayInputStream is = new ByteArrayInputStream(properties.trim().getBytes("ISO8859_1"));
        this.properties = new Properties();
        this.properties.load(is);
        is.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluggableConfigurationComponent that = (PluggableConfigurationComponent)o;
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        return this.properties != null ? this.properties.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", properties=" + this.properties + "}";
    }

    public PluggableConfigurationComponent clone() throws CloneNotSupportedException {
        PluggableConfigurationComponent clone = (PluggableConfigurationComponent)super.clone();
        if (this.properties != null) {
            clone.properties = (Properties)this.properties.clone();
        }
        return clone;
    }
}

