/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class RemoveCommand
extends AbstractDataCommand
implements DataWriteCommand {
    private static final Log log = LogFactory.getLog(RemoveCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final byte COMMAND_ID = 6;
    protected CacheNotifier notifier;
    boolean successful = true;
    protected transient Object value;

    public RemoveCommand(Object key, Object value, CacheNotifier notifier) {
        super(key);
        this.value = value;
        this.notifier = notifier;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    public RemoveCommand() {
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveCommand(ctx, this);
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        MVCCEntry e = this.lookupMvccEntry(ctx, this.key);
        if (e == null || e.isNull()) {
            log.trace("Nothing to remove since the entry is null or we have a null entry");
            if (this.value == null) {
                return null;
            }
            this.successful = false;
            return false;
        }
        if (this.value != null && e.getValue() != null && !e.getValue().equals(this.value)) {
            this.successful = false;
            return false;
        }
        this.notify(ctx, e.getValue(), true);
        e.setRemoved(true);
        e.setValid(false);
        this.notify(ctx, null, false);
        return this.value == null ? e.getValue() : Boolean.valueOf(true);
    }

    protected void notify(InvocationContext ctx, Object value, boolean isPre) {
        this.notifier.notifyCacheEntryRemoved(this.key, value, isPre, ctx);
    }

    public byte getCommandId() {
        return 6;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveCommand)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveCommand that = (RemoveCommand)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "key=" + this.key + ", value=" + this.value + '}';
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean isConditional() {
        return this.value != null;
    }
}

