/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepareCommand
extends AbstractTransactionBoundaryCommand {
    public static final byte COMMAND_ID = 10;
    protected WriteCommand[] modifications;
    protected Address localAddress;
    protected boolean onePhaseCommit;

    public PrepareCommand(GlobalTransaction gtx, Address localAddress, boolean onePhaseCommit, WriteCommand ... modifications) {
        this.gtx = gtx;
        this.modifications = modifications;
        this.localAddress = localAddress;
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand(GlobalTransaction gtx, List<WriteCommand> commands, Address localAddress, boolean onePhaseCommit) {
        this.gtx = gtx;
        this.modifications = commands == null || commands.size() == 0 ? null : commands.toArray(new WriteCommand[commands.size()]);
        this.localAddress = localAddress;
        this.onePhaseCommit = onePhaseCommit;
    }

    public void removeModifications(Collection<WriteCommand> modificationsToRemove) {
        if (this.modifications != null && modificationsToRemove != null && modificationsToRemove.size() > 0) {
            HashSet<WriteCommand> toRemove = new HashSet<WriteCommand>(modificationsToRemove);
            WriteCommand[] newMods = new WriteCommand[this.modifications.length - modificationsToRemove.size()];
            int i = 0;
            for (WriteCommand c : this.modifications) {
                if (toRemove.contains(c)) {
                    toRemove.remove(c);
                    continue;
                }
                newMods[i++] = c;
            }
            this.modifications = newMods;
        }
    }

    public PrepareCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPrepareCommand(ctx, this);
    }

    public WriteCommand[] getModifications() {
        return this.modifications;
    }

    public Address getLocalAddress() {
        return this.localAddress;
    }

    public boolean isOnePhaseCommit() {
        return this.onePhaseCommit;
    }

    public boolean existModifications() {
        return this.modifications != null && this.modifications.length > 0;
    }

    public int getModificationsCount() {
        return this.modifications != null ? this.modifications.length : 0;
    }

    @Override
    public byte getCommandId() {
        return 10;
    }

    @Override
    public Object[] getParameters() {
        int numMods = this.modifications == null ? 0 : this.modifications.length;
        Object[] retval = new Object[numMods + 4];
        retval[0] = this.gtx;
        retval[1] = this.localAddress;
        retval[2] = this.onePhaseCommit;
        retval[3] = numMods;
        if (numMods > 0) {
            System.arraycopy(this.modifications, 0, retval, 4, numMods);
        }
        return retval;
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.gtx = (GlobalTransaction)args[0];
        this.localAddress = (Address)args[1];
        this.onePhaseCommit = (Boolean)args[2];
        int numMods = (Integer)args[3];
        if (numMods > 0) {
            this.modifications = new WriteCommand[numMods];
            System.arraycopy(args, 4, this.modifications, 0, numMods);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrepareCommand that = (PrepareCommand)o;
        if (this.onePhaseCommit != that.onePhaseCommit) {
            return false;
        }
        if (this.localAddress != null ? !this.localAddress.equals(that.localAddress) : that.localAddress != null) {
            return false;
        }
        return !(this.modifications != null ? !Arrays.equals(this.modifications, that.modifications) : that.modifications != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.modifications != null ? this.modifications.hashCode() : 0);
        result = 31 * result + (this.localAddress != null ? this.localAddress.hashCode() : 0);
        result = 31 * result + (this.onePhaseCommit ? 1 : 0);
        return result;
    }

    public PrepareCommand copy() {
        PrepareCommand copy = new PrepareCommand();
        copy.gtx = this.gtx;
        copy.localAddress = this.localAddress;
        copy.modifications = this.modifications == null ? null : (WriteCommand[])this.modifications.clone();
        copy.onePhaseCommit = this.onePhaseCommit;
        return copy;
    }

    public String toString() {
        return "PrepareCommand{globalTransaction=" + this.gtx + ", modifications=" + Arrays.toString(this.modifications) + ", localAddress=" + this.localAddress + ", onePhaseCommit=" + this.onePhaseCommit + '}';
    }

    public boolean containsModificationType(Class<? extends ReplicableCommand> replicableCommandClass) {
        for (WriteCommand mod : this.getModifications()) {
            if (!mod.getClass().equals(replicableCommandClass)) continue;
            return true;
        }
        return false;
    }
}

