/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.RpcManager;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandFactory {
    RpcManager rpcManager;

    @Inject
    public void init(RpcManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    public ReplicableCommand fromStream(byte id, Object[] parameters) {
        ReplicableCommand command;
        switch (id) {
            case 3: {
                command = new PutKeyValueCommand();
                break;
            }
            case 121: {
                command = new PutMapCommand();
                break;
            }
            case 6: {
                command = new RemoveCommand();
                break;
            }
            case 122: {
                command = new ReplaceCommand();
                break;
            }
            case 26: {
                command = new GetKeyValueCommand();
                break;
            }
            case 17: {
                command = new ClearCommand();
                break;
            }
            case 10: {
                command = new PrepareCommand();
                break;
            }
            case 11: {
                command = new CommitCommand();
                break;
            }
            case 12: {
                command = new RollbackCommand();
                break;
            }
            case 13: {
                command = new MultipleRpcCommand();
                break;
            }
            case 21: {
                command = new SingleRpcCommand();
                break;
            }
            case 47: {
                command = new InvalidateCommand();
                break;
            }
            case 48: {
                command = new InvalidateL1Command();
                break;
            }
            case 49: {
                command = new StateTransferControlCommand();
                ((StateTransferControlCommand)command).init(this.rpcManager);
                break;
            }
            case 22: {
                command = new ClusteredGetCommand();
                break;
            }
            default: {
                throw new CacheException("Unknown command id " + id + "!");
            }
        }
        command.setParameters(id, parameters);
        return command;
    }
}

