/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.status.TakeOfflineManager;

@ProtoTypeId(value=1253)
public class XSiteAmendOfflineStatusCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final String siteName;
    @ProtoField(value=3)
    final Integer afterFailures;
    @ProtoField(value=4)
    final Long minTimeToWait;

    @ProtoFactory
    public XSiteAmendOfflineStatusCommand(ByteString cacheName, String siteName, Integer afterFailures, Long minTimeToWait) {
        super(cacheName);
        this.siteName = siteName;
        this.afterFailures = afterFailures;
        this.minTimeToWait = minTimeToWait;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        TakeOfflineManager takeOfflineManager = registry.getTakeOfflineManager().running();
        takeOfflineManager.amendConfiguration(this.siteName, this.afterFailures, this.minTimeToWait);
        return CompletableFutures.completedNull();
    }

    @Override
    public final boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "XSiteAmendOfflineStatusCommand{siteName='" + this.siteName + "', afterFailures=" + this.afterFailures + ", minTimeToWait=" + this.minTimeToWait + "}";
    }
}

