/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.ImmutableProtoStreamMarshaller;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.marshall.core.impl.DelegatingUserMarshaller;
import org.infinispan.marshall.protostream.impl.AbstractInternalProtoStreamMarshaller;
import org.infinispan.marshall.protostream.impl.MarshallableLambda;
import org.infinispan.marshall.protostream.impl.MarshallableThrowable;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.util.logging.Log;

public class GlobalMarshaller
extends AbstractInternalProtoStreamMarshaller {
    @Inject
    GlobalComponentRegistry gcr;
    private ClassLoader classLoader;

    public GlobalMarshaller() {
        super(Log.CONTAINER);
    }

    @Override
    public void start() {
        super.start();
        this.classLoader = this.gcr.getGlobalConfiguration().classLoader();
        this.skipUserMarshaller = ((DelegatingUserMarshaller)this.userMarshaller).getDelegate() instanceof ImmutableProtoStreamMarshaller;
    }

    @Stop
    public void stop() {
        this.userMarshaller.stop();
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.ctxRegistry.getGlobalCtx();
    }

    @Override
    public boolean isMarshallableWithProtoStream(Object o) {
        return this.isMarshallableWithoutWrapping(o) || o.getClass().isSynthetic() || o instanceof Throwable;
    }

    public boolean isMarshallableWithoutWrapping(Object o) {
        if (this.isProtostreamNativeType(o)) {
            return true;
        }
        if (!this.skipUserMarshaller && o instanceof Iterable) {
            Iterable iterable = (Iterable)o;
            Iterator it = iterable.iterator();
            return !it.hasNext() || this.isMarshallableWithoutWrapping(it.next());
        }
        return super.isMarshallableWithProtoStream(o);
    }

    private boolean isProtostreamNativeType(Object o) {
        return o instanceof String || o instanceof Long || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Boolean || o instanceof byte[] || o instanceof Byte || o instanceof Short || o instanceof Character || o instanceof Date || o instanceof Instant;
    }

    @Override
    public ByteBuffer objectToBuffer(Object obj) {
        return super.objectToBuffer(this.wrap(obj));
    }

    @Override
    public byte[] objectToByteBuffer(Object obj, int estimatedSize) {
        return super.objectToByteBuffer(this.wrap(obj), estimatedSize);
    }

    private Object wrap(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isSynthetic()) {
            obj = MarshallableLambda.create(obj);
        } else if (obj instanceof Throwable && !this.isMarshallableWithoutWrapping(obj)) {
            obj = MarshallableThrowable.create((Throwable)obj);
        }
        return obj;
    }

    @Override
    protected Object unwrapAndInit(Object o) {
        if (o instanceof MarshallableLambda) {
            return ((MarshallableLambda)o).unwrap(this.classLoader);
        }
        if (o instanceof MarshallableThrowable) {
            return ((MarshallableThrowable)o).get();
        }
        return super.unwrapAndInit(o);
    }
}

