/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractConsistentHashFactory<CH extends ConsistentHash>
implements ConsistentHashFactory<CH> {
    protected void checkCapacityFactors(List<Address> members, Map<Address, Float> capacityFactors) {
        if (capacityFactors != null) {
            float totalCapacity = 0.0f;
            for (Address node : members) {
                Float capacityFactor = capacityFactors.get(node);
                if (capacityFactor == null || capacityFactor.floatValue() < 0.0f) {
                    throw new IllegalArgumentException("Invalid capacity factor for node " + String.valueOf(node));
                }
                totalCapacity += capacityFactor.floatValue();
            }
            if (totalCapacity == 0.0f) {
                throw new IllegalArgumentException("There must be at least one node with a non-zero capacity factor");
            }
        }
    }

    protected Address findWorstPrimaryOwner(Builder builder, List<Address> nodes) {
        Address worst = null;
        float maxSegmentsPerCapacity = -1.0f;
        for (Address owner : nodes) {
            float capacityFactor = builder.getCapacityFactor(owner);
            if (!((float)(builder.getPrimaryOwned(owner) - 1) >= capacityFactor * maxSegmentsPerCapacity)) continue;
            worst = owner;
            maxSegmentsPerCapacity = capacityFactor != 0.0f ? (float)(builder.getPrimaryOwned(owner) - 1) / capacityFactor : 0.0f;
        }
        return worst;
    }

    protected Address findNewPrimaryOwner(Builder builder, Collection<Address> candidates, Address primaryOwner) {
        float initialCapacityFactor = primaryOwner != null ? builder.getCapacityFactor(primaryOwner) : 0.0f;
        Address best = null;
        float bestSegmentsPerCapacity = initialCapacityFactor != 0.0f ? (float)(builder.getPrimaryOwned(primaryOwner) - 1) / initialCapacityFactor : Float.MAX_VALUE;
        for (Address candidate : candidates) {
            float capacityFactor;
            int primaryOwned = builder.getPrimaryOwned(candidate);
            if (!((float)(primaryOwned + 1) <= (capacityFactor = builder.getCapacityFactor(candidate)) * bestSegmentsPerCapacity)) continue;
            best = candidate;
            bestSegmentsPerCapacity = (float)(primaryOwned + 1) / capacityFactor;
        }
        return best;
    }

    static abstract class Builder {
        protected final OwnershipStatistics stats;
        protected final List<Address> members;
        protected final Map<Address, Float> capacityFactors;
        protected int modCount = 0;

        public Builder(OwnershipStatistics stats, List<Address> members, Map<Address, Float> capacityFactors) {
            this.stats = stats;
            this.members = members;
            this.capacityFactors = capacityFactors;
        }

        public Builder(Builder other) {
            this.members = other.members;
            this.capacityFactors = other.capacityFactors;
            this.stats = new OwnershipStatistics(other.stats);
        }

        public List<Address> getMembers() {
            return this.members;
        }

        public int getNumNodes() {
            return this.getMembers().size();
        }

        public abstract int getPrimaryOwned(Address var1);

        public Map<Address, Float> getCapacityFactors() {
            return this.capacityFactors;
        }

        public float getCapacityFactor(Address node) {
            return this.capacityFactors != null ? this.capacityFactors.get(node).floatValue() : 1.0f;
        }
    }
}

