/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1143)
public class PrepareCommand
extends AbstractTransactionBoundaryCommand
implements TransactionalRemoteLockCommand {
    private static final Log log = LogFactory.getLog(PrepareCommand.class);
    protected List<WriteCommand> modifications;
    protected boolean onePhaseCommit;
    private transient boolean replayEntryWrapping;
    protected boolean retriedCommand;

    public PrepareCommand(ByteString cacheName, GlobalTransaction gtx, List<WriteCommand> commands, boolean onePhaseCommit) {
        super(-1, cacheName, gtx);
        this.modifications = commands == null ? Collections.emptyList() : Collections.unmodifiableList(commands);
        this.onePhaseCommit = onePhaseCommit;
    }

    @ProtoFactory
    PrepareCommand(int topologyId, ByteString cacheName, GlobalTransaction globalTransaction, MarshallableList<WriteCommand> wrappedModifications, boolean onePhaseCommit, boolean retriedCommand) {
        super(topologyId, cacheName, globalTransaction);
        this.modifications = MarshallableList.unwrap(wrappedModifications);
        this.onePhaseCommit = onePhaseCommit;
        this.retriedCommand = retriedCommand;
    }

    @ProtoField(number=4, name="modifications")
    MarshallableList<WriteCommand> getWrappedModifications() {
        return MarshallableList.create(this.modifications);
    }

    @ProtoField(value=5)
    public boolean isOnePhaseCommit() {
        return this.onePhaseCommit;
    }

    @ProtoField(value=6)
    public boolean isRetriedCommand() {
        return this.retriedCommand;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        this.markTransactionAsRemote(true);
        RemoteTxInvocationContext ctx = this.createContext(registry);
        if (ctx == null) {
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Invoking remotely originated prepare: %s with invocation context: %s", this, ctx);
        }
        CacheNotifier notifier = registry.getCacheNotifier().running();
        CompletionStage<Void> stage = notifier.notifyTransactionRegistered(ctx.getGlobalTransaction(), false);
        AsyncInterceptorChain invoker = registry.getInterceptorChain().running();
        for (VisitableCommand visitableCommand : this.modifications) {
            visitableCommand.init(registry);
        }
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            return invoker.invokeAsync(ctx, this);
        }
        return stage.thenCompose(v -> invoker.invokeAsync(ctx, this));
    }

    public RemoteTxInvocationContext createContext(ComponentRegistry componentRegistry) {
        RecoveryManager recoveryManager = componentRegistry.getRecoveryManager().running();
        if (recoveryManager != null && recoveryManager.isTransactionPrepared(this.globalTx)) {
            log.tracef("The transaction %s is already prepared. Skipping prepare call.", this.globalTx);
            return null;
        }
        TransactionTable txTable = componentRegistry.getTransactionTableRef().running();
        RemoteTransaction remoteTransaction = txTable.getOrCreateRemoteTransaction(this.globalTx, this.modifications);
        if (this.hasModifications()) {
            remoteTransaction.setModifications(this.modifications);
        }
        InvocationContextFactory icf = componentRegistry.getInvocationContextFactory().running();
        return icf.createRemoteTxInvocationContext(remoteTransaction, this.getOrigin());
    }

    @Override
    public Collection<?> getKeysToLock() {
        if (this.modifications.isEmpty()) {
            return Collections.emptyList();
        }
        return this.modifications.stream().filter(writeCommand -> !writeCommand.hasAnyFlag(FlagBitSets.SKIP_LOCKING)).map(WriteCommand::getAffectedKeys).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Object getKeyLockOwner() {
        return this.globalTx;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        for (WriteCommand wc : this.modifications) {
            if (wc.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSkipLocking() {
        return false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPrepareCommand((TxInvocationContext)ctx, this);
    }

    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    @Override
    public String toString() {
        return "PrepareCommand {modifications=" + String.valueOf(this.modifications) + ", onePhaseCommit=" + this.onePhaseCommit + ", retried=" + this.retriedCommand + ", " + super.toString();
    }

    public boolean hasModifications() {
        return this.modifications != null && !this.modifications.isEmpty();
    }

    public Collection<?> getAffectedKeys() {
        if (this.modifications == null || this.modifications.isEmpty()) {
            return Collections.emptySet();
        }
        int size = this.modifications.size();
        if (size == 1) {
            return this.modifications.get(0).getAffectedKeys();
        }
        HashSet keys = new HashSet(size);
        for (WriteCommand wc : this.modifications) {
            keys.addAll(wc.getAffectedKeys());
        }
        return keys;
    }

    public boolean isReplayEntryWrapping() {
        return this.replayEntryWrapping;
    }

    public void setReplayEntryWrapping(boolean replayEntryWrapping) {
        this.replayEntryWrapping = replayEntryWrapping;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    public void setRetriedCommand(boolean retriedCommand) {
        this.retriedCommand = retriedCommand;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

