/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.configuration.IndexConfiguration;

public class IndexConfigurationBuilder
implements Builder<IndexConfiguration> {
    private static final Log log = Log.getLog(IndexConfigurationBuilder.class);
    private final AttributeSet attributes = IndexConfiguration.attributeDefinitionSet();

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexConfigurationBuilder indexLocation(String indexLocation) {
        this.attributes.attribute(IndexConfiguration.INDEX_LOCATION).set((Object)indexLocation);
        return this;
    }

    @Deprecated(since="15.0")
    public IndexConfigurationBuilder indexSegments(int indexSegments) {
        this.attributes.attribute(IndexConfiguration.INDEX_SEGMENTS).set((Object)indexSegments);
        return this;
    }

    public IndexConfigurationBuilder minNodeSize(int minNodeSize) {
        this.attributes.attribute(IndexConfiguration.MIN_NODE_SIZE).set((Object)minNodeSize);
        return this;
    }

    public IndexConfigurationBuilder maxNodeSize(int maxNodeSize) {
        this.attributes.attribute(IndexConfiguration.MAX_NODE_SIZE).set((Object)maxNodeSize);
        return this;
    }

    public IndexConfigurationBuilder indexQueueLength(int indexQueueLength) {
        this.attributes.attribute(IndexConfiguration.INDEX_QUEUE_LENGTH).set((Object)indexQueueLength);
        return this;
    }

    public IndexConfiguration create() {
        return new IndexConfiguration(this.attributes.protect());
    }

    public Builder<?> read(IndexConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public void validate() {
        int minNodeSize = (Integer)this.attributes.attribute(IndexConfiguration.MIN_NODE_SIZE).get();
        int maxNodeSize = (Integer)this.attributes.attribute(IndexConfiguration.MAX_NODE_SIZE).get();
        if (maxNodeSize <= 0 || maxNodeSize > Short.MAX_VALUE) {
            throw log.maxNodeSizeLimitedToShort(maxNodeSize);
        }
        if (minNodeSize < 0 || minNodeSize > maxNodeSize) {
            throw log.minNodeSizeMustBeLessOrEqualToMax(minNodeSize, maxNodeSize);
        }
    }

    public String toString() {
        return "IndexConfigurationBuilder{attributes=" + String.valueOf(this.attributes) + "}";
    }
}

