/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.PersistedConsistentHash;
import org.infinispan.distribution.ch.impl.AbstractConsistentHash;
import org.infinispan.distribution.ch.impl.PersistedMembers;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=1162)
public class ReplicatedConsistentHash
implements ConsistentHash {
    private static final String STATE_PRIMARY_OWNERS = "primaryOwners.%d";
    private static final String STATE_PRIMARY_OWNERS_COUNT = "primaryOwners";
    private final List<Integer> primaryOwners;
    private final List<Address> members;
    private final List<Address> membersWithState;
    private final Set<Address> membersWithStateSet;
    private final List<Address> membersWithoutState;
    private final Map<Address, Float> capacityFactors;
    private final Set<Integer> segments;

    public ReplicatedConsistentHash(List<Address> members, List<Integer> primaryOwners) {
        this(members, null, Collections.emptyList(), primaryOwners);
    }

    public ReplicatedConsistentHash(List<Address> members, Map<Address, Float> capacityFactors, List<Address> membersWithoutState, List<Integer> primaryOwners) {
        this.members = List.copyOf(members);
        this.membersWithoutState = List.copyOf(membersWithoutState);
        this.membersWithState = this.computeMembersWithState(members, membersWithoutState);
        this.membersWithStateSet = Set.copyOf(this.membersWithState);
        this.primaryOwners = primaryOwners;
        this.capacityFactors = capacityFactors == null ? null : Map.copyOf(capacityFactors);
        this.segments = IntSets.immutableRangeSet((int)primaryOwners.size());
    }

    @ProtoFactory
    static ReplicatedConsistentHash protoFactory(List<Address> members, List<Integer> primaryOwners, MarshallableMap<Address, Float> capacityFactors, List<Address> membersWithoutState) {
        return new ReplicatedConsistentHash(members, MarshallableMap.unwrap(capacityFactors), membersWithoutState, primaryOwners);
    }

    @Override
    @ProtoField(value=1)
    public List<Address> getMembers() {
        return this.members;
    }

    @ProtoField(value=2)
    List<Integer> getPrimaryOwners() {
        return this.primaryOwners;
    }

    @ProtoField(value=3)
    MarshallableMap<Address, Float> capacityFactors() {
        return MarshallableMap.create(this.capacityFactors);
    }

    @ProtoField(value=4)
    List<Address> getMembersWithoutState() {
        return this.membersWithoutState;
    }

    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch2) {
        HashMap<Address, Float> unionCapacityFactors;
        if (this.getNumSegments() != ch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.members);
        for (Address address : ch2.getMembers()) {
            if (this.members.contains(address)) continue;
            unionMembers.add(address);
        }
        ArrayList<Address> unionMembersWithoutState = new ArrayList<Address>(this.membersWithoutState);
        for (Address member : ch2.membersWithoutState) {
            if (ch2.membersWithStateSet.contains(member) || unionMembersWithoutState.contains(member)) continue;
            unionMembersWithoutState.add(member);
        }
        int n = this.getNumSegments();
        ArrayList<Integer> primaryOwners = new ArrayList<Integer>(n);
        for (int segmentId = 0; segmentId < n; ++segmentId) {
            Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
            int primaryOwnerIndex = unionMembers.indexOf(primaryOwner);
            primaryOwners.add(primaryOwnerIndex);
        }
        if (this.capacityFactors == null && ch2.capacityFactors == null) {
            unionCapacityFactors = null;
        } else if (this.capacityFactors == null) {
            unionCapacityFactors = new HashMap<Address, Float>(ch2.capacityFactors);
            for (Address address : this.members) {
                unionCapacityFactors.put(address, Float.valueOf(1.0f));
            }
        } else if (ch2.capacityFactors == null) {
            unionCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            for (Address address : ch2.members) {
                unionCapacityFactors.put(address, Float.valueOf(1.0f));
            }
        } else {
            unionCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            unionCapacityFactors.putAll(ch2.capacityFactors);
        }
        return new ReplicatedConsistentHash(unionMembers, unionCapacityFactors, unionMembersWithoutState, primaryOwners);
    }

    static PersistedConsistentHash<ReplicatedConsistentHash> fromPersistentScope(ScopedPersistentState state, Function<UUID, Address> addressMapper) {
        PersistedMembers members = ReplicatedConsistentHash.parseMembers(state, "members", "member.%d", addressMapper, true);
        HashSet<UUID> missingUuids = new HashSet<UUID>(members.missingUuids());
        PersistedMembers membersWithoutState = ReplicatedConsistentHash.parseMembers(state, "membersNoEntries", "memberNoEntries.%d", addressMapper, false);
        missingUuids.addAll(membersWithoutState.missingUuids());
        List<Integer> primaryOwners = ReplicatedConsistentHash.parsePrimaryOwners(state);
        ReplicatedConsistentHash ch = new ReplicatedConsistentHash(members.members(), members.capacityFactors(), membersWithoutState.members(), primaryOwners);
        return new PersistedConsistentHash<ReplicatedConsistentHash>(ch, missingUuids);
    }

    private static PersistedMembers parseMembers(ScopedPersistentState state, String numMembersPropertyName, String memberPropertyFormat, Function<UUID, Address> addressMapper, boolean parseCapacityFactors) {
        String numCapacityFactorsString;
        String property = state.getProperty(numMembersPropertyName);
        if (property == null) {
            return new PersistedMembers(List.of(), null, Set.of());
        }
        int numMembers = Integer.parseInt(property);
        ArrayList<Address> members = new ArrayList<Address>(numMembers);
        ArrayList<UUID> missingUuids = new ArrayList<UUID>(numMembers);
        HashMap<Address, Float> capacityFactors = null;
        if (parseCapacityFactors) {
            capacityFactors = new HashMap<Address, Float>();
        }
        boolean version11State = (numCapacityFactorsString = state.getProperty("capacityFactors")) == null;
        for (int i = 0; i < numMembers; ++i) {
            UUID uuid = UUID.fromString(state.getProperty(String.format(memberPropertyFormat, i)));
            Address address = addressMapper.apply(uuid);
            if (address == null) {
                missingUuids.add(uuid);
                continue;
            }
            members.add(address);
            if (capacityFactors == null) continue;
            if (version11State) {
                capacityFactors.put(address, Float.valueOf(1.0f));
                continue;
            }
            String cf = state.getProperty(String.format("capacityFactor.%d", i));
            if (cf == null) continue;
            capacityFactors.put(address, Float.valueOf(Float.parseFloat(cf)));
        }
        return new PersistedMembers(members, capacityFactors, missingUuids);
    }

    private static List<Integer> parsePrimaryOwners(ScopedPersistentState state) {
        int numPrimaryOwners = state.getIntProperty(STATE_PRIMARY_OWNERS_COUNT);
        ArrayList<Integer> primaryOwners = new ArrayList<Integer>(numPrimaryOwners);
        for (int i = 0; i < numPrimaryOwners; ++i) {
            primaryOwners.add(state.getIntProperty(String.format(STATE_PRIMARY_OWNERS, i)));
        }
        return primaryOwners;
    }

    @Override
    public int getNumSegments() {
        return this.primaryOwners.size();
    }

    public int getNumOwners() {
        return this.membersWithState.size();
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
        ArrayList<Address> owners = new ArrayList<Address>(this.membersWithState.size());
        owners.add(primaryOwner);
        for (Address member : this.membersWithState) {
            if (member.equals(primaryOwner)) continue;
            owners.add(member);
        }
        return owners;
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.members.get(this.primaryOwners.get(segmentId));
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (this.membersWithStateSet.contains(owner)) {
            return this.segments;
        }
        return IntSets.immutableEmptySet();
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        int index = this.members.indexOf(owner);
        if (index == -1) {
            return IntSets.immutableEmptySet();
        }
        IntSet primarySegments = IntSets.mutableEmptySet((int)this.primaryOwners.size());
        for (int i = 0; i < this.primaryOwners.size(); ++i) {
            if (this.primaryOwners.get(i) != index) continue;
            primarySegments.set(i);
        }
        return primarySegments;
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.primaryOwners.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(i).append(": ").append(this.primaryOwners.get(i));
        }
        if (!this.membersWithoutState.isEmpty()) {
            sb.append("none:");
            for (Address a : this.membersWithoutState) {
                sb.append(' ').append(a);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return this.membersWithStateSet.contains(nodeAddress);
    }

    @Override
    public boolean isReplicated() {
        return true;
    }

    @Override
    public void toScopedState(ScopedPersistentState state, Function<Address, UUID> addressMapper) {
        int i;
        state.setProperty("consistentHash", this.getClass().getName());
        AbstractConsistentHash.writeAddressToState(state, this.members, "members", "member.%d", addressMapper);
        AbstractConsistentHash.writeAddressToState(state, this.membersWithoutState, "membersNoEntries", "memberNoEntries.%d", addressMapper);
        state.setProperty("capacityFactors", Integer.toString(this.capacityFactors.size()));
        for (i = 0; i < this.members.size(); ++i) {
            state.setProperty(String.format("capacityFactor.%d", i), this.capacityFactors.get(this.members.get(i)).toString());
        }
        state.setProperty(STATE_PRIMARY_OWNERS_COUNT, Integer.toString(this.primaryOwners.size()));
        for (i = 0; i < this.primaryOwners.size(); ++i) {
            state.setProperty(String.format(STATE_PRIMARY_OWNERS, i), Integer.toString(this.primaryOwners.get(i)));
        }
    }

    @Override
    public Map<Address, Float> getCapacityFactors() {
        return this.capacityFactors;
    }

    private List<Address> computeMembersWithState(List<Address> members, List<Address> membersWithoutState) {
        if (membersWithoutState.isEmpty()) {
            return members;
        }
        ArrayList<Address> membersWithState = new ArrayList<Address>(members);
        membersWithState.removeAll(membersWithoutState);
        return List.copyOf(membersWithState);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicatedConsistentHash{");
        sb.append("ns = ").append(this.primaryOwners.size());
        sb.append(", owners = (").append(this.members.size()).append(")[");
        int[] primaryOwned = new int[this.members.size()];
        Iterator<Integer> iterator = this.primaryOwners.iterator();
        while (iterator.hasNext()) {
            int primaryOwner;
            int n = primaryOwner = iterator.next().intValue();
            primaryOwned[n] = primaryOwned[n] + 1;
        }
        boolean first = true;
        for (int i = 0; i < this.members.size(); ++i) {
            Address a = this.members.get(i);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(a).append(": ").append(primaryOwned[i]);
            sb.append("+");
            if (this.membersWithStateSet.contains(a)) {
                sb.append(this.getNumSegments() - primaryOwned[i]);
                continue;
            }
            sb.append("0");
        }
        sb.append("]}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        result = 31 * result + (this.membersWithoutState == null ? 0 : this.membersWithoutState.hashCode());
        result = 31 * result + this.primaryOwners.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicatedConsistentHash other = (ReplicatedConsistentHash)obj;
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        if (this.membersWithoutState == null ? other.membersWithoutState != null : !this.membersWithoutState.equals(other.membersWithoutState)) {
            return false;
        }
        return Objects.equals(this.primaryOwners, other.primaryOwners);
    }
}

