/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1125)
public class MetadataTransientCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    protected Metadata metadata;
    protected long lastUsed;

    public MetadataTransientCacheEntry(Object key, Object value, Metadata metadata, long lastUsed) {
        this(key, value, null, metadata, lastUsed);
    }

    protected MetadataTransientCacheEntry(Object key, Object value, PrivateMetadata internalMetadata, Metadata metadata, long lastUsed) {
        super(key, value, internalMetadata);
        this.metadata = metadata;
        this.lastUsed = lastUsed;
    }

    @ProtoFactory
    protected MetadataTransientCacheEntry(MarshallableObject<?> wrappedKey, MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, MarshallableObject<Metadata> wrappedMetadata, long lastUsed) {
        super(wrappedKey, wrappedValue, internalMetadata);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.lastUsed = lastUsed;
    }

    @ProtoField(number=4, name="metadata")
    MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    @ProtoField(value=5)
    public final long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public void reincarnate(long now) {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean canExpireMaxIdle() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.metadata.maxIdle(), this.lastUsed, now);
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        long maxIdle = this.metadata.maxIdle();
        return maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
    }

    @Override
    public final long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    public InternalCacheValue<?> toInternalCacheValue() {
        return new MetadataTransientCacheValue(this.value, this.internalMetadata, this.metadata, this.lastUsed);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", lastUsed=").append(this.lastUsed);
    }
}

