/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.function.Supplier;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.GlobalStatePathConfiguration;
import org.infinispan.configuration.global.GlobalStatePathConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStorageConfigurationBuilder;
import org.infinispan.configuration.global.TemporaryGlobalStatePathConfigurationBuilder;
import org.infinispan.configuration.global.UncleanShutdownAction;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.util.logging.Log;

public class GlobalStateConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalStateConfiguration> {
    private final AttributeSet attributes = GlobalStateConfiguration.attributeDefinitionSet();
    private final GlobalStatePathConfigurationBuilder persistentLocation;
    private final GlobalStatePathConfigurationBuilder sharedPersistentLocation;
    private final TemporaryGlobalStatePathConfigurationBuilder temporaryLocation;
    private final GlobalStorageConfigurationBuilder storageConfiguration;

    GlobalStateConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.persistentLocation = new GlobalStatePathConfigurationBuilder(globalConfig, Element.PERSISTENT_LOCATION.getLocalName());
        this.sharedPersistentLocation = new GlobalStatePathConfigurationBuilder(globalConfig, Element.SHARED_PERSISTENT_LOCATION.getLocalName());
        this.temporaryLocation = new TemporaryGlobalStatePathConfigurationBuilder(globalConfig);
        this.storageConfiguration = new GlobalStorageConfigurationBuilder(globalConfig);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public GlobalStateConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public GlobalStateConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public GlobalStateConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GlobalStateConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(GlobalStateConfiguration.ENABLED).get();
    }

    public GlobalStateConfigurationBuilder uncleanShutdownAction(UncleanShutdownAction action) {
        this.attributes.attribute(GlobalStateConfiguration.UNCLEAN_SHUTDOWN_ACTION).set((Object)action);
        return this;
    }

    public GlobalStateConfigurationBuilder persistentLocation(String location) {
        this.persistentLocation.location(location, null);
        return this;
    }

    public GlobalStateConfigurationBuilder persistentLocation(String path, String relativeTo) {
        this.persistentLocation.location(path, relativeTo);
        return this;
    }

    public GlobalStateConfigurationBuilder sharedPersistentLocation(String location) {
        this.sharedPersistentLocation.location(location, null);
        return this;
    }

    public GlobalStateConfigurationBuilder sharedPersistentLocation(String path, String relativeTo) {
        this.sharedPersistentLocation.location(path, relativeTo);
        return this;
    }

    public GlobalStateConfigurationBuilder temporaryLocation(String location) {
        this.temporaryLocation.location(location, null);
        return this;
    }

    public GlobalStateConfigurationBuilder temporaryLocation(String path, String relativeTo) {
        this.temporaryLocation.location(path, relativeTo);
        return this;
    }

    public GlobalStateConfigurationBuilder configurationStorage(ConfigurationStorage storage) {
        this.storageConfiguration.configurationStorage(storage);
        return this;
    }

    public GlobalStateConfigurationBuilder configurationStorageSupplier(Supplier<? extends LocalConfigurationStorage> configurationStorageSupplier) {
        this.storageConfiguration.supplier(configurationStorageSupplier);
        return this;
    }

    public void validate() {
        if (((Boolean)this.attributes.attribute(GlobalStateConfiguration.ENABLED).get()).booleanValue() && this.persistentLocation.getLocation() == null) {
            Log.CONFIG.missingGlobalStatePersistentLocation();
        }
        if (!((Boolean)this.attributes.attribute(GlobalStateConfiguration.ENABLED).get()).booleanValue() && this.persistentLocation.attributes().attribute(GlobalStatePathConfiguration.PATH).isModified()) {
            throw new CacheConfigurationException("GlobalState persistent location set, but state not enabled");
        }
        this.storageConfiguration.validate();
    }

    public GlobalStateConfiguration create() {
        return new GlobalStateConfiguration(this.attributes.protect(), this.persistentLocation.create(), this.sharedPersistentLocation.create(), this.temporaryLocation.create(), this.storageConfiguration.create());
    }

    public Builder<?> read(GlobalStateConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.persistentLocation.read(template.persistenceConfiguration(), combine);
        this.sharedPersistentLocation.read(template.sharedPersistenceConfiguration(), combine);
        this.temporaryLocation.read(template.temporaryLocationConfiguration(), combine);
        this.storageConfiguration.read(template.globalStorageConfiguration(), combine);
        return this;
    }
}

