/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.statetransfer.AbstractStateTransferCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1179)
public class StateTransferStartCommand
extends AbstractStateTransferCommand {
    @ProtoFactory
    StateTransferStartCommand(ByteString cacheName, int topologyId, WrappedMessage wrappedSegments) {
        this(cacheName, topologyId, (IntSet)WrappedMessages.unwrap(wrappedSegments));
    }

    public StateTransferStartCommand(ByteString cacheName, int topologyId, IntSet segments) {
        super(cacheName, topologyId, segments);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        StateProvider stateProvider = registry.getStateTransferManager().getStateProvider();
        stateProvider.startOutboundTransfer(this.origin, this.topologyId, this.segments, true);
        return CompletableFutures.completedNull();
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "StateTransferStartCommand{topologyId=" + this.topologyId + ", segments=" + String.valueOf(this.segments) + ", cacheName=" + String.valueOf(this.cacheName) + "}";
    }
}

