/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.events;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.metrics.Constants;
import org.infinispan.metrics.impl.MetricUtils;
import org.infinispan.metrics.impl.MetricsRegistry;
import org.infinispan.remoting.transport.Transport;

class XSiteViewMetrics
implements Constants {
    private static final int OFFLINE = 0;
    private static final int ONLINE = 1;
    private static final int UNKNOWN = 2;
    private static final Collection<MetricInfo> METRIC = List.of(MetricUtils.createGauge("SiteViewStatus", "Returns the site status in JGroups view (0 -> offline, 1 -> online, 2 -> n/a)", AtomicInteger::get, null));
    private final Map<String, SiteStatusMetric> siteMetrics;
    private final Supplier<MetricsRegistry> metricsRegistrySupplier;
    private final Supplier<Transport> transportSupplier;

    XSiteViewMetrics(Supplier<MetricsRegistry> metricsRegistrySupplier, Supplier<Transport> transportSupplier) {
        this.metricsRegistrySupplier = metricsRegistrySupplier;
        this.transportSupplier = transportSupplier;
        this.siteMetrics = new ConcurrentHashMap<String, SiteStatusMetric>(2);
    }

    void stop() {
        MetricsRegistry registry = this.metricsRegistrySupplier.get();
        this.siteMetrics.values().stream().map(SiteStatusMetric::metricId).forEach(registry::unregisterMetric);
        this.siteMetrics.clear();
    }

    void onNewCrossSiteView(Collection<String> joiners, Collection<String> leavers) {
        joiners.forEach(this::handleJoiner);
        leavers.forEach(this::handleLeaver);
    }

    void onSiteCoordinatorPromotion(Collection<String> siteView) {
        this.siteMetrics.forEach((siteName, metric) -> metric.status.set(siteView.contains(siteName) ? 1 : 0));
    }

    void markAllUnknown() {
        this.siteMetrics.forEach((siteName, metric) -> metric.status.set(2));
    }

    void onNewSiteFound(String siteName, Collection<String> siteView) {
        SiteStatusMetric metric = this.siteMetrics.computeIfAbsent(siteName, this::create);
        if (siteView != null) {
            metric.status.set(siteView.contains(siteName) ? 1 : 0);
        }
    }

    private void handleJoiner(String siteName) {
        this.siteMetrics.computeIfPresent(siteName, this::setOnline);
    }

    private void handleLeaver(String siteName) {
        this.siteMetrics.computeIfPresent(siteName, this::setOffline);
    }

    private SiteStatusMetric create(String siteName) {
        MetricsRegistry registry = this.metricsRegistrySupplier.get();
        AtomicInteger status = new AtomicInteger(2);
        Set<Object> metricId = registry.legacy() ? registry.registerMetrics(status, METRIC, "vendor.jgroups_", this.metricTags(siteName)) : registry.registerMetrics(status, METRIC, "jgroups_", this.metricTags(siteName));
        return new SiteStatusMetric(metricId, status);
    }

    private SiteStatusMetric setOnline(String siteName, SiteStatusMetric metric) {
        metric.status.set(1);
        return metric;
    }

    private SiteStatusMetric setOffline(String siteName, SiteStatusMetric metric) {
        metric.status.set(0);
        return metric;
    }

    private Map<String, String> metricTags(String siteName) {
        Transport transport = this.transportSupplier.get();
        return Map.of("node", String.valueOf(transport.getAddress()), "site", siteName);
    }

    private record SiteStatusMetric(Object metricId, AtomicInteger status) {
    }
}

