/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import com.google.errorprone.annotations.Immutable;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.StatsCollector;

@Immutable
public class StatsImpl
implements Stats {
    private static final String[] ATTRIBUTES = new String[]{"timeSinceReset", "timeSinceStart", "numberOfEntries", "numberOfEntriesInMemory", "offHeapMemoryUsed", "dataMemoryUsed", "retrievals", "stores", "hits", "misses", "removeHits", "removeMisses", "evictions", "averageReadTime", "averageRemoveTime", "averageWriteTime", "averageReadTimeNanos", "averageRemoveTimeNanos", "averageWriteTimeNanos", "minRequiredNodes", "approximateEntries", "approximateEntriesInMemory", "approximateEntriesUnique"};
    private final Map<String, Long> statsMap = new HashMap<String, Long>();
    private final CacheMgmtInterceptor mgmtInterceptor;
    private final Stats source;

    public static Stats create(Configuration configuration, AsyncInterceptorChain chain) {
        return new StatsImpl(chain.findInterceptorExtending(CacheMgmtInterceptor.class));
    }

    public static Stats create(StatsCollector collector) {
        if (collector == null || !collector.getStatisticsEnabled()) {
            return new StatsImpl();
        }
        return new StatsImpl(collector);
    }

    private StatsImpl() {
        this.source = null;
        this.mgmtInterceptor = null;
        this.emptyStats();
    }

    private StatsImpl(CacheMgmtInterceptor mgmtInterceptor) {
        this.source = null;
        this.mgmtInterceptor = mgmtInterceptor;
        if (mgmtInterceptor != null && mgmtInterceptor.getStatisticsEnabled()) {
            this.statsMap.put("timeSinceReset", mgmtInterceptor.getTimeSinceReset());
            this.statsMap.put("timeSinceStart", mgmtInterceptor.getTimeSinceStart());
            this.statsMap.put("approximateEntries", mgmtInterceptor.getApproximateEntries());
            this.statsMap.put("approximateEntriesInMemory", mgmtInterceptor.getApproximateEntriesInMemory());
            this.statsMap.put("approximateEntriesUnique", mgmtInterceptor.getApproximateEntriesUnique());
            this.statsMap.put("numberOfEntries", Long.valueOf(mgmtInterceptor.getNumberOfEntries()));
            this.statsMap.put("numberOfEntriesInMemory", Long.valueOf(mgmtInterceptor.getNumberOfEntriesInMemory()));
            this.statsMap.put("dataMemoryUsed", mgmtInterceptor.getDataMemoryUsed());
            this.statsMap.put("offHeapMemoryUsed", mgmtInterceptor.getOffHeapMemoryUsed());
            this.statsMap.put("retrievals", mgmtInterceptor.getHits() + mgmtInterceptor.getMisses());
            this.statsMap.put("stores", mgmtInterceptor.getStores());
            this.statsMap.put("hits", mgmtInterceptor.getHits());
            this.statsMap.put("misses", mgmtInterceptor.getMisses());
            this.statsMap.put("removeHits", mgmtInterceptor.getRemoveHits());
            this.statsMap.put("removeMisses", mgmtInterceptor.getRemoveMisses());
            this.statsMap.put("evictions", mgmtInterceptor.getEvictions());
            this.statsMap.put("averageReadTime", mgmtInterceptor.getAverageReadTime());
            this.statsMap.put("averageRemoveTime", mgmtInterceptor.getAverageRemoveTime());
            this.statsMap.put("averageWriteTime", mgmtInterceptor.getAverageWriteTime());
            this.statsMap.put("averageReadTimeNanos", mgmtInterceptor.getAverageReadTimeNanos());
            this.statsMap.put("averageRemoveTimeNanos", mgmtInterceptor.getAverageRemoveTimeNanos());
            this.statsMap.put("averageWriteTimeNanos", mgmtInterceptor.getAverageWriteTimeNanos());
            this.statsMap.put("minRequiredNodes", Long.valueOf(mgmtInterceptor.getRequiredMinimumNumberOfNodes()));
        } else {
            this.emptyStats();
        }
    }

    private StatsImpl(Stats other) {
        this.source = other;
        this.mgmtInterceptor = null;
        this.statsMap.put("timeSinceReset", other.getTimeSinceReset());
        this.statsMap.put("timeSinceStart", other.getTimeSinceStart());
        this.statsMap.put("approximateEntries", other.getApproximateEntries());
        this.statsMap.put("approximateEntriesInMemory", other.getApproximateEntriesInMemory());
        this.statsMap.put("approximateEntriesUnique", other.getApproximateEntriesUnique());
        this.statsMap.put("numberOfEntries", Long.valueOf(other.getCurrentNumberOfEntries()));
        this.statsMap.put("numberOfEntriesInMemory", Long.valueOf(other.getCurrentNumberOfEntriesInMemory()));
        this.statsMap.put("dataMemoryUsed", other.getDataMemoryUsed());
        this.statsMap.put("offHeapMemoryUsed", other.getOffHeapMemoryUsed());
        this.statsMap.put("retrievals", other.getHits() + other.getMisses());
        this.statsMap.put("stores", other.getStores());
        this.statsMap.put("hits", other.getHits());
        this.statsMap.put("misses", other.getMisses());
        this.statsMap.put("removeHits", other.getRemoveHits());
        this.statsMap.put("removeMisses", other.getRemoveMisses());
        this.statsMap.put("evictions", other.getEvictions());
        this.statsMap.put("averageReadTime", other.getAverageReadTime());
        this.statsMap.put("averageRemoveTime", other.getAverageRemoveTime());
        this.statsMap.put("averageWriteTime", other.getAverageWriteTime());
        this.statsMap.put("averageReadTimeNanos", other.getAverageReadTimeNanos());
        this.statsMap.put("averageRemoveTimeNanos", other.getAverageRemoveTimeNanos());
        this.statsMap.put("averageWriteTimeNanos", other.getAverageWriteTimeNanos());
        this.statsMap.put("minRequiredNodes", Long.valueOf(other.getRequiredMinimumNumberOfNodes()));
    }

    private void emptyStats() {
        for (String key : ATTRIBUTES) {
            this.statsMap.put(key, -1L);
        }
    }

    @Override
    public long getTimeSinceStart() {
        return this.statsMap.get("timeSinceStart");
    }

    @Override
    public long getTimeSinceReset() {
        return this.statsMap.get("timeSinceReset");
    }

    @Override
    public long getApproximateEntries() {
        return this.statsMap.get("approximateEntries");
    }

    @Override
    public long getApproximateEntriesInMemory() {
        return this.statsMap.get("approximateEntriesInMemory");
    }

    @Override
    public long getApproximateEntriesUnique() {
        return this.statsMap.get("approximateEntriesUnique");
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return Math.toIntExact(this.statsMap.get("numberOfEntries"));
    }

    @Override
    public int getCurrentNumberOfEntriesInMemory() {
        return Math.toIntExact(this.statsMap.get("numberOfEntriesInMemory"));
    }

    @Override
    public long getDataMemoryUsed() {
        return this.statsMap.get("dataMemoryUsed");
    }

    @Override
    public long getOffHeapMemoryUsed() {
        return this.statsMap.get("offHeapMemoryUsed");
    }

    @Override
    public long getRetrievals() {
        return this.statsMap.get("retrievals");
    }

    @Override
    public long getStores() {
        return this.statsMap.get("stores");
    }

    @Override
    public long getHits() {
        return this.statsMap.get("hits");
    }

    @Override
    public long getMisses() {
        return this.statsMap.get("misses");
    }

    @Override
    public long getRemoveHits() {
        return this.statsMap.get("removeHits");
    }

    @Override
    public long getRemoveMisses() {
        return this.statsMap.get("removeMisses");
    }

    @Override
    public long getEvictions() {
        return this.statsMap.get("evictions");
    }

    @Override
    public long getAverageReadTime() {
        return this.statsMap.get("averageReadTime");
    }

    @Override
    public long getAverageWriteTime() {
        return this.statsMap.get("averageWriteTime");
    }

    @Override
    public long getAverageRemoveTime() {
        return this.statsMap.get("averageRemoveTime");
    }

    @Override
    public long getAverageReadTimeNanos() {
        return this.statsMap.get("averageReadTimeNanos");
    }

    @Override
    public long getAverageWriteTimeNanos() {
        return this.statsMap.get("averageWriteTimeNanos");
    }

    @Override
    public long getAverageRemoveTimeNanos() {
        return this.statsMap.get("averageRemoveTimeNanos");
    }

    @Override
    public int getRequiredMinimumNumberOfNodes() {
        return Math.toIntExact(this.statsMap.get("minRequiredNodes"));
    }

    @Override
    public void reset() {
        if (this.mgmtInterceptor != null) {
            this.mgmtInterceptor.resetStatistics();
        } else if (this.source != null) {
            this.source.reset();
        }
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        if (this.mgmtInterceptor != null) {
            this.mgmtInterceptor.setStatisticsEnabled(enabled);
        } else if (this.source != null) {
            this.source.setStatisticsEnabled(enabled);
        }
    }
}

