/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.functional.Param;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1080)
@Experimental
public final class Params {
    private static final Param<?>[] DEFAULTS = new Param[]{Param.PersistenceMode.defaultValue(), Param.LockingMode.defaultValue(), Param.ExecutionMode.defaultValue(), Param.StatisticsMode.defaultValue(), Param.ReplicationMode.defaultValue()};
    private static final Params DEFAULT_INSTANCE = new Params(DEFAULTS);
    final Param<?>[] params;

    private Params(Param<?>[] params) {
        this.params = params;
    }

    @ProtoFactory
    static Params protoFactory(byte bits) {
        Param.PersistenceMode persistenceMode = Param.PersistenceMode.valueOf(bits & 3);
        Param.LockingMode lockingMode = Param.LockingMode.valueOf(bits >>> 2 & 3);
        Param.ExecutionMode executionMode = Param.ExecutionMode.valueOf(bits >>> 4 & 3);
        Param.StatisticsMode statisticsMode = Param.StatisticsMode.valueOf(bits >>> 6 & 1);
        Param.ReplicationMode replicationMode = Param.ReplicationMode.valueOf(bits >>> 7 & 1);
        if (persistenceMode == Param.PersistenceMode.defaultValue() && lockingMode == Param.LockingMode.defaultValue() && executionMode == Param.ExecutionMode.defaultValue() && statisticsMode == Param.StatisticsMode.defaultValue() && replicationMode == Param.ReplicationMode.defaultValue()) {
            return DEFAULT_INSTANCE;
        }
        Param<?>[] params = Arrays.copyOf(DEFAULTS, DEFAULTS.length);
        params[0] = persistenceMode;
        params[1] = lockingMode;
        params[2] = executionMode;
        params[3] = statisticsMode;
        params[4] = replicationMode;
        return new Params(params);
    }

    @ProtoField(value=1)
    byte getBits() {
        Param.PersistenceMode persistenceMode = (Param.PersistenceMode)this.get(0).get();
        Param.LockingMode lockingMode = (Param.LockingMode)this.get(1).get();
        Param.ExecutionMode executionMode = (Param.ExecutionMode)this.get(2).get();
        Param.StatisticsMode statisticsMode = (Param.StatisticsMode)this.get(3).get();
        Param.ReplicationMode replicationMode = (Param.ReplicationMode)this.get(4).get();
        return (byte)(persistenceMode.ordinal() | lockingMode.ordinal() << 2 | executionMode.ordinal() << 4 | statisticsMode.ordinal() << 6 | replicationMode.ordinal() << 7);
    }

    public boolean containsAll(Param<?> ... ps) {
        List<Param<?>> paramsToCheck = Arrays.asList(ps);
        List<Param<Param<?>>> paramsCurrent = Arrays.asList(this.params);
        return paramsCurrent.containsAll(paramsToCheck);
    }

    public Params addAll(Param<?> ... ps) {
        List<Param<?>> paramsToAdd = Arrays.asList(ps);
        Param[] paramsAll = Arrays.copyOf(this.params, this.params.length);
        paramsToAdd.forEach(p -> {
            paramsAll[p.id()] = p;
        });
        return new Params(paramsAll);
    }

    public Params add(Param<?> p) {
        Param<?>[] paramsAll = Arrays.copyOf(this.params, this.params.length);
        paramsAll[p.id()] = p;
        return new Params(paramsAll);
    }

    public Params addAll(Params ps) {
        if (ps == DEFAULT_INSTANCE) {
            return this;
        }
        Param<?>[] paramsAll = Arrays.copyOf(this.params, this.params.length);
        for (int i = 0; i < this.params.length; ++i) {
            if (ps.params[i].equals(DEFAULTS[i])) continue;
            paramsAll[i] = ps.params[i];
        }
        return new Params(paramsAll);
    }

    public <T> Param<T> get(int index) {
        return this.params[index];
    }

    public String toString() {
        return "Params=" + Arrays.toString(this.params);
    }

    public long toFlagsBitSet() {
        Param.PersistenceMode persistenceMode = (Param.PersistenceMode)this.params[0].get();
        Param.LockingMode lockingMode = (Param.LockingMode)this.params[1].get();
        Param.ExecutionMode executionMode = (Param.ExecutionMode)this.params[2].get();
        Param.StatisticsMode statisticsMode = (Param.StatisticsMode)this.params[3].get();
        Param.ReplicationMode replicationMode = (Param.ReplicationMode)this.params[4].get();
        long flagsBitSet = 0L;
        switch (persistenceMode) {
            case SKIP_PERSIST: {
                flagsBitSet |= FlagBitSets.SKIP_CACHE_STORE;
                break;
            }
            case SKIP_LOAD: {
                flagsBitSet |= FlagBitSets.SKIP_CACHE_LOAD;
                break;
            }
            case SKIP: {
                flagsBitSet |= FlagBitSets.SKIP_CACHE_LOAD | FlagBitSets.SKIP_CACHE_STORE;
            }
        }
        switch (lockingMode) {
            case SKIP: {
                flagsBitSet |= FlagBitSets.SKIP_LOCKING;
                break;
            }
            case TRY_LOCK: {
                flagsBitSet |= FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT | FlagBitSets.FAIL_SILENTLY;
            }
        }
        switch (executionMode) {
            case LOCAL: {
                flagsBitSet |= FlagBitSets.CACHE_MODE_LOCAL;
                break;
            }
            case LOCAL_SITE: {
                flagsBitSet |= FlagBitSets.SKIP_XSITE_BACKUP;
            }
        }
        if (statisticsMode == Param.StatisticsMode.SKIP) {
            flagsBitSet |= FlagBitSets.SKIP_STATISTICS;
        }
        switch (replicationMode) {
            case SYNC: {
                flagsBitSet |= FlagBitSets.FORCE_SYNCHRONOUS;
                break;
            }
            case ASYNC: {
                flagsBitSet |= FlagBitSets.FORCE_ASYNCHRONOUS;
            }
        }
        return flagsBitSet;
    }

    public static Params fromFlagsBitSet(long flagsBitSet) {
        if (flagsBitSet == 0L) {
            return DEFAULT_INSTANCE;
        }
        Param<?>[] paramsAll = Arrays.copyOf(DEFAULTS, DEFAULTS.length);
        if ((flagsBitSet & (FlagBitSets.SKIP_CACHE_LOAD | FlagBitSets.SKIP_CACHE_STORE)) != 0L) {
            paramsAll[0] = Param.PersistenceMode.SKIP;
        } else if ((flagsBitSet & FlagBitSets.SKIP_CACHE_STORE) != 0L) {
            paramsAll[0] = Param.PersistenceMode.SKIP_PERSIST;
        } else if ((flagsBitSet & FlagBitSets.SKIP_CACHE_LOAD) != 0L) {
            paramsAll[0] = Param.PersistenceMode.SKIP_LOAD;
        }
        if ((flagsBitSet & FlagBitSets.SKIP_LOCKING) != 0L) {
            paramsAll[1] = Param.LockingMode.SKIP;
        } else if ((flagsBitSet & FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT) != 0L) {
            paramsAll[1] = Param.LockingMode.TRY_LOCK;
        }
        if ((flagsBitSet & FlagBitSets.CACHE_MODE_LOCAL) != 0L) {
            paramsAll[2] = Param.ExecutionMode.LOCAL;
        } else if ((flagsBitSet & FlagBitSets.SKIP_XSITE_BACKUP) != 0L) {
            paramsAll[2] = Param.ExecutionMode.LOCAL_SITE;
        }
        if ((flagsBitSet & FlagBitSets.SKIP_STATISTICS) != 0L) {
            paramsAll[3] = Param.StatisticsMode.SKIP;
        }
        if ((flagsBitSet & FlagBitSets.FORCE_ASYNCHRONOUS) != 0L) {
            paramsAll[4] = Param.ReplicationMode.ASYNC;
        } else if ((flagsBitSet & FlagBitSets.FORCE_SYNCHRONOUS) != 0L) {
            paramsAll[4] = Param.ReplicationMode.SYNC;
        }
        return new Params(paramsAll);
    }

    public static Params create() {
        return DEFAULT_INSTANCE;
    }

    public static Params from(Param<?> ... ps) {
        List<Param<?>> paramsToAdd = Arrays.asList(ps);
        List<Param<Param<?>>> paramsDefaults = Arrays.asList(DEFAULTS);
        if (paramsDefaults.containsAll(paramsToAdd)) {
            return Params.create();
        }
        Param[] paramsAll = Arrays.copyOf(DEFAULTS, DEFAULTS.length);
        paramsToAdd.forEach(p -> {
            paramsAll[p.id()] = p;
        });
        return new Params(paramsAll);
    }

    static {
        if (Param.PersistenceMode.values().length > 4) {
            throw new IllegalStateException();
        }
        if (Param.LockingMode.values().length > 4) {
            throw new IllegalStateException();
        }
        if (Param.ExecutionMode.values().length > 4) {
            throw new IllegalStateException();
        }
        if (Param.StatisticsMode.values().length > 2) {
            throw new IllegalStateException();
        }
        if (Param.ReplicationMode.values().length > 2) {
            throw new IllegalStateException();
        }
    }
}

