/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import com.google.errorprone.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.expiration.impl.ClusterExpirationManager;
import org.infinispan.transaction.LockingMode;

@ThreadSafe
public class TxClusterExpirationManager<K, V>
extends ClusterExpirationManager<K, V> {
    private boolean optimisticTransaction;

    @Override
    public void start() {
        super.start();
        this.optimisticTransaction = this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC;
    }

    @Override
    boolean waitOnLifespanExpiration(boolean isWrite) {
        return isWrite || this.optimisticTransaction;
    }

    @Override
    AdvancedCache<K, V> cacheToUse(boolean isWrite) {
        return isWrite ? (this.optimisticTransaction ? this.cache : this.cache.withFlags(Flag.SKIP_LOCKING)) : this.cache.withFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }
}

