/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@Immutable
@ProtoTypeId(value=9)
public class SimpleClusteredVersion
implements IncrementableEntryVersion {
    private final int topologyId;
    private final long version;

    @ProtoFactory
    public SimpleClusteredVersion(int topologyId, long version) {
        this.version = version;
        this.topologyId = topologyId;
    }

    @ProtoField(number=1, defaultValue="-1")
    public int getTopologyId() {
        return this.topologyId;
    }

    @ProtoField(number=2, defaultValue="-1")
    public long getVersion() {
        return this.version;
    }

    @Override
    public InequalVersionComparisonResult compareTo(EntryVersion other) {
        if (other instanceof SimpleClusteredVersion) {
            SimpleClusteredVersion otherVersion = (SimpleClusteredVersion)other;
            if (this.topologyId > otherVersion.topologyId) {
                return InequalVersionComparisonResult.AFTER;
            }
            if (this.topologyId < otherVersion.topologyId) {
                return InequalVersionComparisonResult.BEFORE;
            }
            if (this.version > otherVersion.version) {
                return InequalVersionComparisonResult.AFTER;
            }
            if (this.version < otherVersion.version) {
                return InequalVersionComparisonResult.BEFORE;
            }
            return InequalVersionComparisonResult.EQUAL;
        }
        throw new IllegalArgumentException("I only know how to deal with SimpleClusteredVersions, not " + other.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleClusteredVersion that = (SimpleClusteredVersion)o;
        return this.topologyId == that.topologyId && this.version == that.version;
    }

    public int hashCode() {
        return Objects.hash(this.topologyId, this.version);
    }

    public String toString() {
        return "SimpleClusteredVersion{topologyId=" + this.topologyId + ", version=" + this.version + "}";
    }
}

