/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1242)
public class TxCompletionNotificationCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    private static final Log log = LogFactory.getLog(TxCompletionNotificationCommand.class);
    @ProtoField(value=2)
    final XidImpl xid;
    @ProtoField(value=3)
    final long internalId;
    @ProtoField(value=4)
    final GlobalTransaction gtx;
    @ProtoField(value=5)
    int topologyId;

    @ProtoFactory
    TxCompletionNotificationCommand(ByteString cacheName, XidImpl xid, long internalId, GlobalTransaction gtx, int topologyId) {
        super(cacheName);
        this.xid = xid;
        this.internalId = internalId;
        this.gtx = gtx;
        this.topologyId = topologyId;
    }

    public TxCompletionNotificationCommand(XidImpl xid, GlobalTransaction gtx, ByteString cacheName) {
        this(cacheName, xid, -1L, gtx, -1);
    }

    public TxCompletionNotificationCommand(long internalId, ByteString cacheName) {
        this(cacheName, null, internalId, null, -1);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        if (log.isTraceEnabled()) {
            log.tracef("Processing completed transaction %s", this.gtx);
        }
        RemoteTransaction remoteTx = null;
        RecoveryManager recoveryManager = componentRegistry.getRecoveryManager().running();
        if (recoveryManager != null) {
            remoteTx = this.xid != null ? (RemoteTransaction)((Object)recoveryManager.removeRecoveryInformation(this.xid)) : (RemoteTransaction)((Object)recoveryManager.removeRecoveryInformation(this.internalId));
        }
        if (remoteTx == null && this.gtx != null) {
            TransactionTable txTable = componentRegistry.getTransactionTableRef().running();
            remoteTx = txTable.removeRemoteTransaction(this.gtx);
        }
        if (remoteTx == null) {
            return CompletableFutures.completedNull();
        }
        this.forwardCommandRemotely(remoteTx, componentRegistry);
        LockManager lockManager = componentRegistry.getLockManager().running();
        lockManager.unlockAll(remoteTx.getLockedKeys(), remoteTx.getGlobalTransaction());
        return CompletableFutures.completedNull();
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.gtx;
    }

    private void forwardCommandRemotely(RemoteTransaction remoteTx, ComponentRegistry registry) {
        LocalizedCacheTopology cacheTopology;
        DistributionManager distributionManager = registry.getDistributionManager();
        RpcManager rpcManager = registry.getRpcManager().running();
        Set<Object> affectedKeys = remoteTx.getAffectedKeys();
        if (log.isTraceEnabled()) {
            log.tracef("Invoking forward of TxCompletionNotification for transaction %s. Affected keys: %s", this.gtx, Util.toStr(affectedKeys));
        }
        if ((cacheTopology = distributionManager.getCacheTopology()) == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Not Forwarding command %s because topology is null.", this);
            }
            return;
        }
        int localTopologyId = cacheTopology.getTopologyId();
        if (log.isTraceEnabled()) {
            log.tracef("CommandTopologyId=%s, localTopologyId=%s", this.topologyId, localTopologyId);
        }
        if (this.topologyId >= localTopologyId) {
            return;
        }
        HashSet<Address> newTargets = new HashSet<Address>(cacheTopology.getWriteOwners(affectedKeys));
        newTargets.remove(rpcManager.getAddress());
        newTargets.remove(this.origin);
        if (!newTargets.isEmpty()) {
            this.topologyId = localTopologyId;
            if (log.isTraceEnabled()) {
                log.tracef("Forwarding command %s to new targets %s", this, newTargets);
            }
            rpcManager.sendToMany(newTargets, this, DeliverOrder.NONE);
        }
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ xid=" + String.valueOf(this.xid) + ", internalId=" + this.internalId + ", topologyId=" + this.topologyId + ", gtx=" + String.valueOf(this.gtx) + ", cacheName=" + String.valueOf(this.cacheName) + "} ";
    }
}

