/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1095)
public class IracMetadataRequestCommand
extends BaseIracCommand
implements TopologyAffectedCommand {
    @ProtoField(value=2)
    int segment;
    @ProtoField(value=3)
    int topologyId;
    @ProtoField(value=4)
    final IracEntryVersion versionSeen;

    public IracMetadataRequestCommand(ByteString cacheName, int segment, IracEntryVersion versionSeen) {
        this(cacheName, segment, -1, versionSeen);
    }

    @ProtoFactory
    IracMetadataRequestCommand(ByteString cacheName, int segment, int topologyId, IracEntryVersion versionSeen) {
        super(cacheName);
        this.segment = segment;
        this.topologyId = topologyId;
        this.versionSeen = versionSeen;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        return CompletableFuture.completedFuture(registry.getIracVersionGenerator().running().generateNewMetadata(this.segment, this.versionSeen));
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "IracMetadataRequestCommand{cacheName=" + String.valueOf(this.cacheName) + ", segment=" + this.segment + ", topologyId=" + this.topologyId + ", versionSeen=" + String.valueOf(this.versionSeen) + "}";
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }
}

