/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.Collection;
import java.util.function.Consumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;
import org.infinispan.marshall.protostream.impl.MarshallableCollection;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1251)
public final class WriteOnlyManyCommand<K, V>
extends AbstractWriteManyCommand<K, V> {
    private Collection<?> keys;
    private Consumer<EntryView.WriteEntryView<K, V>> f;

    public WriteOnlyManyCommand(ByteString cacheName, Collection<?> keys, Consumer<EntryView.WriteEntryView<K, V>> f, Params params, CommandInvocationId commandInvocationId, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(cacheName, commandInvocationId, params, keyDataConversion, valueDataConversion);
        this.keys = keys;
        this.f = f;
    }

    public WriteOnlyManyCommand(WriteOnlyManyCommand<K, V> command) {
        super(command);
        this.keys = command.keys;
        this.f = command.f;
    }

    @ProtoFactory
    WriteOnlyManyCommand(ByteString cacheName, CommandInvocationId commandInvocationId, boolean forwarded, int topologyId, Params params, long flags, DataConversion keyDataConversion, DataConversion valueDataConversion, MarshallableMap<Object, PrivateMetadata> internalMetadata, MarshallableCollection<?> keys, MarshallableObject<Consumer<EntryView.WriteEntryView<K, V>>> wrappedConsumer) {
        super(cacheName, commandInvocationId, forwarded, topologyId, params, flags, keyDataConversion, valueDataConversion, internalMetadata);
        this.keys = MarshallableCollection.unwrap(keys);
        this.f = MarshallableObject.unwrap(wrappedConsumer);
    }

    @ProtoField(value=10)
    MarshallableCollection<?> getKeys() {
        return MarshallableCollection.create(this.keys);
    }

    @ProtoField(number=11, name="consumer")
    MarshallableObject<Consumer<EntryView.WriteEntryView<K, V>>> getWrappedConsumer() {
        return MarshallableObject.create(this.f);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    public Consumer<EntryView.WriteEntryView<K, V>> getConsumer() {
        return this.f;
    }

    public void setKeys(Collection<?> keys) {
        this.keys = keys;
        this.internalMetadataMap.keySet().retainAll(keys);
    }

    public final WriteOnlyManyCommand<K, V> withKeys(Collection<?> keys) {
        this.setKeys(keys);
        return this;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyCommand(ctx, this);
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.keys;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }

    public String toString() {
        return "WriteOnlyManyCommand{keys=" + String.valueOf(this.keys) + ", f=" + this.f.getClass().getName() + ", forwarded=" + this.forwarded + ", keyDataConversion=" + String.valueOf(this.keyDataConversion) + ", valueDataConversion=" + String.valueOf(this.valueDataConversion) + "}";
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.keys;
    }

    @Override
    public Mutation<K, V, ?> toMutation(Object key) {
        return new Mutations.Write<K, V>(this.keyDataConversion, this.valueDataConversion, this.f);
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

