/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Objects;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.remoting.transport.jgroups.AddressCache;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@ProtoTypeId(value=10)
public class Address
implements Comparable<Address> {
    private static final byte[] VERSION_KEY = new byte[]{118};
    private static final byte[] SITE_KEY = new byte[]{115};
    private static final byte[] RACK_KEY = new byte[]{114};
    private static final byte[] MACHINE_KEY = new byte[]{109};
    public static final Address LOCAL = Address.random();
    private final java.util.UUID nodeUUID;
    @ProtoField(value=3)
    final NodeVersion version;
    @ProtoField(value=4)
    final String siteId;
    @ProtoField(value=5)
    final String rackId;
    @ProtoField(value=6)
    final String machineId;
    private transient String cachedName;

    public static Address random() {
        return Address.random(null, null, null, null);
    }

    public static Address random(String name) {
        return Address.random(name, null, null, null);
    }

    public static Address random(String name, String siteId, String rackId, String machineId) {
        ExtendedUUID uuid = Address.randomUUID(name);
        return new Address(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), NodeVersion.INSTANCE, siteId, rackId, machineId);
    }

    public static ExtendedUUID randomUUID() {
        return Address.randomUUID(null, null, null, null);
    }

    public static ExtendedUUID randomUUID(String name, String siteId, String rackId, String machineId) {
        return Address.randomUUID(name, NodeVersion.INSTANCE, siteId, rackId, machineId);
    }

    public static ExtendedUUID randomUUID(String name, NodeVersion version, String siteId, String rackId, String machineId) {
        ExtendedUUID uuid = Address.randomUUID(name);
        Address.addId(uuid, VERSION_KEY, version.toString());
        Address.addId(uuid, SITE_KEY, siteId);
        Address.addId(uuid, RACK_KEY, rackId);
        Address.addId(uuid, MACHINE_KEY, machineId);
        return uuid;
    }

    private static ExtendedUUID randomUUID(String name) {
        ExtendedUUID uuid = ExtendedUUID.randomUUID((String)name);
        if (name != null) {
            NameCache.add((org.jgroups.Address)uuid, (String)name);
        }
        return uuid;
    }

    public static ExtendedUUID toExtendedUUID(Address address) {
        ExtendedUUID uuid = new ExtendedUUID(address.getMostSignificantBits(), address.getLeastSignificantBits());
        Address.addId(uuid, VERSION_KEY, address.getVersion().toString());
        Address.addId(uuid, SITE_KEY, address.siteId);
        Address.addId(uuid, RACK_KEY, address.rackId);
        Address.addId(uuid, MACHINE_KEY, address.machineId);
        return uuid;
    }

    public static Address fromExtendedUUID(ExtendedUUID address) {
        return new Address(address.getMostSignificantBits(), address.getLeastSignificantBits(), NodeVersion.from(Util.bytesToString((byte[])address.get(VERSION_KEY))), Util.bytesToString((byte[])address.get(SITE_KEY)), Util.bytesToString((byte[])address.get(RACK_KEY)), Util.bytesToString((byte[])address.get(MACHINE_KEY)));
    }

    private static void addId(ExtendedUUID uuid, byte[] key, String stringValue) {
        if (stringValue != null) {
            uuid.put(key, Util.stringToBytes((String)stringValue));
        }
    }

    private Address(long mostSignificantBits, long leastSignificantBits, NodeVersion version, String siteId, String rackId, String machineId) {
        this(new java.util.UUID(mostSignificantBits, leastSignificantBits), version, siteId, rackId, machineId);
    }

    private Address(java.util.UUID nodeUUID, NodeVersion version, String siteId, String rackId, String machineId) {
        this.nodeUUID = nodeUUID;
        this.version = version;
        this.siteId = siteId;
        this.rackId = rackId;
        this.machineId = machineId;
    }

    @ProtoFactory
    public static Address protoFactory(long mostSignificantBits, long leastSignificantBits, NodeVersion version, String siteId, String rackId, String machineId) {
        Address existing = AddressCache.getIfPresent(mostSignificantBits, leastSignificantBits);
        if (existing != null) {
            return existing;
        }
        return new Address(new java.util.UUID(mostSignificantBits, leastSignificantBits), version, siteId, rackId, machineId);
    }

    public static Address fromNodeUUID(java.util.UUID nodeUUID) {
        return new Address(Objects.requireNonNull(nodeUUID), NodeVersion.INSTANCE, null, null, null);
    }

    public java.util.UUID getNodeUUID() {
        return this.nodeUUID;
    }

    @ProtoField(value=1, defaultValue="0")
    public long getMostSignificantBits() {
        return this.nodeUUID.getMostSignificantBits();
    }

    @ProtoField(value=2, defaultValue="0")
    public long getLeastSignificantBits() {
        return this.nodeUUID.getLeastSignificantBits();
    }

    public NodeVersion getVersion() {
        return this.version;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getRackId() {
        return this.rackId;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public boolean matches(String siteId, String rackId, String machineId) {
        return Objects.equals(siteId, this.siteId) && Objects.equals(rackId, this.rackId) && Objects.equals(machineId, this.machineId);
    }

    public boolean isSameSite(Address other) {
        return Objects.equals(this.siteId, other.getSiteId());
    }

    public boolean isSameRack(Address other) {
        return this.isSameSite(other) && Objects.equals(this.rackId, other.getRackId());
    }

    public boolean isSameMachine(Address other) {
        return this.isSameRack(other) && Objects.equals(this.machineId, other.getMachineId());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address that = (Address)o;
        return this.nodeUUID.equals(that.nodeUUID);
    }

    public int hashCode() {
        return this.nodeUUID.hashCode();
    }

    public String toString() {
        long least;
        if (this.cachedName != null) {
            return this.cachedName;
        }
        long most = this.getMostSignificantBits();
        String name = NameCache.get((org.jgroups.Address)new UUID(most, least = this.getLeastSignificantBits()));
        return name != null ? (this.cachedName = name) : Address.toStringLong(most, least);
    }

    @Override
    public int compareTo(Address other) {
        return this.nodeUUID.compareTo(other.nodeUUID);
    }

    public static String nodeUUIDToString(java.util.UUID nodeUUID) {
        long leastSignificantBits;
        if (nodeUUID == null) {
            return "local";
        }
        long mostSignificantBits = nodeUUID.getMostSignificantBits();
        String name = NameCache.get((org.jgroups.Address)new UUID(mostSignificantBits, leastSignificantBits = nodeUUID.getLeastSignificantBits()));
        return name == null ? Address.toStringLong(mostSignificantBits, leastSignificantBits) : name;
    }

    public static String toStringLong(long mostSignificantBits, long leastSignificantBits) {
        return Address.digits(mostSignificantBits >> 32, 8) + "-" + Address.digits(mostSignificantBits >> 16, 4) + "-" + Address.digits(mostSignificantBits, 4) + "-" + Address.digits(leastSignificantBits >> 48, 4) + "-" + Address.digits(leastSignificantBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }
}

