/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.GlobalStateProvider;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.util.logging.Log;

public final class GlobalStateHandler
implements GlobalStateManager {
    private final List<GlobalStateProvider> providers = new CopyOnWriteArrayList<GlobalStateProvider>();
    private String root;
    private TimeService timeService;

    public GlobalStateHandler(String root, TimeService timeService) {
        this.root = root;
        this.timeService = timeService;
    }

    GlobalStateHandler() {
    }

    void setRoot(String root) {
        this.root = root;
    }

    void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    ScopedPersistentState startStateHandler() {
        File stateFile = this.getStateFile("___global");
        ScopedPersistentState globalState = this.readScopedState("___global").orElse(null);
        if (globalState != null) {
            if (!stateFile.canWrite()) {
                throw Log.CONTAINER.nonWritableStateFile(stateFile);
            }
            if (!(globalState.containsProperty("@version") && globalState.containsProperty("version-major") && globalState.containsProperty("@timestamp"))) {
                throw Log.CONTAINER.invalidPersistentState("___global");
            }
            Log.CONTAINER.globalStateLoad(globalState.getProperty("@version"), globalState.getProperty("@timestamp"));
            this.providers.forEach(provider -> provider.prepareForRestore(globalState));
        } else {
            stateFile.getParentFile().mkdirs();
        }
        return globalState;
    }

    @Override
    public void registerStateProvider(GlobalStateProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public Optional<ScopedPersistentState> readScopedState(String scope) {
        Optional<ScopedPersistentState> optional;
        File stateFile = this.getStateFile(scope);
        if (!stateFile.exists()) {
            return Optional.empty();
        }
        BufferedReader r = new BufferedReader(new FileReader(stateFile));
        try {
            ScopedPersistentStateImpl state = new ScopedPersistentStateImpl(scope);
            String line = r.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    int eq = line.indexOf(61);
                    while (eq > 0 && line.charAt(eq - 1) == '\\') {
                        eq = line.indexOf(61, eq + 1);
                    }
                    if (eq > 0) {
                        state.setProperty(Util.unicodeUnescapeString((String)line.substring(0, eq).trim()), Util.unicodeUnescapeString((String)line.substring(eq + 1).trim()));
                    }
                }
                line = r.readLine();
            }
            optional = Optional.of(state);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Log.CONTAINER.failedReadingPersistentState(e, stateFile);
            }
        }
        r.close();
        return optional;
    }

    @Override
    public void writeScopedState(ScopedPersistentState state) {
        File stateFile = this.getStateFile(state.getScope());
        try (PrintWriter w = new PrintWriter(stateFile);){
            state.forEach((key, value) -> w.printf("%s=%s%n", Util.unicodeEscapeString((String)key), Util.unicodeEscapeString((String)value)));
        }
        catch (IOException e) {
            throw Log.CONTAINER.failedWritingGlobalState(e, stateFile);
        }
    }

    @Override
    public void deleteScopedState(String scope) {
        File stateFile = this.getStateFile(scope);
        try {
            Files.deleteIfExists(stateFile.toPath());
        }
        catch (IOException e) {
            throw Log.CONTAINER.failedWritingGlobalState(e, stateFile);
        }
    }

    @Override
    public void writeGlobalState() {
        if (this.providers.isEmpty()) {
            Log.CONTAINER.incompleteGlobalState();
        } else {
            ScopedPersistentStateImpl state = new ScopedPersistentStateImpl("___global");
            state.setProperty("@version", Version.getVersion());
            state.setProperty("version-major", Version.getMajor());
            state.setProperty("@timestamp", this.timeService.instant().toString());
            for (GlobalStateProvider provider : this.providers) {
                provider.prepareForPersist(state);
            }
            this.writeScopedState(state);
            Log.CONTAINER.globalStateWrite(state.getProperty("@version"), state.getProperty("@timestamp"));
        }
    }

    private File getStateFile(String scope) {
        return new File(this.root, scope + ".state");
    }
}

