/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.encoding.impl;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.AbstractTranscoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TwoStepTranscoder
extends AbstractTranscoder {
    private static final Log logger = LogFactory.getLog(TwoStepTranscoder.class, Log.class);
    private final Transcoder transcoder1;
    private final Transcoder transcoder2;
    private final HashSet<MediaType> supportedMediaTypes;

    public TwoStepTranscoder(Transcoder transcoder1, Transcoder transcoder2) {
        this.transcoder1 = transcoder1;
        this.transcoder2 = transcoder2;
        this.supportedMediaTypes = new HashSet(this.transcoder1.getSupportedMediaTypes());
        this.supportedMediaTypes.addAll(transcoder2.getSupportedMediaTypes());
    }

    public Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        if (this.transcoder1.supportsConversion(contentType, MediaType.APPLICATION_OBJECT) && this.transcoder2.supportsConversion(MediaType.APPLICATION_OBJECT, destinationType)) {
            Object object = this.transcoder1.transcode(content, contentType, MediaType.APPLICATION_OBJECT);
            return this.transcoder2.transcode(object, MediaType.APPLICATION_OBJECT, destinationType);
        }
        if (this.transcoder2.supportsConversion(contentType, MediaType.APPLICATION_OBJECT) && this.transcoder1.supportsConversion(MediaType.APPLICATION_OBJECT, destinationType)) {
            Object object = this.transcoder2.transcode(content, contentType, MediaType.APPLICATION_OBJECT);
            return this.transcoder1.transcode(object, MediaType.APPLICATION_OBJECT, destinationType);
        }
        throw logger.cannotConvertContent(TwoStepTranscoder.class.getSimpleName(), content, contentType, destinationType);
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public boolean supportsConversion(MediaType mediaType, MediaType other) {
        return this.transcoder1.supportsConversion(mediaType, MediaType.APPLICATION_OBJECT) && this.transcoder2.supportsConversion(MediaType.APPLICATION_OBJECT, other) || this.transcoder2.supportsConversion(mediaType, MediaType.APPLICATION_OBJECT) && this.transcoder1.supportsConversion(MediaType.APPLICATION_OBJECT, other);
    }
}

