/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;

@Scope(value=Scopes.NAMED_CACHE)
public interface DataContainer<K, V>
extends Iterable<InternalCacheEntry<K, V>> {
    public InternalCacheEntry<K, V> peek(Object var1);

    public void put(K var1, V var2, Metadata var3);

    public boolean containsKey(Object var1);

    public InternalCacheEntry<K, V> remove(Object var1);

    default public int size() {
        int size = 0;
        for (InternalCacheEntry<K, V> ignore : this) {
            if (++size != Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    public int sizeIncludingExpired();

    public void clear();

    public void evict(K var1);

    public InternalCacheEntry<K, V> compute(K var1, ComputeAction<K, V> var2);

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator();

    @Override
    default public Spliterator<InternalCacheEntry<K, V>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.sizeIncludingExpired(), 4353);
    }

    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired();

    default public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return Spliterators.spliterator(this.iteratorIncludingExpired(), (long)this.sizeIncludingExpired(), 4353);
    }

    default public void resize(long newSize) {
        throw new UnsupportedOperationException();
    }

    default public long capacity() {
        throw new UnsupportedOperationException();
    }

    default public long evictionSize() {
        throw new UnsupportedOperationException();
    }

    public static interface ComputeAction<K, V> {
        public InternalCacheEntry<K, V> compute(K var1, InternalCacheEntry<K, V> var2, InternalEntryFactory var3);
    }
}

