/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class PersistenceConfiguration
extends ConfigurationElement<PersistenceConfiguration> {
    public static final AttributeDefinition<Boolean> PASSIVATION = AttributeDefinition.builder((Enum)Attribute.PASSIVATION, (Object)false).immutable().build();
    public static final AttributeDefinition<TimeQuantity> AVAILABILITY_INTERVAL = AttributeDefinition.builder((Enum)Attribute.AVAILABILITY_INTERVAL, (Object)TimeQuantity.valueOf((String)"30s")).parser(TimeQuantity.PARSER).immutable().build();
    public static final AttributeDefinition<Integer> CONNECTION_ATTEMPTS = AttributeDefinition.builder((Enum)Attribute.CONNECTION_ATTEMPTS, (Object)10).build();
    @Deprecated(forRemoval=true, since="15.0")
    public static final AttributeDefinition<TimeQuantity> CONNECTION_INTERVAL = AttributeDefinition.builder((Enum)Attribute.CONNECTION_INTERVAL, (Object)TimeQuantity.valueOf((String)"50s")).parser(TimeQuantity.PARSER).immutable().deprecated(15, 0).build();
    private final List<StoreConfiguration> stores;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(PersistenceConfiguration.class, new AttributeDefinition[]{PASSIVATION, AVAILABILITY_INTERVAL, CONNECTION_ATTEMPTS, CONNECTION_INTERVAL});
    }

    PersistenceConfiguration(AttributeSet attributes, List<StoreConfiguration> stores) {
        super((Enum)Element.PERSISTENCE, attributes, PersistenceConfiguration.asChildren(stores));
        this.stores = stores;
    }

    private static ConfigurationElement<?>[] asChildren(List<StoreConfiguration> stores) {
        return (ConfigurationElement[])stores.stream().filter(store -> store instanceof ConfigurationElement).toArray(ConfigurationElement[]::new);
    }

    public boolean passivation() {
        return (Boolean)this.attributes.attribute(PASSIVATION).get();
    }

    public int availabilityInterval() {
        return (int)((TimeQuantity)this.attributes.attribute(AVAILABILITY_INTERVAL).get()).longValue();
    }

    public int connectionAttempts() {
        return (Integer)this.attributes.attribute(CONNECTION_ATTEMPTS).get();
    }

    @Deprecated(forRemoval=true, since="15.0")
    public int connectionInterval() {
        return -1;
    }

    public List<StoreConfiguration> stores() {
        return this.stores;
    }

    @Deprecated(forRemoval=true, since="14.0")
    public Boolean fetchPersistentState() {
        return false;
    }

    public Boolean preload() {
        return this.stores.stream().anyMatch(StoreConfiguration::preload);
    }

    public boolean usingStores() {
        return !this.stores.isEmpty();
    }

    public boolean usingAsyncStore() {
        return this.stores.stream().map(StoreConfiguration::async).anyMatch(AsyncStoreConfiguration::enabled);
    }

    public boolean usingSegmentedStore() {
        return this.stores.stream().anyMatch(StoreConfiguration::segmented);
    }
}

