/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.util.logging.Log;

public class ConfigurationManager {
    private final GlobalConfiguration globalConfiguration;
    private final Map<String, Configuration> namedConfiguration;
    private final Map<String, String> aliases;

    public ConfigurationManager(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
        this.namedConfiguration = new ConcurrentHashMap<String, Configuration>();
        this.aliases = new ConcurrentHashMap<String, String>();
    }

    public ConfigurationManager(ConfigurationBuilderHolder holder) {
        this(holder.getGlobalConfigurationBuilder().build());
        holder.getNamedConfigurationBuilders().forEach((name, builder) -> this.putConfiguration((String)name, builder.build(this.globalConfiguration)));
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public Configuration getConfiguration(String cacheName, boolean includeWildcards) {
        if (includeWildcards) {
            return this.findConfiguration(cacheName);
        }
        return this.namedConfiguration.get(cacheName);
    }

    public Configuration getConfiguration(String cacheName) {
        Configuration configuration = this.findConfiguration(cacheName);
        if (configuration != null) {
            return configuration;
        }
        throw Log.CONFIG.noSuchCacheConfiguration(cacheName);
    }

    private Configuration findConfiguration(String name) {
        if (this.namedConfiguration.containsKey(name)) {
            return this.namedConfiguration.get(name);
        }
        Configuration match = null;
        for (Map.Entry<String, Configuration> c : this.namedConfiguration.entrySet()) {
            String key = c.getKey();
            if (!GlobUtils.isGlob((String)key) || !name.matches(GlobUtils.globToRegex((String)key))) continue;
            if (match == null) {
                match = c.getValue();
                if (!match.isTemplate()) continue;
                ConfigurationBuilder builder = new ConfigurationBuilder().read(match).template(false);
                match = builder.build();
                continue;
            }
            throw Log.CONFIG.configurationNameMatchesMultipleWildcards(name);
        }
        return match;
    }

    public Configuration putConfiguration(String cacheName, Configuration configuration) {
        this.addAliases(cacheName, configuration.aliases(), false);
        this.namedConfiguration.put(cacheName, configuration);
        configuration.attributes().attribute(Configuration.ALIASES).addListener((AttributeListener)new AliasListener(cacheName));
        return configuration;
    }

    public Configuration putConfiguration(String cacheName, ConfigurationBuilder builder) {
        return this.putConfiguration(cacheName, builder.build(this.globalConfiguration));
    }

    public void removeConfiguration(String cacheName) {
        Configuration removed = this.namedConfiguration.remove(cacheName);
        if (removed != null) {
            removed.attributes().attribute(Configuration.ALIASES).removeListener(AliasListener.FILTER);
            this.removeAliases(removed.aliases());
        }
    }

    public Collection<String> getDefinedCaches() {
        return this.namedConfiguration.entrySet().stream().filter(entry -> !((Configuration)((Object)((Object)entry.getValue()))).isTemplate()).map(Map.Entry::getKey).toList();
    }

    public Collection<String> getAliases() {
        return this.aliases.keySet();
    }

    public Collection<String> getDefinedConfigurations() {
        return Collections.unmodifiableCollection(this.namedConfiguration.keySet());
    }

    public ConfigurationBuilderHolder toBuilderHolder() {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.getGlobalConfigurationBuilder().read(this.globalConfiguration);
        for (Map.Entry<String, Configuration> entry : this.namedConfiguration.entrySet()) {
            holder.newConfigurationBuilder(entry.getKey()).read(entry.getValue(), Combine.DEFAULT);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> addAliases(String cacheName, Collection<String> aliases, boolean force) {
        Map<String, String> map = this.aliases;
        synchronized (map) {
            for (String alias : aliases) {
                if (this.namedConfiguration.containsKey(alias) || cacheName.equals(alias)) {
                    throw Log.CONFIG.duplicateCacheName(alias);
                }
                if (force || !this.aliases.containsKey(alias)) continue;
                throw Log.CONFIG.duplicateAliasName(alias, this.aliases.get(alias));
            }
            HashMap<String, String> oldOwners = new HashMap<String, String>();
            for (String alias : aliases) {
                String old = this.aliases.put(alias, cacheName);
                if (old == null) continue;
                oldOwners.put(alias, old);
            }
            return oldOwners;
        }
    }

    private void removeAliases(Collection<String> aliases) {
        for (String alias : aliases) {
            this.aliases.remove(alias);
        }
    }

    public String selectCache(String cacheName) {
        return this.aliases.getOrDefault(cacheName, cacheName);
    }

    class AliasListener
    implements AttributeListener<Set<String>> {
        static final Predicate<AttributeListener<Set<String>>> FILTER = f -> f.getClass() == AliasListener.class;
        private final String cacheName;

        AliasListener(String cacheName) {
            this.cacheName = cacheName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attributeChanged(Attribute<Set<String>> attribute, Set<String> oldValues) {
            Map<String, String> oldOwners;
            Map<String, String> map = ConfigurationManager.this.aliases;
            synchronized (map) {
                ArrayList<String> arrayList = new ArrayList<String>((Collection)attribute.get());
                arrayList.removeAll(oldValues);
                oldOwners = ConfigurationManager.this.addAliases(this.cacheName, arrayList, true);
                ArrayList<String> removedValues = new ArrayList<String>(oldValues);
                removedValues.removeAll((Collection)attribute.get());
                ConfigurationManager.this.removeAliases(removedValues);
            }
            for (Map.Entry entry : oldOwners.entrySet()) {
                String otherCacheName = (String)entry.getValue();
                Configuration otherConfiguration = ConfigurationManager.this.namedConfiguration.get(otherCacheName);
                Attribute otherAliases = otherConfiguration.attributes().attribute(Configuration.ALIASES);
                otherAliases.removeListener(FILTER);
                HashSet list = new HashSet((Collection)otherAliases.get());
                list.remove(entry.getKey());
                otherAliases.set(list);
                otherAliases.addListener((AttributeListener)new AliasListener(otherCacheName));
            }
        }
    }
}

