/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging;

import jakarta.transaction.TransactionManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.CrossSiteIllegalLifecycleStateException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.configuration.io.Location;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.concurrent.FileSystemLock;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.interceptors.impl.ContainerFullException;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.remoting.transport.PhysicalAddress;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.MissingMembersException;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.upgrade.UnsupportedVersionException;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jgroups.View;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final AtomicBoolean warnUnableToPersistInternalCaches_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean deprecatedIndexProperties_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean maxIdleGreaterThanOrEqualLifespanRuntime_$Once = new AtomicBoolean(false);

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void problemApplyingStateForKey(Object key, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.problemApplyingStateForKey$str(), key);
    }

    protected String problemApplyingStateForKey$str() {
        return "ISPN000016: Problem encountered when applying state for key %s!";
    }

    @Override
    public final void expectedJustOneResponse(Map<Address, Response> lr) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.expectedJustOneResponse$str(), lr);
    }

    protected String expectedJustOneResponse$str() {
        return "ISPN000021: Expected just one response; got %s";
    }

    @Override
    public final void notStartingEvictionThread() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.notStartingEvictionThread$str(), new Object[0]);
    }

    protected String notStartingEvictionThread$str() {
        return "ISPN000025: wakeUpInterval is <= 0, not starting expired purge thread";
    }

    @Override
    public final void exceptionPurgingDataContainer(Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.exceptionPurgingDataContainer$str(), new Object[0]);
    }

    protected String exceptionPurgingDataContainer$str() {
        return "ISPN000026: Caught exception purging data container!";
    }

    @Override
    public final void unableToPassivateEntry(Object key, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.unableToPassivateEntry$str(), key);
    }

    protected String unableToPassivateEntry$str() {
        return "ISPN000028: Unable to passivate entry under %s";
    }

    protected String jmxMBeanAlreadyRegistered$str() {
        return "ISPN000034: The '%s' JMX domain is already in use.";
    }

    @Override
    public final JmxDomainConflictException jmxMBeanAlreadyRegistered(String jmxDomain, Throwable cause) {
        JmxDomainConflictException result = new JmxDomainConflictException(String.format(this.getLoggingLocale(), this.jmxMBeanAlreadyRegistered$str(), jmxDomain));
        result.initCause(cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void couldNotFindAttribute(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.couldNotFindAttribute$str(), (Object)name);
    }

    protected String couldNotFindAttribute$str() {
        return "ISPN000036: Did not find attribute %s";
    }

    @Override
    public final void failedToUpdateAttribute(String name, Object value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToUpdateAttribute$str(), (Object)name, value);
    }

    protected String failedToUpdateAttribute$str() {
        return "ISPN000037: Failed to update attribute name %s with value %s";
    }

    @Override
    public final void queriedAttributeNotFound(String attributeName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.queriedAttributeNotFound$str(), (Object)attributeName);
    }

    protected String queriedAttributeNotFound$str() {
        return "ISPN000042: Did not find queried attribute with name %s";
    }

    @Override
    public final void errorWritingValueForAttribute(String attributeName, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.errorWritingValueForAttribute$str(), (Object)attributeName);
    }

    protected String errorWritingValueForAttribute$str() {
        return "ISPN000043: Exception while writing value for attribute %s";
    }

    @Override
    public final void couldNotInvokeSetOnAttribute(String attributeName, Object value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.couldNotInvokeSetOnAttribute$str(), (Object)attributeName, value);
    }

    protected String couldNotInvokeSetOnAttribute$str() {
        return "ISPN000044: Could not invoke set on attribute %s with value %s";
    }

    @Override
    public final void unknownResponsesFromRemoteCache(Collection<Response> responses) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unknownResponsesFromRemoteCache$str(), responses);
    }

    protected String unknownResponsesFromRemoteCache$str() {
        return "ISPN000046: Unknown responses from remote cache: %s";
    }

    @Override
    public final void errorDoingRemoteCall(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorDoingRemoteCall$str(), new Object[0]);
    }

    protected String errorDoingRemoteCall$str() {
        return "ISPN000047: Error while doing remote call";
    }

    @Override
    public final void errorMarshallingObject(Throwable ioe, Object obj) {
        this.log.logf(FQCN, Logger.Level.ERROR, ioe, this.errorMarshallingObject$str(), obj);
    }

    protected String errorMarshallingObject$str() {
        return "ISPN000065: Exception while marshalling object: %s";
    }

    @Override
    public final void exceptionHandlingCommand(Object cmd, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.exceptionHandlingCommand$str(), cmd);
    }

    protected String exceptionHandlingCommand$str() {
        return "ISPN000071: Caught exception when handling command %s";
    }

    @Override
    public final void unexpectedErrorReplicating(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unexpectedErrorReplicating$str(), new Object[0]);
    }

    protected String unexpectedErrorReplicating$str() {
        return "ISPN000073: Unexpected error while replicating";
    }

    @Override
    public final void startingJGroupsChannel(String cluster) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingJGroupsChannel1$str(), (Object)cluster);
    }

    protected String startingJGroupsChannel1$str() {
        return "ISPN000078: Starting JGroups channel `%s`";
    }

    @Override
    public final void startingJGroupsChannel(String cluster, String stack) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingJGroupsChannel2$str(), (Object)cluster, (Object)stack);
    }

    protected String startingJGroupsChannel2$str() {
        return "ISPN000078: Starting JGroups channel `%s` with stack `%s`";
    }

    @Override
    public final void localAndPhysicalAddress(String cluster, Address address, List<PhysicalAddress> physicalAddresses) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.localAndPhysicalAddress$str(), (Object)cluster, (Object)address, physicalAddresses);
    }

    protected String localAndPhysicalAddress$str() {
        return "ISPN000079: Channel `%s` local address is `%s`, physical addresses are `%s`";
    }

    @Override
    public final void disconnectJGroups(String cluster) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.disconnectJGroups$str(), (Object)cluster);
    }

    protected String disconnectJGroups$str() {
        return "ISPN000080: Disconnecting JGroups channel `%s`";
    }

    @Override
    public final void problemClosingChannel(Exception e, String cluster) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.problemClosingChannel$str(), (Object)cluster);
    }

    protected String problemClosingChannel$str() {
        return "ISPN000081: Problem closing channel `%s`; setting it to null";
    }

    protected String errorCreatingChannelFromConfigFile$str() {
        return "ISPN000085: Error while trying to create a channel using the specified configuration file: %s";
    }

    @Override
    public final CacheConfigurationException errorCreatingChannelFromConfigFile(String cfg, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.errorCreatingChannelFromConfigFile$str(), cfg), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCreatingChannelFromXML$str() {
        return "ISPN000086: Error while trying to create a channel using the specified configuration XML: %s";
    }

    @Override
    public final CacheConfigurationException errorCreatingChannelFromXML(String cfg, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.errorCreatingChannelFromXML$str(), cfg), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCreatingChannelFromConfigString$str() {
        return "ISPN000087: Error while trying to create a channel using the specified configuration string: %s";
    }

    @Override
    public final CacheConfigurationException errorCreatingChannelFromConfigString(String cfg, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.errorCreatingChannelFromConfigString$str(), cfg), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unableToUseJGroupsPropertiesProvided(TypedProperties props) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unableToUseJGroupsPropertiesProvided$str(), (Object)props);
    }

    protected String unableToUseJGroupsPropertiesProvided$str() {
        return "ISPN000088: Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration!";
    }

    @Override
    public final void interruptedWaitingForCoordinator(InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.interruptedWaitingForCoordinator$str(), new Object[0]);
    }

    protected String interruptedWaitingForCoordinator$str() {
        return "ISPN000089: getCoordinator(): Interrupted while waiting for members to be set";
    }

    @Override
    public final void receivedMergedView(String cluster, View newView) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.receivedMergedView$str(), (Object)cluster, (Object)newView);
    }

    protected String receivedMergedView$str() {
        return "ISPN000093: Received new, MERGED cluster view for channel %s: %s";
    }

    @Override
    public final void receivedClusterView(String cluster, View newView) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.receivedClusterView$str(), (Object)cluster, (Object)newView);
    }

    protected String receivedClusterView$str() {
        return "ISPN000094: Received new cluster view for channel %s: %s";
    }

    @Override
    public final void errorProcessing1pcPrepareCommand(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorProcessing1pcPrepareCommand$str(), new Object[0]);
    }

    protected String errorProcessing1pcPrepareCommand$str() {
        return "ISPN000097: Error while processing a prepare in a single-phase transaction";
    }

    @Override
    public final void errorRollingBack(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorRollingBack$str(), new Object[0]);
    }

    protected String errorRollingBack$str() {
        return "ISPN000098: Exception during rollback";
    }

    @Override
    public final void unfinishedTransactionsRemain(int localTransactions, int remoteTransactions) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unfinishedTransactionsRemain$str(), (Object)localTransactions, (Object)remoteTransactions);
    }

    protected String unfinishedTransactionsRemain$str() {
        return "ISPN000100: Stopping, but there are %s local transactions and %s remote transactions that did not finish in time.";
    }

    @Override
    public final void failedSynchronizationRegistration(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedSynchronizationRegistration$str(), new Object[0]);
    }

    protected String failedSynchronizationRegistration$str() {
        return "ISPN000101: Failed synchronization registration";
    }

    @Override
    public final void unableToRollbackGlobalTx(GlobalTransaction gtx, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.unableToRollbackGlobalTx$str(), (Object)gtx);
    }

    protected String unableToRollbackGlobalTx$str() {
        return "ISPN000102: Unable to roll back global transaction %s";
    }

    @Override
    public final void fallingBackToEmbeddedTm() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.fallingBackToEmbeddedTm$str(), new Object[0]);
    }

    protected String fallingBackToEmbeddedTm$str() {
        return "ISPN000104: Using EmbeddedTransactionManager";
    }

    @Override
    public final void failedToCreateInitialCtx(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failedToCreateInitialCtx$str(), new Object[0]);
    }

    protected String failedToCreateInitialCtx$str() {
        return "ISPN000105: Failed creating initial JNDI context";
    }

    @Override
    public final void retrievingTm(TransactionManager tm) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.retrievingTm$str(), (Object)tm);
    }

    protected String retrievingTm$str() {
        return "ISPN000107: Retrieving transaction manager %s";
    }

    @Override
    public final void recoveryIgnored() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recoveryIgnored$str(), new Object[0]);
    }

    protected String recoveryIgnored$str() {
        return "ISPN000115: Recovery call will be ignored as recovery is disabled. More on recovery: http://community.jboss.org/docs/DOC-16646";
    }

    @Override
    public final void missingListPreparedTransactions(Object key, Object value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.missingListPreparedTransactions$str(), key, value);
    }

    protected String missingListPreparedTransactions$str() {
        return "ISPN000116: Missing the list of prepared transactions from node %s. Received response is %s";
    }

    @Override
    public final void preparedTxAlreadyExists(RecoveryAwareTransaction previous, RecoveryAwareRemoteTransaction remoteTransaction) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.preparedTxAlreadyExists$str(), (Object)previous, (Object)remoteTransaction);
    }

    protected String preparedTxAlreadyExists$str() {
        return "ISPN000117: There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?";
    }

    @Override
    public final void unableToSetValue(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToSetValue$str(), new Object[0]);
    }

    protected String unableToSetValue$str() {
        return "ISPN000121: Unable to set value!";
    }

    @Override
    public final void failedToCallStopAfterFailure(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.failedToCallStopAfterFailure$str(), new Object[0]);
    }

    protected String failedToCallStopAfterFailure$str() {
        return "ISPN000126: Attempted to stop() from FAILED state, but caught exception";
    }

    @Override
    public final void version(String version) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.version$str(), (Object)version);
    }

    protected String version$str() {
        return "ISPN000128: Infinispan version: %s";
    }

    @Override
    public final void noAnnotateMethodsFoundInListener(Class<?> listenerClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noAnnotateMethodsFoundInListener$str(), listenerClass);
    }

    protected String noAnnotateMethodsFoundInListener$str() {
        return "ISPN000133: Attempted to register listener of class %s, but no valid, public methods annotated with method-level event annotations found! Ignoring listener.";
    }

    @Override
    public final void unableToInvokeListenerMethodAndRemoveListener(Method m, Object target, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.unableToInvokeListenerMethodAndRemoveListener$str(), (Object)m, target);
    }

    protected String unableToInvokeListenerMethodAndRemoveListener$str() {
        return "ISPN000134: Unable to invoke method %s on Object instance %s - removing this target object from list of listeners!";
    }

    @Override
    public final void unableToLockToInvalidate(Object key, Address address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToLockToInvalidate$str(), key, (Object)address);
    }

    protected String unableToLockToInvalidate$str() {
        return "ISPN000135: Could not lock key %s in order to invalidate from L1 at node %s, skipping....";
    }

    @Override
    public final void executionError(String commandType, String cacheName, String affectedKeys, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.executionError$str(), (Object)commandType, (Object)cacheName, (Object)affectedKeys);
    }

    protected String executionError$str() {
        return "ISPN000136: Error executing command %s on %s, writing keys %s";
    }

    @Override
    public final void failedInvalidatingRemoteCache(Throwable e) {
        this.log.logf(FQCN, Logger.Level.INFO, e, this.failedInvalidatingRemoteCache$str(), new Object[0]);
    }

    protected String failedInvalidatingRemoteCache$str() {
        return "ISPN000137: Failed invalidating remote cache";
    }

    @Override
    public final void couldNotRollbackPrepared1PcTransaction(LocalTransaction localTransaction, Throwable e1) {
        this.log.logf(FQCN, Logger.Level.WARN, e1, this.couldNotRollbackPrepared1PcTransaction$str(), (Object)localTransaction);
    }

    protected String couldNotRollbackPrepared1PcTransaction$str() {
        return "ISPN000141: Could not rollback prepared 1PC transaction. This transaction will be rolled back by the recovery process, if enabled. Transaction: %s";
    }

    @Override
    public final void failedToInvalidateKeys(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failedToInvalidateKeys$str(), new Object[0]);
    }

    protected String failedToInvalidateKeys$str() {
        return "ISPN000147: Error invalidating keys from L1 after rehash";
    }

    @Override
    public final void passivationWithoutEviction() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.passivationWithoutEviction$str(), new Object[0]);
    }

    protected String passivationWithoutEviction$str() {
        return "ISPN000152: Passivation configured without an eviction policy being selected. Only manually evicted entities will be passivated.";
    }

    @Override
    public final void couldNotCompleteInjectedTransaction(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.couldNotCompleteInjectedTransaction$str(), new Object[0]);
    }

    protected String couldNotCompleteInjectedTransaction$str() {
        return "ISPN000160: Could not complete injected transaction.";
    }

    @Override
    public final void usingBatchModeTransactionManager() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.usingBatchModeTransactionManager$str(), new Object[0]);
    }

    protected String usingBatchModeTransactionManager$str() {
        return "ISPN000161: Using a batchMode transaction manager";
    }

    @Override
    public final void couldNotInstantiateTransactionManager(Exception e) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)e, this.couldNotInstantiateTransactionManager$str(), new Object[0]);
    }

    protected String couldNotInstantiateTransactionManager$str() {
        return "ISPN000162: Could not instantiate transaction manager";
    }

    @Override
    public final void randomCacheModeSynonymsDeprecated(String candidate, String mode, List<String> synonyms) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.randomCacheModeSynonymsDeprecated$str(), (Object)candidate, (Object)mode, synonyms);
    }

    protected String randomCacheModeSynonymsDeprecated$str() {
        return "ISPN000177: %s has been deprecated as a synonym for %s. Use one of %s instead";
    }

    @Override
    public final void errorProcessing2pcCommitCommand(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorProcessing2pcCommitCommand$str(), new Object[0]);
    }

    protected String errorProcessing2pcCommitCommand$str() {
        return "ISPN000188: Error while processing a commit in a two-phase transaction";
    }

    @Override
    public final void componentFailedToStop(Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.componentFailedToStop$str(), new Object[0]);
    }

    protected String componentFailedToStop$str() {
        return "ISPN000189: While stopping a cache or cache manager, one of its components failed to stop";
    }

    @Override
    public final void failedLoadingKeysFromCacheStore(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.failedLoadingKeysFromCacheStore$str(), new Object[0]);
    }

    protected String failedLoadingKeysFromCacheStore$str() {
        return "ISPN000194: Failed loading keys from cache store";
    }

    @Override
    public final void rebalanceError(String cacheName, Address node, int topologyId, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.rebalanceError$str(), (Object)cacheName, (Object)node, (Object)topologyId);
    }

    protected String rebalanceError$str() {
        return "ISPN000195: Error during rebalance for cache %s on node %s, topology id = %d";
    }

    @Override
    public final void failedToRecoverClusterState(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToRecoverClusterState$str(), new Object[0]);
    }

    protected String failedToRecoverClusterState$str() {
        return "ISPN000196: Failed to recover cluster state after the current node became the coordinator (or after merge), will retry";
    }

    @Override
    public final void errorUpdatingMembersList(int viewId, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.errorUpdatingMembersList$str(), (Object)viewId);
    }

    protected String errorUpdatingMembersList$str() {
        return "ISPN000197: Error updating cluster member list for view %d, waiting for next view";
    }

    @Override
    public final void cacheBackupsDataToSameSite(String siteName) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.cacheBackupsDataToSameSite$str(), (Object)siteName);
    }

    protected String cacheBackupsDataToSameSite$str() {
        return "ISPN000201: This cache is configured to backup to its own site (%s).";
    }

    @Override
    public final void warnXsiteBackupFailed(String cacheName, String siteName, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.WARN, throwable, this.warnXsiteBackupFailed$str(), (Object)cacheName, (Object)siteName);
    }

    protected String warnXsiteBackupFailed$str() {
        return "ISPN000202: Encountered issues while backing up data for cache %s to site %s";
    }

    @Override
    public final void cannotRespondToRollback(GlobalTransaction globalTransaction, String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotRespondToRollback$str(), (Object)globalTransaction, (Object)cacheName);
    }

    protected String cannotRespondToRollback$str() {
        return "ISPN000203: The rollback request for tx %s cannot be processed by the cache %s as this cache is not transactional!";
    }

    @Override
    public final void cannotRespondToCommit(GlobalTransaction globalTransaction, String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotRespondToCommit$str(), (Object)globalTransaction, (Object)cacheName);
    }

    protected String cannotRespondToCommit$str() {
        return "ISPN000204: The commit request for tx %s cannot be processed by the cache %s as this cache is not transactional!";
    }

    @Override
    public final void tryingToBringOnlineNonexistentSite(String siteName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.tryingToBringOnlineNonexistentSite$str(), (Object)siteName);
    }

    protected String tryingToBringOnlineNonexistentSite$str() {
        return "ISPN000205: Trying to bring back an non-existent site (%s)!";
    }

    @Override
    public final void noLiveOwnersFoundForSegments(Collection<Integer> segments, String cacheName, Collection<Address> faultySources) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noLiveOwnersFoundForSegments$str(), segments, (Object)cacheName, faultySources);
    }

    protected String noLiveOwnersFoundForSegments$str() {
        return "ISPN000208: No live owners found for segments %s of cache %s. Excluded owners: %s";
    }

    @Override
    public final void failedToRetrieveTransactionsForSegments(String cacheName, Address source, Collection<Integer> segments, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.failedToRetrieveTransactionsForSegments$str(), (Object)cacheName, (Object)source, segments);
    }

    protected String failedToRetrieveTransactionsForSegments$str() {
        return "ISPN000209: Failed to retrieve transactions of cache %s from node %s, segments %s";
    }

    @Override
    public final void failedToRequestSegments(String cacheName, Address source, Collection<Integer> segments, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.failedToRequestSegments$str(), (Object)cacheName, (Object)source, segments);
    }

    protected String failedToRequestSegments$str() {
        return "ISPN000210: Failed to request state of cache %s from node %s, segments %s";
    }

    @Override
    public final void unableToRemoveEntryAfterActivation(Object key, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.unableToRemoveEntryAfterActivation$str(), key);
    }

    protected String unableToRemoveEntryAfterActivation$str() {
        return "ISPN000214: Unable to remove entry under %s from cache store after activation";
    }

    protected String unknownMigrator$str() {
        return "ISPN000215: Unknown migrator %s";
    }

    @Override
    public final IllegalArgumentException unknownMigrator(String migratorName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownMigrator$str(), migratorName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void entriesMigrated(long count, String name, String prettyTime) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.entriesMigrated$str(), (Object)count, (Object)name, (Object)prettyTime);
    }

    protected String entriesMigrated$str() {
        return "ISPN000216: %d entries migrated to cache %s in %s";
    }

    protected String remoteException$str() {
        return "ISPN000217: Received exception from %s, see cause for remote stack trace";
    }

    @Override
    public final RemoteException remoteException(Object sender, Throwable t) {
        RemoteException result = new RemoteException(String.format(this.getLoggingLocale(), this.remoteException$str(), sender), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void failedToRecoverCacheState(String cacheName, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToRecoverCacheState$str(), (Object)cacheName);
    }

    protected String failedToRecoverCacheState$str() {
        return "ISPN000228: Failed to recover cache %s state after the current node became the coordinator";
    }

    protected String unexpectedInitialVersion$str() {
        return "ISPN000229: Unexpected initial version type (only NumericVersion instances supported): %s";
    }

    @Override
    public final IllegalArgumentException unexpectedInitialVersion(String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unexpectedInitialVersion$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void rebalanceStartError(String cacheName, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.rebalanceStartError$str(), (Object)cacheName);
    }

    protected String rebalanceStartError$str() {
        return "ISPN000230: Failed to start rebalance for cache %s";
    }

    @Override
    public final void parserRootElementAlreadyRegistered(String qName, String oldParser, String newParser) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.parserRootElementAlreadyRegistered$str(), (Object)qName, (Object)oldParser, (Object)newParser);
    }

    protected String parserRootElementAlreadyRegistered$str() {
        return "ISPN000234: Root element for %s already registered in ParserRegistry by %s. Cannot install %s.";
    }

    protected String parserDoesNotDeclareNamespaces$str() {
        return "ISPN000235: Configuration parser %s does not declare any Namespace annotations";
    }

    @Override
    public final CacheConfigurationException parserDoesNotDeclareNamespaces(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.parserDoesNotDeclareNamespaces$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String directoryCannotBeCreated$str() {
        return "ISPN000238: Directory %s does not exist and cannot be created!";
    }

    @Override
    public final CacheConfigurationException directoryCannotBeCreated(String path) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.directoryCannotBeCreated$str(), path));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingForeignExternalizer$str() {
        return "ISPN000242: Missing foreign externalizer with id=%s, either externalizer was not configured by client, or module lifecycle implementation adding externalizer was not loaded properly";
    }

    @Override
    public final CacheException missingForeignExternalizer(int foreignId) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.missingForeignExternalizer$str(), foreignId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownExternalizerReaderIndex$str() {
        return "ISPN000243: Type of data read is unknown. Id=%d is not amongst known reader indexes.";
    }

    @Override
    public final CacheException unknownExternalizerReaderIndex(int readerIndex) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unknownExternalizerReaderIndex$str(), readerIndex));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String advanceExternalizerTypeClassesUndefined$str() {
        return "ISPN000244: AdvancedExternalizer's getTypeClasses for externalizer %s must return a non-empty set";
    }

    @Override
    public final CacheConfigurationException advanceExternalizerTypeClassesUndefined(String className) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.advanceExternalizerTypeClassesUndefined$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateExternalizerIdFound$str() {
        return "ISPN000245: Duplicate id found! AdvancedExternalizer id=%d for %s is shared by another externalizer (%s). Reader index is %d";
    }

    @Override
    public final CacheConfigurationException duplicateExternalizerIdFound(int externalizerId, Class<?> typeClass, String otherExternalizer, int readerIndex) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateExternalizerIdFound$str(), externalizerId, typeClass, otherExternalizer, readerIndex));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String loaderConfigurationDoesNotSpecifyLoaderClass$str() {
        return "ISPN000249: The cache loader configuration %s does not specify the loader class using @ConfigurationFor";
    }

    @Override
    public final CacheConfigurationException loaderConfigurationDoesNotSpecifyLoaderClass(String className) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.loaderConfigurationDoesNotSpecifyLoaderClass$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorProcessingPrepare(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorProcessingPrepare$str(), new Object[0]);
    }

    protected String errorProcessingPrepare$str() {
        return "ISPN000255: Error while processing prepare";
    }

    @Override
    public final void failedOutBoundTransferExecution(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failedOutBoundTransferExecution$str(), new Object[0]);
    }

    protected String failedOutBoundTransferExecution$str() {
        return "ISPN000261: Failed to execute outbound transfer";
    }

    @Override
    public final void failedToEnlistTransactionXaAdapter(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failedToEnlistTransactionXaAdapter$str(), new Object[0]);
    }

    protected String failedToEnlistTransactionXaAdapter$str() {
        return "ISPN000262: Failed to enlist TransactionXaAdapter to transaction";
    }

    @Override
    public final void warnL1NotHavingReaperThread() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnL1NotHavingReaperThread$str(), new Object[0]);
    }

    protected String warnL1NotHavingReaperThread$str() {
        return "ISPN000264: Not using an L1 invalidation reaper thread. This could lead to memory leaks as the requestors map may grow indefinitely!";
    }

    @Override
    public final void unableToCreateInterceptor(Class<?> type, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCreateInterceptor$str(), type);
    }

    protected String unableToCreateInterceptor$str() {
        return "ISPN000267: Problems creating interceptor %s";
    }

    @Override
    public final void unableToRollbackInvalidationsDuringPrepare(Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.unableToRollbackInvalidationsDuringPrepare$str(), new Object[0]);
    }

    protected String unableToRollbackInvalidationsDuringPrepare$str() {
        return "ISPN000268: Unable to broadcast invalidations as a part of the prepare phase. Rolling back.";
    }

    @Override
    public final void warnGridFSMetadataCacheRequiresSync() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnGridFSMetadataCacheRequiresSync$str(), new Object[0]);
    }

    protected String warnGridFSMetadataCacheRequiresSync$str() {
        return "ISPN000269: Cache used for Grid metadata should be synchronous.";
    }

    @Override
    public final void warnCouldNotCommitLocalTx(Object transactionDescription, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.warnCouldNotCommitLocalTx$str(), transactionDescription);
    }

    protected String warnCouldNotCommitLocalTx$str() {
        return "ISPN000270: Could not commit local tx %s";
    }

    @Override
    public final void warnCouldNotRollbackLocalTx(Object transactionDescription, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.warnCouldNotRollbackLocalTx$str(), transactionDescription);
    }

    protected String warnCouldNotRollbackLocalTx$str() {
        return "ISPN000271: Could not rollback local tx %s";
    }

    @Override
    public final void warnExceptionRemovingRecovery(Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.warnExceptionRemovingRecovery$str(), new Object[0]);
    }

    protected String warnExceptionRemovingRecovery$str() {
        return "ISPN000272: Exception removing recovery information";
    }

    protected String invalidConfigurationIndexingWithInvalidation$str() {
        return "ISPN000273: Indexing can not be enabled on caches in Invalidation mode";
    }

    @Override
    public final CacheConfigurationException invalidConfigurationIndexingWithInvalidation() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidConfigurationIndexingWithInvalidation$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void persistenceWithoutCacheLoaderInterceptor() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.persistenceWithoutCacheLoaderInterceptor$str(), new Object[0]);
    }

    protected String persistenceWithoutCacheLoaderInterceptor$str() {
        return "ISPN000274: Persistence enabled without any CacheLoaderInterceptor in InterceptorChain!";
    }

    @Override
    public final void persistenceWithoutCacheWriteInterceptor() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.persistenceWithoutCacheWriteInterceptor$str(), new Object[0]);
    }

    protected String persistenceWithoutCacheWriteInterceptor$str() {
        return "ISPN000275: Persistence enabled without any CacheWriteInterceptor in InterceptorChain!";
    }

    protected String invalidConfigurationIndexingWithoutModule$str() {
        return "ISPN000278: Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected.";
    }

    @Override
    public final CacheConfigurationException invalidConfigurationIndexingWithoutModule() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidConfigurationIndexingWithoutModule$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorReadingFileStore$str() {
        return "ISPN000279: Failed to read stored entries from file. Error in file %s at offset %d";
    }

    @Override
    public final PersistenceException errorReadingFileStore(String path, long offset) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.errorReadingFileStore$str(), path, offset));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String exceptionInvokingListener$str() {
        return "ISPN000280: Caught exception [%s] while invoking method [%s] on listener instance: %s";
    }

    @Override
    public final CacheListenerException exceptionInvokingListener(String name, Method m, Object target, Throwable cause) {
        CacheListenerException result = new CacheListenerException(String.format(this.getLoggingLocale(), this.exceptionInvokingListener$str(), name, m, target), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String thirdPartySuspected$str() {
        return "ISPN000281: %s reported that a third node was suspected, see cause for info on the node that was suspected";
    }

    @Override
    public final SuspectException thirdPartySuspected(Object sender, SuspectException e) {
        SuspectException result = new SuspectException(String.format(this.getLoggingLocale(), this.thirdPartySuspected$str(), sender), (Throwable)((Object)e));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String invocationBatchingNeedsTransactionalCache$str() {
        return "ISPN000282: Cannot enable Invocation Batching when the Transaction Mode is NON_TRANSACTIONAL, set the transaction mode to TRANSACTIONAL";
    }

    @Override
    public final CacheConfigurationException invocationBatchingNeedsTransactionalCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invocationBatchingNeedsTransactionalCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invocationBatchingCannotBeRecoverable$str() {
        return "ISPN000283: A cache configured with invocation batching can't have recovery enabled";
    }

    @Override
    public final CacheConfigurationException invocationBatchingCannotBeRecoverable() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invocationBatchingCannotBeRecoverable$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void clusterListenerInstallationFailure(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.clusterListenerInstallationFailure$str(), new Object[0]);
    }

    protected String clusterListenerInstallationFailure$str() {
        return "ISPN000284: Problem encountered while installing cluster listener";
    }

    @Override
    public final void unsuccessfulResponseForClusterListeners(Address address, Response response) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsuccessfulResponseForClusterListeners$str(), (Object)address, (Object)response);
    }

    protected String unsuccessfulResponseForClusterListeners$str() {
        return "ISPN000285: Issue when retrieving cluster listeners from %s response was %s";
    }

    @Override
    public final void exceptionDuringClusterListenerRetrieval(Address address, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.exceptionDuringClusterListenerRetrieval$str(), (Object)address);
    }

    protected String exceptionDuringClusterListenerRetrieval$str() {
        return "ISPN000286: Issue when retrieving cluster listeners from %s";
    }

    protected String unauthorizedAccess$str() {
        return "ISPN000287: Unauthorized access: subject '%s' lacks '%s' permission";
    }

    @Override
    public final SecurityException unauthorizedAccess(String subject, String permission) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.unauthorizedAccess$str(), subject, permission));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPrincipalRoleMapper$str() {
        return "ISPN000288: A principal-to-role mapper has not been specified";
    }

    @Override
    public final CacheConfigurationException invalidPrincipalRoleMapper() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidPrincipalRoleMapper$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unableToSendXSiteState(String site, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.unableToSendXSiteState$str(), (Object)site);
    }

    protected String unableToSendXSiteState$str() {
        return "ISPN000289: Cannot send cross-site state chunk to '%s'.";
    }

    @Override
    public final void unableToApplyXSiteState(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.unableToApplyXSiteState$str(), new Object[0]);
    }

    protected String unableToApplyXSiteState$str() {
        return "ISPN000291: Cannot apply cross-site state chunk.";
    }

    @Override
    public final void ignoreAttribute(String element, Object attribute, Location location) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.ignoreAttribute$str(), (Object)element, attribute, (Object)location);
    }

    protected String ignoreAttribute$str() {
        return "ISPN000293: Ignoring attribute '%2$s' of element '%1$s' at '%3$s', please remove from configuration file";
    }

    @Override
    public final void ignoreXmlElement(Object element, Location location) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.ignoreXmlElement$str(), element, (Object)location);
    }

    protected String ignoreXmlElement$str() {
        return "ISPN000294: Ignoring element %s at %s, please remove from configuration file";
    }

    protected String undefinedThreadPoolName$str() {
        return "ISPN000295: No thread pool with name '%s' found";
    }

    @Override
    public final CacheConfigurationException undefinedThreadPoolName(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.undefinedThreadPoolName$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPermission$str() {
        return "ISPN000296: Attempt to add a %s permission to a SecurityPermissionCollection";
    }

    @Override
    public final IllegalArgumentException invalidPermission(Permission permission) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPermission$str(), permission));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String readOnlyPermissionCollection$str() {
        return "ISPN000297: Attempt to add a permission to a read-only SecurityPermissionCollection";
    }

    @Override
    public final SecurityException readOnlyPermissionCollection() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.readOnlyPermissionCollection$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToAcquireLock$str() {
        return "ISPN000299: Unable to acquire lock after %s for key %s and requestor %s. Lock is held by %s";
    }

    @Override
    public final TimeoutException unableToAcquireLock(String timeout, Object key, Object requestor, Object owner) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.unableToAcquireLock$str(), timeout, key, requestor, owner));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unsuccessfulResponseRetrievingTransactionsForSegments(Address address, Response response) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsuccessfulResponseRetrievingTransactionsForSegments$str(), (Object)address, (Object)response);
    }

    protected String unsuccessfulResponseRetrievingTransactionsForSegments$str() {
        return "ISPN000302: Issue when retrieving transactions from %s, response was %s";
    }

    @Override
    public final void ambiguousConfigurationFiles(String files) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ambiguousConfigurationFiles$str(), (Object)files);
    }

    protected String ambiguousConfigurationFiles$str() {
        return "ISPN000304: More than one configuration file with specified name on classpath. The first one will be used:\n %s";
    }

    protected String partitionDegraded$str() {
        return "ISPN000305: Cluster is operating in degraded mode because of node failures.";
    }

    @Override
    public final AvailabilityException partitionDegraded() {
        AvailabilityException result = new AvailabilityException(String.format(this.getLoggingLocale(), this.partitionDegraded$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String degradedModeKeyUnavailable$str() {
        return "ISPN000306: Key '%s' is not available. Not all owners are in this partition";
    }

    @Override
    public final AvailabilityException degradedModeKeyUnavailable(Object key) {
        AvailabilityException result = new AvailabilityException(String.format(this.getLoggingLocale(), this.degradedModeKeyUnavailable$str(), key));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String clearDisallowedWhilePartitioned$str() {
        return "ISPN000307: Cannot clear when the cluster is partitioned";
    }

    @Override
    public final AvailabilityException clearDisallowedWhilePartitioned() {
        AvailabilityException result = new AvailabilityException(String.format(this.getLoggingLocale(), this.clearDisallowedWhilePartitioned$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void rebalancingEnabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.rebalancingEnabled$str(), new Object[0]);
    }

    protected String rebalancingEnabled$str() {
        return "ISPN000308: Rebalancing enabled";
    }

    @Override
    public final void rebalancingSuspended() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.rebalancingSuspended$str(), new Object[0]);
    }

    protected String rebalancingSuspended$str() {
        return "ISPN000309: Rebalancing suspended";
    }

    @Override
    public final void startingRebalancePhase(String cacheName, CacheTopology cacheTopology) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingRebalancePhase$str(), (Object)cacheName, (Object)cacheTopology);
    }

    protected String startingRebalancePhase$str() {
        return "ISPN000310: Starting new rebalance phase for cache %s, topology %s";
    }

    @Override
    public final void stopOrderIgnored() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.stopOrderIgnored$str(), new Object[0]);
    }

    protected String stopOrderIgnored$str() {
        return "ISPN000321: Cyclic dependency detected between caches, stop order ignored";
    }

    @Override
    public final void failedToRestartXSiteStateTransfer(String siteName, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToRestartXSiteStateTransfer$str(), (Object)siteName);
    }

    protected String failedToRestartXSiteStateTransfer$str() {
        return "ISPN000322: Cannot restart cross-site state transfer to site %s";
    }

    protected String cacheIsTerminated$str() {
        return "ISPN000323: %s is in '%s' state and so it does not accept new invocations. Either restart it or recreate the cache container.";
    }

    @Override
    public final IllegalLifecycleStateException cacheIsTerminated(String cacheName, String state) {
        IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(this.getLoggingLocale(), this.cacheIsTerminated$str(), cacheName, state));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheIsStopping$str() {
        return "ISPN000324: %s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.";
    }

    @Override
    public final IllegalLifecycleStateException cacheIsStopping(String cacheName) {
        IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(this.getLoggingLocale(), this.cacheIsStopping$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void remoteTransactionTimeout(GlobalTransaction gtx, long ageMilliSeconds) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.remoteTransactionTimeout$str(), (Object)gtx, (Object)ageMilliSeconds);
    }

    protected String remoteTransactionTimeout$str() {
        return "ISPN000326: Remote transaction %s timed out. Rolling back after %d ms";
    }

    protected String unsupportedConfiguration$str() {
        return "ISPN000327: Cannot find a parser for element '%s' in namespace '%s' at %s. Check that your configuration is up-to-date for Infinispan '%s' and you have the proper dependency in the classpath";
    }

    @Override
    public final CacheConfigurationException unsupportedConfiguration(String element, String namespaceUri, Location location, String version) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unsupportedConfiguration$str(), element, namespaceUri, location, version));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void rebalancePhaseConfirmedOnNode(CacheTopology.Phase phase, String cacheName, Address node, int topologyId) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.rebalancePhaseConfirmedOnNode$str(), new Object[]{phase, cacheName, node, topologyId});
    }

    protected String rebalancePhaseConfirmedOnNode$str() {
        return "ISPN000328: Rebalance phase %s confirmed for cache %s on node %s, topology id = %d";
    }

    @Override
    public final void errorReadingRebalancingStatus(Address coordinator, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.errorReadingRebalancingStatus$str(), (Object)coordinator);
    }

    protected String errorReadingRebalancingStatus$str() {
        return "ISPN000329: Unable to read rebalancing status from coordinator %s";
    }

    @Override
    public final void unableToInvokeListenerMethod(Method m, Object target, Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.unableToInvokeListenerMethod$str(), (Object)m, target);
    }

    protected String unableToInvokeListenerMethod$str() {
        return "ISPN000331: Unable to invoke method %s on Object instance %s ";
    }

    protected String twoPhaseCommitAsyncBackup$str() {
        return "ISPN000335: Two-phase commit can only be used with synchronous backup strategy.";
    }

    @Override
    public final CacheConfigurationException twoPhaseCommitAsyncBackup() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.twoPhaseCommitAsyncBackup$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void finishedRebalance(String cacheName, CacheTopology topology) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.finishedRebalance$str(), (Object)cacheName, (Object)topology);
    }

    protected String finishedRebalance$str() {
        return "ISPN000336: Finished rebalance for cache %s, topology %s";
    }

    protected String backupMissingSite$str() {
        return "ISPN000337: Backup configuration must include a 'site'.";
    }

    @Override
    public final CacheConfigurationException backupMissingSite() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.backupMissingSite$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingBackupFailurePolicyClass$str() {
        return "ISPN000338: You must specify a 'failure-policy-class' to use a custom backup failure policy for backup '%s'.";
    }

    @Override
    public final CacheConfigurationException missingBackupFailurePolicyClass(String remoteSite) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingBackupFailurePolicyClass$str(), remoteSite));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String backupForNullCache$str() {
        return "ISPN000339: Remote cache name is missing or null in backup configuration.";
    }

    @Override
    public final CacheConfigurationException backupForNullCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.backupForNullCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String backupForMissingParameters$str() {
        return "ISPN000340: Remote cache name and remote site is missing or null in backup configuration.";
    }

    @Override
    public final CacheConfigurationException backupForMissingParameters() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.backupForMissingParameters$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingTransportConfiguration$str() {
        return "ISPN000343: Must have a transport set in the global configuration in order to define a clustered cache";
    }

    @Override
    public final CacheConfigurationException missingTransportConfiguration() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingTransportConfiguration$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidReaperWakeUpInterval$str() {
        return "ISPN000344: reaperWakeUpInterval must be >= 0, we got %d";
    }

    @Override
    public final CacheConfigurationException invalidReaperWakeUpInterval(long timeout) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidReaperWakeUpInterval$str(), timeout));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCompletedTxTimeout$str() {
        return "ISPN000345: completedTxTimeout must be >= 0, we got %d";
    }

    @Override
    public final CacheConfigurationException invalidCompletedTxTimeout(long timeout) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidCompletedTxTimeout$str(), timeout));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String l1OnlyForDistributedCache$str() {
        return "ISPN000350: Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to %s";
    }

    @Override
    public final CacheConfigurationException l1OnlyForDistributedCache(String cacheMode) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.l1OnlyForDistributedCache$str(), cacheMode));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String l1InvalidLifespan$str() {
        return "ISPN000351: Using a L1 lifespan of 0 or a negative value is meaningless";
    }

    @Override
    public final CacheConfigurationException l1InvalidLifespan() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.l1InvalidLifespan$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String l1NotValidWithExpirationEviction$str() {
        return "ISPN000352: Enabling the L1 cache is not supported when using EXCEPTION based eviction.";
    }

    @Override
    public final CacheConfigurationException l1NotValidWithExpirationEviction() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.l1NotValidWithExpirationEviction$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInstantiateClass$str() {
        return "ISPN000355: Unable to instantiate loader/writer instance for StoreConfiguration %s";
    }

    @Override
    public final CacheConfigurationException unableToInstantiateClass(Class<?> storeConfigurationClass) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unableToInstantiateClass$str(), storeConfigurationClass));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String existingConfigForInternalCache$str() {
        return "ISPN000358: A cache configuration named %s already exists. This cannot be configured externally by the user.";
    }

    @Override
    public final CacheConfigurationException existingConfigForInternalCache(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.existingConfigForInternalCache$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String degradedModeKeysUnavailable$str() {
        return "ISPN000359: Keys '%s' are not available. Not all owners are in this partition";
    }

    @Override
    public final AvailabilityException degradedModeKeysUnavailable(Collection<?> keys) {
        AvailabilityException result = new AvailabilityException(String.format(this.getLoggingLocale(), this.degradedModeKeysUnavailable$str(), keys));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void evictionExecutorDeprecated() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.evictionExecutorDeprecated$str(), new Object[0]);
    }

    protected String evictionExecutorDeprecated$str() {
        return "ISPN000360: The xml element eviction-executor has been deprecated and replaced by expiration-executor, please update your configuration file.";
    }

    protected String remoteTransactionAlreadyRolledBack$str() {
        return "ISPN000361: Cannot commit remote transaction %s as it was already rolled back";
    }

    @Override
    public final CacheException remoteTransactionAlreadyRolledBack(GlobalTransaction gtx) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.remoteTransactionAlreadyRolledBack$str(), gtx));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String remoteTransactionStatusMissing$str() {
        return "ISPN000362: Could not find status for remote transaction %s, please increase transaction.completedTxTimeout";
    }

    @Override
    public final TimeoutException remoteTransactionStatusMissing(GlobalTransaction gtx) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.remoteTransactionStatusMissing$str(), gtx));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noFilterIndexingServiceProviderFound(String filterClassName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noFilterIndexingServiceProviderFound$str(), (Object)filterClassName);
    }

    protected String noFilterIndexingServiceProviderFound$str() {
        return "ISPN000363: No filter indexing service provider found for indexed filter of type %s";
    }

    protected String clusterListenerRegisteredWithOnlyPreEvents$str() {
        return "ISPN000364: Attempted to register cluster listener of class %s, but listener is annotated as only observing pre events!";
    }

    @Override
    public final CacheException clusterListenerRegisteredWithOnlyPreEvents(Class<?> listenerClass) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.clusterListenerRegisteredWithOnlyPreEvents$str(), listenerClass));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jgroupsConfigurationNotFound$str() {
        return "ISPN000365: Could not find the specified JGroups configuration file '%s'";
    }

    @Override
    public final CacheConfigurationException jgroupsConfigurationNotFound(String cfg) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.jgroupsConfigurationNotFound$str(), cfg));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configurationInUse$str() {
        return "ISPN000371: Cannot remove cache configuration '%s' because it is in use";
    }

    @Override
    public final IllegalStateException configurationInUse(String configurationName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.configurationInUse$str(), configurationName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String templateConfigurationStartAttempt$str() {
        return "ISPN000373: Attempted to start a cache using configuration template '%s'";
    }

    @Override
    public final CacheConfigurationException templateConfigurationStartAttempt(String cacheName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.templateConfigurationStartAttempt$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String undeclaredConfiguration$str() {
        return "ISPN000374: No such template '%s' when declaring '%s'";
    }

    @Override
    public final CacheConfigurationException undeclaredConfiguration(String template, String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.undeclaredConfiguration$str(), template, name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noConfiguration$str() {
        return "ISPN000375: No such template/configuration '%s'";
    }

    @Override
    public final CacheConfigurationException noConfiguration(String extend) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noConfiguration$str(), extend));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interceptorStackNotSupported$str() {
        return "ISPN000376: Interceptor stack is not supported in simple cache";
    }

    @Override
    public final UnsupportedOperationException interceptorStackNotSupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.interceptorStackNotSupported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String lockOperationsNotSupported$str() {
        return "ISPN000377: Explicit lock operations are not supported in simple cache";
    }

    @Override
    public final UnsupportedOperationException lockOperationsNotSupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.lockOperationsNotSupported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invocationBatchingNotEnabled$str() {
        return "ISPN000378: Invocation batching not enabled in current configuration! Please enable it.";
    }

    @Override
    public final CacheConfigurationException invocationBatchingNotEnabled() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invocationBatchingNotEnabled$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notSupportedInSimpleCache$str() {
        return "ISPN000381: This configuration is not supported for simple cache";
    }

    @Override
    public final CacheConfigurationException notSupportedInSimpleCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.notSupportedInSimpleCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void missingGlobalStatePersistentLocation() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.missingGlobalStatePersistentLocation$str(), new Object[0]);
    }

    protected String missingGlobalStatePersistentLocation$str() {
        return "ISPN000382: Global state persistence was enabled without specifying a location";
    }

    protected String unableToBroadcastInvalidation$str() {
        return "ISPN000384: Unable to broadcast invalidation messages";
    }

    @Override
    public final RuntimeException unableToBroadcastInvalidation(Throwable e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToBroadcastInvalidation$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedReadingPersistentState$str() {
        return "ISPN000386: Failed to read persisted state from file %s. Aborting.";
    }

    @Override
    public final CacheConfigurationException failedReadingPersistentState(IOException e, File stateFile) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.failedReadingPersistentState$str(), stateFile), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedWritingGlobalState$str() {
        return "ISPN000387: Failed to write state to file %s.";
    }

    @Override
    public final CacheConfigurationException failedWritingGlobalState(IOException e, File stateFile) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.failedWritingGlobalState$str(), stateFile), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonWritableStateFile$str() {
        return "ISPN000388: The state file %s is not writable. Aborting.";
    }

    @Override
    public final CacheConfigurationException nonWritableStateFile(File stateFile) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.nonWritableStateFile$str(), stateFile));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void globalStateLoad(String version, String timestamp) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.globalStateLoad$str(), (Object)version, (Object)timestamp);
    }

    protected String globalStateLoad$str() {
        return "ISPN000389: Loaded global state, version=%s timestamp=%s";
    }

    @Override
    public final void globalStateWrite(String version, String timestamp) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.globalStateWrite$str(), (Object)version, (Object)timestamp);
    }

    protected String globalStateWrite$str() {
        return "ISPN000390: Persisted state, version=%s timestamp=%s";
    }

    protected String recoveryNotSupportedWithNonTxCache$str() {
        return "ISPN000391: Recovery not supported with non transactional cache";
    }

    @Override
    public final CacheConfigurationException recoveryNotSupportedWithNonTxCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.recoveryNotSupportedWithNonTxCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String recoveryNotSupportedWithSynchronization$str() {
        return "ISPN000392: Recovery not supported with Synchronization";
    }

    @Override
    public final CacheConfigurationException recoveryNotSupportedWithSynchronization() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.recoveryNotSupportedWithSynchronization$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void transactionNotificationsDisabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.transactionNotificationsDisabled$str(), new Object[0]);
    }

    protected String transactionNotificationsDisabled$str() {
        return "ISPN000395: Transaction notifications are disabled.  This prevents cluster listeners from working properly!";
    }

    @Override
    public final void ignoringUnsolicitedState(Address node, int segment, String cacheName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.ignoringUnsolicitedState$str(), (Object)node, (Object)segment, (Object)cacheName);
    }

    protected String ignoringUnsolicitedState$str() {
        return "ISPN000396: Received unsolicited state from node %s for segment %d of cache %s";
    }

    protected String persistentConsistentHashMismatch$str() {
        return "ISPN000398: CH Factory '%s' cannot restore a persisted CH of class '%s'";
    }

    @Override
    public final IllegalStateException persistentConsistentHashMismatch(String hashFactory, String consistentHashClass) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.persistentConsistentHashMismatch$str(), hashFactory, consistentHashClass));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timeoutWaitingForInitialNodes$str() {
        return "ISPN000399: Timeout while waiting for %d members in cluster. Last view had %s";
    }

    @Override
    public final TimeoutException timeoutWaitingForInitialNodes(int initialClusterSize, List<?> members) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.timeoutWaitingForInitialNodes$str(), initialClusterSize, members));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String remoteNodeSuspected$str() {
        return "ISPN000400: Node %s was suspected";
    }

    @Override
    public final SuspectException remoteNodeSuspected(Object address) {
        SuspectException result = new SuspectException(String.format(this.getLoggingLocale(), this.remoteNodeSuspected$str(), address));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String remoteNodeTimedOut$str() {
        return "ISPN000401: Node %s timed out, time : %s %s";
    }

    @Override
    public final TimeoutException remoteNodeTimedOut(Address address, long time, TimeUnit unit) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.remoteNodeTimedOut$str(), new Object[]{address, time, unit}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String coordinatorTimeoutWaitingForView$str() {
        return "ISPN000402: Timeout waiting for view %d. Current view is %d, current status is %s";
    }

    @Override
    public final TimeoutException coordinatorTimeoutWaitingForView(int expectedViewId, int currentViewId, Object clusterManagerStatus) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.coordinatorTimeoutWaitingForView$str(), expectedViewId, currentViewId, clusterManagerStatus));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noIndexableClassesDefined$str() {
        return "ISPN000403: No indexable classes were defined for this indexed cache. The configuration must contain classes or protobuf message types annotated with '@Indexed'";
    }

    @Override
    public final CacheConfigurationException noIndexableClassesDefined() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noIndexableClassesDefined$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String classNotIndexable$str() {
        return "ISPN000404: The configured entity class %s is not indexable. Please remove it from the indexing configuration.";
    }

    @Override
    public final CacheConfigurationException classNotIndexable(String className) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.classNotIndexable$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedInvokingCacheManagerListener(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failedInvokingCacheManagerListener$str(), new Object[0]);
    }

    protected String failedInvokingCacheManagerListener$str() {
        return "ISPN000405: Caught exception while invoking a cache manager listener!";
    }

    protected String extraneousMembersJoinRestoredCache$str() {
        return "ISPN000407: Extraneous members %s are attempting to join cache %s, as they were not members of the persisted state";
    }

    @Override
    public final CacheJoinException extraneousMembersJoinRestoredCache(List<Address> extraneousMembers, String cacheName) {
        CacheJoinException result = new CacheJoinException(String.format(this.getLoggingLocale(), this.extraneousMembersJoinRestoredCache$str(), extraneousMembers, cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String nodeWithPersistentStateJoiningClusterWithoutState$str() {
        return "ISPN000408: Node %s with persistent state attempting to join cache %s on cluster without state";
    }

    @Override
    public final CacheJoinException nodeWithPersistentStateJoiningClusterWithoutState(Address joiner, String cacheName) {
        CacheJoinException result = new CacheJoinException(String.format(this.getLoggingLocale(), this.nodeWithPersistentStateJoiningClusterWithoutState$str(), joiner, cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String nodeWithIncompatibleStateJoiningCache$str() {
        return "ISPN000410: Node %s attempting to join cache %s with incompatible state";
    }

    @Override
    public final CacheJoinException nodeWithIncompatibleStateJoiningCache(Address joiner, String cacheName) {
        CacheJoinException result = new CacheJoinException(String.format(this.getLoggingLocale(), this.nodeWithIncompatibleStateJoiningCache$str(), joiner, cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String unknownTransactionConfiguration$str() {
        return "ISPN000412: Cannot determine a synthetic transaction configuration from mode=%s, xaEnabled=%s, recoveryEnabled=%s, batchingEnabled=%s";
    }

    @Override
    public final CacheConfigurationException unknownTransactionConfiguration(TransactionMode mode, boolean xaEnabled, boolean recoveryEnabled, boolean batchingEnabled) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownTransactionConfiguration$str(), new Object[]{mode, xaEnabled, recoveryEnabled, batchingEnabled}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInstantiateSerializer$str() {
        return "ISPN000413: Unable to instantiate serializer for %s";
    }

    @Override
    public final CacheConfigurationException unableToInstantiateSerializer(Class<?> storeConfigurationClass) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unableToInstantiateSerializer$str(), storeConfigurationClass));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String globalSecurityAuthShouldBeEnabled$str() {
        return "ISPN000414: Global security authorization should be enabled if cache authorization enabled.";
    }

    @Override
    public final CacheConfigurationException globalSecurityAuthShouldBeEnabled() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.globalSecurityAuthShouldBeEnabled$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ignoredAttribute(String componentName, String version, String attributeName, int line) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoredAttribute$str(), new Object[]{componentName, version, attributeName, line});
    }

    protected String ignoredAttribute$str() {
        return "ISPN000415: The %s is no longer supported since version %s. Attribute %s on line %d will be ignored.";
    }

    protected String transactionalStoreInNonTransactionalCache$str() {
        return "ISPN000417: It is not possible for a store to be transactional in a non-transactional cache. ";
    }

    @Override
    public final CacheConfigurationException transactionalStoreInNonTransactionalCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.transactionalStoreInNonTransactionalCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionalStoreInPassivatedCache$str() {
        return "ISPN000418: It is not possible for a store to be transactional when passivation is enabled. ";
    }

    @Override
    public final CacheConfigurationException transactionalStoreInPassivatedCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.transactionalStoreInPassivatedCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void evictionDisabled(String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.evictionDisabled$str(), (Object)cacheName);
    }

    protected String evictionDisabled$str() {
        return "ISPN000419: Eviction of an entry invoked without an explicit eviction strategy for cache %s";
    }

    protected String attributeNotAllowedInInvalidationMode$str() {
        return "ISPN000420: Cannot enable '%s' in invalidation caches!";
    }

    @Override
    public final CacheConfigurationException attributeNotAllowedInInvalidationMode(String attributeName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.attributeNotAllowedInInvalidationMode$str(), attributeName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void viewHandlingError(int viewId, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.viewHandlingError$str(), (Object)viewId);
    }

    protected String viewHandlingError$str() {
        return "ISPN000421: Error while handling view %s";
    }

    protected String failedWaitingForTopology$str() {
        return "ISPN000422: Failed waiting for topology %d";
    }

    @Override
    public final TimeoutException failedWaitingForTopology(int requestTopologyId) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.failedWaitingForTopology$str(), requestTopologyId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEvictionSize$str() {
        return "ISPN000424: Memory eviction is enabled, please specify a maximum size or count greater than zero";
    }

    @Override
    public final CacheConfigurationException invalidEvictionSize() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidEvictionSize$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timeoutWaitingForAcks$str() {
        return "ISPN000427: Timeout after %s waiting for acks (%s). Id=%s, Topology Id=%s";
    }

    @Override
    public final TimeoutException timeoutWaitingForAcks(String timeout, String address, long id, int topology) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.timeoutWaitingForAcks$str(), timeout, address, id, topology));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void configDeprecatedUseOther(Enum<?> element, Enum<?> other, Location location) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configDeprecatedUseOther$str(), element, other, (Object)location);
    }

    protected String configDeprecatedUseOther$str() {
        return "ISPN000428: '%1$s' at %3$s has been deprecated. Please use '%2$s' instead";
    }

    protected String writeSkewOnRead$str() {
        return "ISPN000429: On key %s previous read version (%s) is different from currently read version (%s)";
    }

    @Override
    public final WriteSkewException writeSkewOnRead(Object key, Object key2, EntryVersion lastVersion, EntryVersion remoteVersion) {
        WriteSkewException result = new WriteSkewException(String.format(this.getLoggingLocale(), this.writeSkewOnRead$str(), key2, lastVersion, remoteVersion), key);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String missingDefaultCacheDeclaration$str() {
        return "ISPN000432: Missing configuration for default cache '%s' declared on container";
    }

    @Override
    public final CacheConfigurationException missingDefaultCacheDeclaration(String defaultCache) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingDefaultCacheDeclaration$str(), defaultCache));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultCache$str() {
        return "ISPN000433: A default cache has been requested, but no cache has been set as default for this container";
    }

    @Override
    public final CacheConfigurationException noDefaultCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noDefaultCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchCacheConfiguration$str() {
        return "ISPN000436: Cache '%s' has been requested, but no matching cache configuration exists";
    }

    @Override
    public final CacheConfigurationException noSuchCacheConfiguration(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noSuchCacheConfiguration$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateCacheName$str() {
        return "ISPN000438: Cache with name '%s' is defined more than once!";
    }

    @Override
    public final CacheConfigurationException duplicateCacheName(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateCacheName$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void receivedXSiteClusterView(Collection<String> view) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.receivedXSiteClusterView$str(), view);
    }

    protected String receivedXSiteClusterView$str() {
        return "ISPN000439: Received new cross-site view: %s";
    }

    @Override
    public final void errorSendingResponse(long requestId, org.jgroups.Address origin, Object command) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.errorSendingResponse$str(), (Object)requestId, (Object)origin, command);
    }

    protected String errorSendingResponse$str() {
        return "ISPN000440: Error sending response for request %d@%s, command %s";
    }

    protected String unsupportedAsyncCacheMode$str() {
        return "ISPN000441: Unsupported async cache mode '%s' for transactional caches";
    }

    @Override
    public final CacheConfigurationException unsupportedAsyncCacheMode(CacheMode cacheMode) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unsupportedAsyncCacheMode$str(), new Object[]{cacheMode}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clusteredTransactionalStoreMustBeShared$str() {
        return "ISPN000443: Invalid cache loader configuration for '%s'. In order for a cache loader to be transactional, it must also be shared.";
    }

    @Override
    public final CacheConfigurationException clusteredTransactionalStoreMustBeShared(String simpleName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.clusteredTransactionalStoreMustBeShared$str(), simpleName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionalStoreCannotBeAsync$str() {
        return "ISPN000444: Invalid cache loader configuration for '%s'. A cache loader cannot be both Asynchronous and transactional.";
    }

    @Override
    public final CacheConfigurationException transactionalStoreCannotBeAsync(String simpleName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.transactionalStoreCannotBeAsync$str(), simpleName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleSitesWithSameName$str() {
        return "ISPN000446: Multiple sites have the same name '%s'. This configuration is not valid.";
    }

    @Override
    public final CacheConfigurationException multipleSitesWithSameName(String site) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.multipleSitesWithSameName$str(), site));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String awaitInitialTransferOnlyForDistOrRepl$str() {
        return "ISPN000448: 'awaitInitialTransfer' can be enabled only if cache mode is distributed or replicated.";
    }

    @Override
    public final CacheConfigurationException awaitInitialTransferOnlyForDistOrRepl() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.awaitInitialTransferOnlyForDistOrRepl$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidXSiteStateTransferTimeout$str() {
        return "ISPN000449: Timeout value for cross-site replication state transfer must be equal to or greater than one.";
    }

    @Override
    public final CacheConfigurationException invalidXSiteStateTransferTimeout() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidXSiteStateTransferTimeout$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidXSiteStateTransferWaitTime$str() {
        return "ISPN000450: Wait time between retries for cross-site replication state transfer must be equal to or greater than one.";
    }

    @Override
    public final CacheConfigurationException invalidXSiteStateTransferWaitTime() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidXSiteStateTransferWaitTime$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timeoutWaitingForView$str() {
        return "ISPN000451: Timed out waiting for view %d, current view is %d";
    }

    @Override
    public final TimeoutException timeoutWaitingForView(int expectedViewId, int currentViewId) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.timeoutWaitingForView$str(), expectedViewId, currentViewId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void topologyUpdateError(String cacheName, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.topologyUpdateError$str(), (Object)cacheName);
    }

    protected String topologyUpdateError$str() {
        return "ISPN000452: Failed to update topology for cache %s";
    }

    protected String configAlreadyDefined$str() {
        return "ISPN000453: Attempt to define configuration for cache %s which already exists";
    }

    @Override
    public final CacheConfigurationException configAlreadyDefined(String cacheName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.configAlreadyDefined$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void transactionCleanupError(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.transactionCleanupError$str(), new Object[0]);
    }

    protected String transactionCleanupError$str() {
        return "ISPN000455: Failure during leaver transactions cleanup";
    }

    protected String invalidEncodingClass$str() {
        return "ISPN000461: Class %s should be a subclass of %s";
    }

    @Override
    public final CacheException invalidEncodingClass(Class<?> configured, Class<?> required) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.invalidEncodingClass$str(), configured, required));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String getConflictsAlreadyInProgress$str() {
        return "ISPN000462: ConflictManager.getConflicts() already in progress";
    }

    @Override
    public final IllegalStateException getConflictsAlreadyInProgress() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.getConflictsAlreadyInProgress$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String getConflictsStateTransferInProgress$str() {
        return "ISPN000463: Unable to retrieve conflicts as StateTransfer is currently in progress for cache '%s'";
    }

    @Override
    public final IllegalStateException getConflictsStateTransferInProgress(String cacheName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.getConflictsStateTransferInProgress$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void exceptionDuringConflictResolution(Object key, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.exceptionDuringConflictResolution$str(), key, (Object)t);
    }

    protected String exceptionDuringConflictResolution$str() {
        return "ISPN000466: Exception encountered when trying to resolve conflict on Keys '%s': %s";
    }

    protected String cacheManagerIsStopping$str() {
        return "ISPN000472: Cache manager is stopping";
    }

    @Override
    public final IllegalLifecycleStateException cacheManagerIsStopping() {
        IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(this.getLoggingLocale(), this.cacheManagerIsStopping$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void invalidMessageType(int messageType, org.jgroups.Address origin) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidMessageType$str(), (Object)messageType, (Object)origin);
    }

    protected String invalidMessageType$str() {
        return "ISPN000473: Invalid message type %s received from %s";
    }

    @Override
    public final void errorProcessingRequest(long requestId, org.jgroups.Address origin, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorProcessingRequest$str(), (Object)requestId, (Object)origin);
    }

    protected String errorProcessingRequest$str() {
        return "ISPN000474: Error processing request %d@%s";
    }

    @Override
    public final void errorProcessingResponse(long requestId, org.jgroups.Address sender, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorProcessingResponse$str(), (Object)requestId, (Object)sender);
    }

    protected String errorProcessingResponse$str() {
        return "ISPN000475: Error processing response for request %d from %s";
    }

    protected String requestTimedOut$str() {
        return "ISPN000476: Timed out waiting for responses for request %d from %s after %s";
    }

    @Override
    public final TimeoutException requestTimedOut(long requestId, String targetsWithoutResponses, String elapsed) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.requestTimedOut$str(), requestId, targetsWithoutResponses, elapsed));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void xsiteAdminOperationError(String operationName, String siteName, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.xsiteAdminOperationError$str(), (Object)operationName, (Object)siteName);
    }

    protected String xsiteAdminOperationError$str() {
        return "ISPN000477: Cannot perform operation %s for site %s";
    }

    protected String unableToFindRemoteSiteTransaction$str() {
        return "ISPN000478: Couldn't find a local transaction corresponding to remote site transaction %s";
    }

    @Override
    public final CacheException unableToFindRemoteSiteTransaction(GlobalTransaction globalTransaction) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToFindRemoteSiteTransaction$str(), globalTransaction));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToFindLocalTransactionFromRemoteSiteTransaction$str() {
        return "ISPN000479: LocalTransaction not found but present in the tx table for remote site transaction %s";
    }

    @Override
    public final IllegalStateException unableToFindLocalTransactionFromRemoteSiteTransaction(GlobalTransaction globalTransaction) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToFindLocalTransactionFromRemoteSiteTransaction$str(), globalTransaction));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String remoteTransactionOriginatorNotInView$str() {
        return "ISPN000481: Cannot create remote transaction %s, the originator is not in the cluster view";
    }

    @Override
    public final CacheException remoteTransactionOriginatorNotInView(GlobalTransaction gtx) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.remoteTransactionOriginatorNotInView$str(), gtx));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String remoteTransactionAlreadyCompleted$str() {
        return "ISPN000482: Cannot create remote transaction %s, already completed";
    }

    @Override
    public final CacheException remoteTransactionAlreadyCompleted(GlobalTransaction gtx) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.remoteTransactionAlreadyCompleted$str(), gtx));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wildcardsNotAllowedInCacheNames$str() {
        return "ISPN000484: Wildcards not allowed in cache names: '%s'";
    }

    @Override
    public final CacheConfigurationException wildcardsNotAllowedInCacheNames(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.wildcardsNotAllowedInCacheNames$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configurationNameMatchesMultipleWildcards$str() {
        return "ISPN000485: Configuration '%s' matches multiple wildcard templates";
    }

    @Override
    public final CacheConfigurationException configurationNameMatchesMultipleWildcards(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.configurationNameMatchesMultipleWildcards$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateIdWrapper$str() {
        return "ISPN000486: Cannot register Wrapper: duplicate Id %d";
    }

    @Override
    public final EncodingException duplicateIdWrapper(byte id) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.duplicateIdWrapper$str(), id));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFindTranscoder$str() {
        return "ISPN000492: Cannot find transcoder between '%s' to '%s'";
    }

    @Override
    public final EncodingException cannotFindTranscoder(MediaType mediaType, MediaType another) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.cannotFindTranscoder$str(), mediaType, another));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorTranscoding$str() {
        return "ISPN000495: %s encountered error transcoding content";
    }

    @Override
    public final EncodingException errorTranscoding(String transcoderName, Throwable cause) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.errorTranscoding$str(), transcoderName), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotConvertContent$str() {
        return "ISPN000497: %s cannot convert content '%s' from %s to %s";
    }

    @Override
    public final EncodingException cannotConvertContent(String transcoderName, Object content, MediaType fromType, MediaType toType) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.cannotConvertContent$str(), transcoderName, content, fromType, toType));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String configurationSerializationFailed$str() {
        return "ISPN000499: Could not serialize the configuration of cache '%s' (%s)";
    }

    @Override
    public final CacheConfigurationException configurationSerializationFailed(String cacheName, Configuration configuration, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.configurationSerializationFailed$str(), new Object[]{cacheName, configuration}), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatibleClusterConfiguration$str() {
        return "ISPN000500: Cannot create clustered configuration for cache '%s' because configuration %n%s%n is incompatible with the existing configuration %n%s";
    }

    @Override
    public final CacheConfigurationException incompatibleClusterConfiguration(String cacheName, Configuration configuration, Configuration existing) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.incompatibleClusterConfiguration$str(), new Object[]{cacheName, configuration, existing}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String globalStateDisabled$str() {
        return "ISPN000501: Cannot persist cache configuration as global state is disabled";
    }

    @Override
    public final CacheConfigurationException globalStateDisabled() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.globalStateDisabled$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorPersistingGlobalConfiguration$str() {
        return "ISPN000502: Error while persisting global configuration state";
    }

    @Override
    public final CacheConfigurationException errorPersistingGlobalConfiguration(Throwable cause) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.errorPersistingGlobalConfiguration$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String offHeapMemoryEvictionNotSupportedWithObject$str() {
        return "ISPN000504: Size (bytes) based eviction needs either off-heap or a binary compatible storage configured in the cache encoding";
    }

    @Override
    public final CacheConfigurationException offHeapMemoryEvictionNotSupportedWithObject() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.offHeapMemoryEvictionNotSupportedWithObject$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheExists$str() {
        return "ISPN000507: Cache %s already exists";
    }

    @Override
    public final CacheConfigurationException cacheExists(String cacheName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cacheExists$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRenamePersistentFile$str() {
        return "ISPN000508: Cannot rename file %s to %s";
    }

    @Override
    public final CacheConfigurationException cannotRenamePersistentFile(String absolutePath, File persistentFile, Throwable cause) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotRenamePersistentFile$str(), absolutePath, persistentFile), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToAddNullEntryMergePolicyFactory$str() {
        return "ISPN000509: Unable to add a 'null' EntryMergePolicyFactory";
    }

    @Override
    public final IllegalArgumentException unableToAddNullEntryMergePolicyFactory() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToAddNullEntryMergePolicyFactory$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String customStorageStrategyNotSet$str() {
        return "ISPN000510: ConfigurationStrategy set to CUSTOM, but none specified";
    }

    @Override
    public final CacheConfigurationException customStorageStrategyNotSet() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.customStorageStrategyNotSet$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String managerConfigurationStorageUnavailable$str() {
        return "ISPN000511: ConfigurationStrategy cannot be set to MANAGED in embedded mode";
    }

    @Override
    public final CacheConfigurationException managerConfigurationStorageUnavailable() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.managerConfigurationStorageUnavailable$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String globalStateCannotAcquireLockFile$str() {
        return "ISPN000512: Cannot acquire lock '%s' for persistent global state";
    }

    @Override
    public final CacheConfigurationException globalStateCannotAcquireLockFile(Throwable cause, FileSystemLock lockFile) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.globalStateCannotAcquireLockFile$str(), lockFile), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String exceptionBasedEvictionOnlySupportedInTransactionalCaches$str() {
        return "ISPN000513: Exception based eviction requires a transactional cache that doesn't allow for 1 phase commit or synchronizations";
    }

    @Override
    public final CacheConfigurationException exceptionBasedEvictionOnlySupportedInTransactionalCaches() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.exceptionBasedEvictionOnlySupportedInTransactionalCaches$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String containerFull$str() {
        return "ISPN000514: Container eviction limit %d reached, write operation(s) is blocked";
    }

    @Override
    public final ContainerFullException containerFull(long size) {
        ContainerFullException result = new ContainerFullException(String.format(this.getLoggingLocale(), this.containerFull$str(), size));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String immutableConfiguration$str() {
        return "ISPN000515: The configuration is immutable";
    }

    @Override
    public final UnsupportedOperationException immutableConfiguration() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.immutableConfiguration$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPersistentState$str() {
        return "ISPN000516: The state file for '%s' is invalid. Startup halted to prevent further corruption of persistent state";
    }

    @Override
    public final CacheConfigurationException invalidPersistentState(String globalScope) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidPersistentState$str(), globalScope));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ignoringCacheTopology(Collection<Address> sender, CacheTopology topology) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringCacheTopology$str(), sender, (Object)topology);
    }

    protected String ignoringCacheTopology$str() {
        return "ISPN000517: Ignoring cache topology from %s during merge: %s";
    }

    @Override
    public final void updatingTopology(String cacheName, CacheTopology currentTopology, AvailabilityMode availabilityMode) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.updatingTopology$str(), (Object)cacheName, (Object)currentTopology, (Object)availabilityMode);
    }

    protected String updatingTopology$str() {
        return "ISPN000518: Updating topology for cache %s, topology %s, availability mode %s";
    }

    @Override
    public final void updatingStableTopology(String cacheName, CacheTopology currentTopology) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.updatingStableTopology$str(), (Object)cacheName, (Object)currentTopology);
    }

    protected String updatingStableTopology$str() {
        return "ISPN000519: Updating stable topology for cache %s, topology %s";
    }

    @Override
    public final void updatingAvailabilityMode(String cacheName, AvailabilityMode oldMode, AvailabilityMode newMode, CacheTopology topology) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.updatingAvailabilityMode$str(), new Object[]{cacheName, oldMode, newMode, topology});
    }

    protected String updatingAvailabilityMode$str() {
        return "ISPN000520: Updating availability mode for cache %s from %s to %s, topology %s";
    }

    @Override
    public final void cacheRecoveredAfterMerge(String cacheName, CacheTopology currentTopology, AvailabilityMode availabilityMode) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.cacheRecoveredAfterMerge$str(), (Object)cacheName, (Object)currentTopology, (Object)availabilityMode);
    }

    protected String cacheRecoveredAfterMerge$str() {
        return "ISPN000521: Cache %s recovered after merge with topology = %s, availability mode %s";
    }

    @Override
    public final void startingConflictResolution(String cacheName, CacheTopology currentTopology) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingConflictResolution$str(), (Object)cacheName, (Object)currentTopology);
    }

    protected String startingConflictResolution$str() {
        return "ISPN000522: Conflict resolution starting for cache %s with topology %s";
    }

    @Override
    public final void finishedConflictResolution(String cacheName, CacheTopology currentTopology) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.finishedConflictResolution$str(), (Object)cacheName, (Object)currentTopology);
    }

    protected String finishedConflictResolution$str() {
        return "ISPN000523: Conflict resolution finished for cache %s with topology %s";
    }

    @Override
    public final void failedConflictResolution(String cacheName, CacheTopology currentTopology, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedConflictResolution$str(), (Object)cacheName, (Object)currentTopology);
    }

    protected String failedConflictResolution$str() {
        return "ISPN000524: Conflict resolution failed for cache %s with topology %s";
    }

    @Override
    public final void cancelledConflictResolution(String cacheName, CacheTopology currentTopology) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.cancelledConflictResolution$str(), (Object)cacheName, (Object)currentTopology);
    }

    protected String cancelledConflictResolution$str() {
        return "ISPN000525: Conflict resolution cancelled for cache %s with topology %s";
    }

    protected String degradedModeLockUnavailable$str() {
        return "ISPN000528: Cannot acquire lock %s as this partition is DEGRADED";
    }

    @Override
    public final AvailabilityException degradedModeLockUnavailable(Object key) {
        AvailabilityException result = new AvailabilityException(String.format(this.getLoggingLocale(), this.degradedModeLockUnavailable$str(), key));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String errorDeserializing$str() {
        return "ISPN000529: Class '%s' blocked by deserialization allow list. Include the class name in the server allow list to authorize.";
    }

    @Override
    public final CacheException errorDeserializing(String className) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.errorDeserializing$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passivationStoreCannotBeShared$str() {
        return "ISPN000532: Invalid cache loader configuration for '%s'.  If a cache loader is configured with passivation, the cache loader cannot be shared in a cluster!";
    }

    @Override
    public final CacheConfigurationException passivationStoreCannotBeShared(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.passivationStoreCannotBeShared$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorConvertingContent$str() {
        return "ISPN000533: Content '%s (MediaType: '%s') cannot be converted to '%s'";
    }

    @Override
    public final EncodingException errorConvertingContent(Object content, MediaType contentType, MediaType destination, Throwable e) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.errorConvertingContent$str(), content, contentType, destination), e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String groupingOnlyCompatibleWithObjectStorage$str() {
        return "ISPN000535: Grouping requires application/x-java-object storage type but was: {key=%s, value=%s}";
    }

    @Override
    public final CacheConfigurationException groupingOnlyCompatibleWithObjectStorage(MediaType keyMediaType, MediaType valueMediaType) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.groupingOnlyCompatibleWithObjectStorage$str(), keyMediaType, valueMediaType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String factoryCannotConstructComponent$str() {
        return "ISPN000537: Factory doesn't know how to construct component %s";
    }

    @Override
    public final CacheConfigurationException factoryCannotConstructComponent(String componentName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.factoryCannotConstructComponent$str(), componentName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void moduleStopError(String module, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.moduleStopError$str(), (Object)module);
    }

    protected String moduleStopError$str() {
        return "ISPN000538: Error stopping module %s";
    }

    protected String duplicateJGroupsStack$str() {
        return "ISPN000539: Duplicate JGroups stack '%s'";
    }

    @Override
    public final CacheConfigurationException duplicateJGroupsStack(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateJGroupsStack$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingJGroupsStack$str() {
        return "ISPN000540: No such JGroups stack '%s'";
    }

    @Override
    public final CacheConfigurationException missingJGroupsStack(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingJGroupsStack$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCreatingChannelFromConfigurator$str() {
        return "ISPN000541: Error while trying to create a channel using the specified configuration '%s'";
    }

    @Override
    public final CacheConfigurationException errorCreatingChannelFromConfigurator(String configurator, Throwable t) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.errorCreatingChannelFromConfigurator$str(), configurator), t);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidScope$str() {
        return "ISPN000542: Invalid parser scope. Expected '%s' but was '%s'";
    }

    @Override
    public final CacheConfigurationException invalidScope(String expected, String found) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidScope$str(), expected, found));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jgroupsNoStackPosition$str() {
        return "ISPN000543: Cannot use stack.position when stack.combine is '%s'";
    }

    @Override
    public final CacheConfigurationException jgroupsNoStackPosition(String combineMode) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.jgroupsNoStackPosition$str(), combineMode));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jgroupsNoSuchProtocol$str() {
        return "ISPN000544: The protocol '%s' does not exist in the base stack for operation '%s'";
    }

    @Override
    public final CacheConfigurationException jgroupsNoSuchProtocol(String protocolName, String combineMode) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.jgroupsNoSuchProtocol$str(), protocolName, combineMode));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jgroupsInsertRequiresPosition$str() {
        return "ISPN000545: Inserting protocol '%s' in a JGroups stack requires the 'stack.position' attribute";
    }

    @Override
    public final CacheConfigurationException jgroupsInsertRequiresPosition(String protocolName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.jgroupsInsertRequiresPosition$str(), protocolName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateRemoteSite$str() {
        return "ISPN000546: Duplicate remote site '%s' in stack '%s'";
    }

    @Override
    public final CacheConfigurationException duplicateRemoteSite(String remoteSite, String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateRemoteSite$str(), remoteSite, name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jgroupsRemoteSitesWithoutRelay$str() {
        return "ISPN000547: JGroups stack '%s' declares remote sites but does not include the RELAY2 protocol.";
    }

    @Override
    public final CacheConfigurationException jgroupsRemoteSitesWithoutRelay(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.jgroupsRemoteSitesWithoutRelay$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jgroupsRelayWithoutRemoteSites$str() {
        return "ISPN000548: JGroups stack '%s' has a RELAY2 protocol without remote sites.";
    }

    @Override
    public final CacheConfigurationException jgroupsRelayWithoutRemoteSites(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.jgroupsRelayWithoutRemoteSites$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sharedStoreWithLocalCache$str() {
        return "ISPN000549: A store cannot be shared when utilised with a local cache.";
    }

    @Override
    public final CacheConfigurationException sharedStoreWithLocalCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.sharedStoreWithLocalCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidationPartitionHandlingNotSuported$str() {
        return "ISPN000550: Invalidation mode only supports when-split=ALLOW_READ_WRITES";
    }

    @Override
    public final CacheConfigurationException invalidationPartitionHandlingNotSuported() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidationPartitionHandlingNotSuported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void customInterceptorsIgnored() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.customInterceptorsIgnored$str(), new Object[0]);
    }

    protected String customInterceptorsIgnored$str() {
        return "ISPN000551: The custom interceptors configuration has been deprecated and are ignored";
    }

    @Override
    public final void marshallersNotSupported() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.marshallersNotSupported$str(), new Object[0]);
    }

    protected String marshallersNotSupported$str() {
        return "ISPN000553: Ignoring 'marshaller' attribute. Common marshallers are already available at runtime, and to deploy a custom marshaller, consult the 'Encoding' section in the user guide";
    }

    @Override
    public final void startingUserMarshaller(String marshallerClass) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingUserMarshaller$str(), (Object)marshallerClass);
    }

    protected String startingUserMarshaller$str() {
        return "ISPN000556: Starting user marshaller '%s'";
    }

    protected String unableToAddJGroupsStack$str() {
        return "ISPN000557: Unable to configure JGroups Stack '%s'";
    }

    @Override
    public final CacheConfigurationException unableToAddJGroupsStack(String name, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unableToAddJGroupsStack$str(), name), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String forbiddenStoreLocation$str() {
        return "ISPN000558: The store location '%s' is not a child of the global persistent location '%s'";
    }

    @Override
    public final CacheConfigurationException forbiddenStoreLocation(Path location, Path global) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.forbiddenStoreLocation$str(), location, global));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotMarshall(Class<?> aClass, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.cannotMarshall$str(), aClass);
    }

    protected String cannotMarshall$str() {
        return "ISPN000559: Cannot marshall '%s'";
    }

    protected String invalidChunkSize$str() {
        return "ISPN000561: Chunk size must be positive, got %d";
    }

    @Override
    public final CacheConfigurationException invalidChunkSize(int chunkSize) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidChunkSize$str(), chunkSize));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sharedStoreShouldNotBePurged$str() {
        return "ISPN000562: Invalid cache loader configuration for '%s'.  If a cache loader is configured with purgeOnStartup, the cache loader cannot be shared in a cluster!";
    }

    @Override
    public final CacheConfigurationException sharedStoreShouldNotBePurged(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.sharedStoreShouldNotBePurged$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeDoesNotSupportBeingSegmented$str() {
        return "ISPN000563: Invalid cache loader configuration for '%s'.  This implementation does not support being segmented!";
    }

    @Override
    public final CacheConfigurationException storeDoesNotSupportBeingSegmented(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeDoesNotSupportBeingSegmented$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String threadPoolFactoryIsBlocking$str() {
        return "ISPN000566: Thread Pool Factory %s is blocking, but pool %s requires non blocking threads";
    }

    @Override
    public final CacheConfigurationException threadPoolFactoryIsBlocking(String name, String poolName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.threadPoolFactoryIsBlocking$str(), name, poolName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void warnUnableToPersistInternalCaches() {
        if (this.log.isEnabled(Logger.Level.WARN) && warnUnableToPersistInternalCaches_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.warnUnableToPersistInternalCaches$str(), new Object[0]);
        }
    }

    protected String warnUnableToPersistInternalCaches$str() {
        return "ISPN000569: Unable to persist Infinispan internal caches as no global state enabled";
    }

    protected String unexpectedResponse$str() {
        return "ISPN000570: Unexpected response from %s: %s";
    }

    @Override
    public final IllegalArgumentException unexpectedResponse(Address target, Response response) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unexpectedResponse$str(), target, response));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String crossSiteUnavailable$str() {
        return "ISPN000571: RELAY2 not found in the protocol stack. Cannot perform cross-site operations.";
    }

    @Override
    public final CacheConfigurationException crossSiteUnavailable() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.crossSiteUnavailable$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatiblePersistedConfiguration$str() {
        return "ISPN000573: Cannot recreate persisted configuration for cache '%s' because configuration %n%s%n is incompatible with the existing configuration %n%s";
    }

    @Override
    public final CacheConfigurationException incompatiblePersistedConfiguration(String cacheName, Configuration configuration, Configuration existing) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.incompatiblePersistedConfiguration$str(), new Object[]{cacheName, configuration, existing}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void incompleteGlobalState() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.incompleteGlobalState$str(), new Object[0]);
    }

    protected String incompleteGlobalState$str() {
        return "ISPN000574: Global state cannot persisted because it is incomplete (usually caused by errors at startup).";
    }

    protected String singleOwnerNotSetToAllowReadWrites$str() {
        return "ISPN000575: PartitionStrategy must be ALLOW_READ_WRITES when numOwners is 1";
    }

    @Override
    public final CacheConfigurationException singleOwnerNotSetToAllowReadWrites() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.singleOwnerNotSetToAllowReadWrites$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xsiteInLocalCache0$str() {
        return "ISPN000576: Cross-site replication not available for local cache.";
    }

    @Override
    public final CacheConfigurationException xsiteInLocalCache() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.xsiteInLocalCache0$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingTypeForUnwrappedPayload$str() {
        return "ISPN000577: Converting from unwrapped protostream payload requires the 'type' parameter to be supplied in the destination MediaType";
    }

    @Override
    public final MarshallingException missingTypeForUnwrappedPayload() {
        MarshallingException result = new MarshallingException(String.format(this.getLoggingLocale(), this.missingTypeForUnwrappedPayload$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void startMigratingPersistenceData(String cacheName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startMigratingPersistenceData$str(), (Object)cacheName);
    }

    protected String startMigratingPersistenceData$str() {
        return "ISPN000578: Migrating '%s' persisted data to new format...";
    }

    @Override
    public final void persistedDataSuccessfulMigrated(String cacheName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.persistedDataSuccessfulMigrated$str(), (Object)cacheName);
    }

    protected String persistedDataSuccessfulMigrated$str() {
        return "ISPN000579: '%s' persisted data successfully migrated.";
    }

    protected String persistedDataMigrationFailed$str() {
        return "ISPN000580: Failed to migrate '%s' persisted data.";
    }

    @Override
    public final PersistenceException persistedDataMigrationFailed(String cacheName, Throwable cause) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.persistedDataMigrationFailed$str(), cacheName), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String cannotProvideBothSizeAndCount$str() {
        return "ISPN000583: Cannot configure both maxCount and maxSize in memory configuration";
    }

    @Override
    public final CacheConfigurationException cannotProvideBothSizeAndCount() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotProvideBothSizeAndCount$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ignoringSpecificMediaTypes() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringSpecificMediaTypes$str(), new Object[0]);
    }

    protected String ignoringSpecificMediaTypes$str() {
        return "ISPN000585: Single media-type was specified for keys and values, ignoring individual configurations";
    }

    @Override
    public final void warnUsingDeprecatedMemoryConfigs(String element) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnUsingDeprecatedMemoryConfigs$str(), (Object)element);
    }

    protected String warnUsingDeprecatedMemoryConfigs$str() {
        return "ISPN000586: The memory configuration element '%s' has been deprecated. Please update your configuration";
    }

    protected String cannotChangeMaxSize$str() {
        return "ISPN000587: Cannot change max-size since max-count is already defined";
    }

    @Override
    public final CacheConfigurationException cannotChangeMaxSize() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotChangeMaxSize$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotChangeMaxCount$str() {
        return "ISPN000588: Cannot change max-count since max-size is already defined";
    }

    @Override
    public final CacheConfigurationException cannotChangeMaxCount() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotChangeMaxCount$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String preloadAndPurgeOnStartupConflict$str() {
        return "ISPN000589: A store cannot be configured with both preload and purgeOnStartup";
    }

    @Override
    public final CacheConfigurationException preloadAndPurgeOnStartupConflict() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.preloadAndPurgeOnStartupConflict$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeBothReadAndWriteOnly$str() {
        return "ISPN000590: Store cannot be configured with both read and write only!";
    }

    @Override
    public final CacheConfigurationException storeBothReadAndWriteOnly() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeBothReadAndWriteOnly$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeReadOnlyExceptions$str() {
        return "ISPN000591: Store cannot be configured with purgeOnStartup, shared or passivation if it is read only!";
    }

    @Override
    public final CacheConfigurationException storeReadOnlyExceptions() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeReadOnlyExceptions$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeWriteOnlyExceptions$str() {
        return "ISPN000592: Store cannot be configured with fetchPersistenceState or preload if it is write only!";
    }

    @Override
    public final CacheConfigurationException storeWriteOnlyExceptions() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeWriteOnlyExceptions$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeConfiguredHasBothReadAndWriteOnly$str() {
        return "ISPN000593: Store %s cannot be configured to be %s as the implementation specifies it is already %s!";
    }

    @Override
    public final CacheConfigurationException storeConfiguredHasBothReadAndWriteOnly(String storeClassName, NonBlockingStore.Characteristic configured, NonBlockingStore.Characteristic implSpecifies) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeConfiguredHasBothReadAndWriteOnly$str(), new Object[]{storeClassName, configured, implSpecifies}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String onlyOnePreloadStoreAllowed$str() {
        return "ISPN000594: At most one store can be set to 'preload'!";
    }

    @Override
    public final CacheConfigurationException onlyOnePreloadStoreAllowed() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.onlyOnePreloadStoreAllowed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeConfiguredTransactionalButCharacteristicNotPresent$str() {
        return "ISPN000597: Store %s cannot be configured to be transactional as it does not contain the TRANSACTIONAL characteristic";
    }

    @Override
    public final CacheConfigurationException storeConfiguredTransactionalButCharacteristicNotPresent(String storeClassName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeConfiguredTransactionalButCharacteristicNotPresent$str(), storeClassName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeLocationRequired0$str() {
        return "ISPN000598: Store must specify a location when global state is disabled";
    }

    @Override
    public final CacheConfigurationException storeLocationRequired() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeLocationRequired0$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeLocationRequired2$str() {
        return "ISPN000598: Store '%s' must specify the '%s' attribute when global state is disabled";
    }

    @Override
    public final CacheConfigurationException storeLocationRequired(String storeType, String attributeName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeLocationRequired2$str(), storeType, attributeName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unknownEncoding(String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownEncoding$str(), (Object)cacheName);
    }

    protected String unknownEncoding$str() {
        return "ISPN000599: Configuration for cache '%s' does not define the encoding for keys or values. If you use operations that require data conversion or queries, you should configure the cache with a specific MediaType for keys or values.";
    }

    protected String storeConfiguredSharedButCharacteristicNotPresent$str() {
        return "ISPN000600: Store %s cannot be configured to be shared as it does not contain the SHARED characteristic";
    }

    @Override
    public final CacheConfigurationException storeConfiguredSharedButCharacteristicNotPresent(String storeClassName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeConfiguredSharedButCharacteristicNotPresent$str(), storeClassName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String storeConfiguredSegmentedButCharacteristicNotPresent$str() {
        return "ISPN000601: Store %s cannot be configured to be segmented as it does not contain the SEGMENTABLE characteristic";
    }

    @Override
    public final CacheConfigurationException storeConfiguredSegmentedButCharacteristicNotPresent(String storeClassName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.storeConfiguredSegmentedButCharacteristicNotPresent$str(), storeClassName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void jsonObjectConversionDeprecated() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jsonObjectConversionDeprecated$str(), new Object[0]);
    }

    protected String jsonObjectConversionDeprecated$str() {
        return "ISPN000602: Conversions between JSON and Java Objects are deprecated and will be removed in a future version. To read/write values as JSON, it is recommended to define a protobuf schema and store data in the cache using 'application/x-protostream' as MediaType";
    }

    protected String xsiteCacheNotFound$str() {
        return "ISPN000603: Cannot handle cross-site request from site '%s'. Cache '%s' not found.";
    }

    @Override
    public final CacheConfigurationException xsiteCacheNotFound(String remoteSite, ByteString cacheName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.xsiteCacheNotFound$str(), remoteSite, cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xsiteCacheNotStarted$str() {
        return "ISPN000604: Cannot handle cross-site request from site '%s'. Cache '%s' is stopped.";
    }

    @Override
    public final CrossSiteIllegalLifecycleStateException xsiteCacheNotStarted(String origin, ByteString cacheName) {
        CrossSiteIllegalLifecycleStateException result = new CrossSiteIllegalLifecycleStateException(String.format(this.getLoggingLocale(), this.xsiteCacheNotStarted$str(), origin, cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String xsiteInLocalCache2$str() {
        return "ISPN000605: Cannot handle cross-site request from site '%s'. Cache '%s' is not clustered.";
    }

    @Override
    public final CacheConfigurationException xsiteInLocalCache(String origin, ByteString cacheName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.xsiteInLocalCache2$str(), origin, cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void xsiteInvalidConfigurationRemoteSite(String siteName, CacheConfigurationException exception) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)exception, this.xsiteInvalidConfigurationRemoteSite$str(), (Object)siteName);
    }

    protected String xsiteInvalidConfigurationRemoteSite$str() {
        return "ISPN000606: Remote site '%s' has an invalid cache configuration. Taking the backup location offline.";
    }

    protected String missingXSiteEntryMergePolicy$str() {
        return "ISPN000607: The XSiteEntryMergePolicy is missing. The cache configuration must include a merge policy.";
    }

    @Override
    public final CacheConfigurationException missingXSiteEntryMergePolicy() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingXSiteEntryMergePolicy$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unexpectedErrorFromIrac(Throwable t) {
        this.log.logf(FQCN, Logger.Level.FATAL, t, this.unexpectedErrorFromIrac$str(), new Object[0]);
    }

    protected String unexpectedErrorFromIrac$str() {
        return "ISPN000608: [IRAC] Unexpected error occurred.";
    }

    @Override
    public final void cannotObtainFailedCache(String name, Throwable t) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t, this.cannotObtainFailedCache$str(), (Object)name);
    }

    protected String cannotObtainFailedCache$str() {
        return "ISPN000609: Cannot obtain cache '%s' as it is in FAILED state. Please check the configuration";
    }

    protected String indexableClassesDefined$str() {
        return "ISPN000610: Cache configuration must not declare indexed entities if it is not indexed";
    }

    @Override
    public final CacheConfigurationException indexableClassesDefined() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.indexableClassesDefined$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexStorage$str() {
        return "ISPN000611: Invalid index storage";
    }

    @Override
    public final CacheConfigurationException invalidIndexStorage() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidIndexStorage$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void deprecatedIndexProperties() {
        if (this.log.isEnabled(Logger.Level.WARN) && deprecatedIndexProperties_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedIndexProperties$str(), new Object[0]);
        }
    }

    protected String deprecatedIndexProperties$str() {
        return "ISPN000613: Indexing configuration using properties has been deprecated and will be removed in a future version, please use the <index-writer> and <index-reader> elements to configure indexing behavior.";
    }

    protected String foundDifferentIndexConfigPerType$str() {
        return "ISPN000614: It is not allowed to have different indexing configuration for each indexed type in a cache.";
    }

    @Override
    public final CacheConfigurationException foundDifferentIndexConfigPerType() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.foundDifferentIndexConfigPerType$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String marshallerMissingFromUserAndGlobalContext$str() {
        return "ISPN000615: Unable to unmarshall '%s' as a marshaller is not present in the user or global SerializationContext";
    }

    @Override
    public final MarshallingException marshallerMissingFromUserAndGlobalContext(String type) {
        MarshallingException result = new MarshallingException(String.format(this.getLoggingLocale(), this.marshallerMissingFromUserAndGlobalContext$str(), type));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String persistedDataMigrationUnsupportedVersion$str() {
        return "ISPN000616: Unsupported persisted data version: %s";
    }

    @Override
    public final PersistenceException persistedDataMigrationUnsupportedVersion(String magic) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.persistedDataMigrationUnsupportedVersion$str(), magic));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String siteNotFound$str() {
        return "ISPN000617: Site '%s' not found.";
    }

    @Override
    public final IllegalArgumentException siteNotFound(String siteName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.siteNotFound$str(), siteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void xsiteCancelSendFailed(Throwable throwable, String remoteSite) {
        this.log.logf(FQCN, Logger.Level.WARN, throwable, this.xsiteCancelSendFailed$str(), (Object)remoteSite);
    }

    protected String xsiteCancelSendFailed$str() {
        return "ISPN000618: Cleanup failed for cross-site state transfer. Invoke the cancel-push-state(%s) command if any nodes indicate pending operations to push state.";
    }

    @Override
    public final void xsiteCancelReceiveFailed(Throwable throwable, String localSite, String remoteSite) {
        this.log.logf(FQCN, Logger.Level.WARN, throwable, this.xsiteCancelReceiveFailed$str(), (Object)localSite, (Object)remoteSite);
    }

    protected String xsiteCancelReceiveFailed$str() {
        return "ISPN000619: Cleanup failed for cross-site state transfer. Invoke the cancel-receive(%s) command in site %s if any nodes indicate pending operations to receive state.";
    }

    protected String xsiteStateTransferAlreadyInProgress$str() {
        return "ISPN000620: Cross-site state transfer to '%s' already started";
    }

    @Override
    public final CacheException xsiteStateTransferAlreadyInProgress(String site) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.xsiteStateTransferAlreadyInProgress$str(), site));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elementRemoved$str() {
        return "ISPN000622: Element '%s' at %s has been removed with no replacement";
    }

    @Override
    public final CacheConfigurationException elementRemoved(String elementName, Location location) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.elementRemoved$str(), elementName, location));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributeRemoved$str() {
        return "ISPN000624: Attribute '%2$s' of element '%1$s' at '%3$s' has been removed with no replacement";
    }

    @Override
    public final CacheConfigurationException attributeRemoved(String elementName, String attributeName, Location location) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.attributeRemoved$str(), elementName, attributeName, location));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void indexLocationWorkingDir() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.indexLocationWorkingDir$str(), new Object[0]);
    }

    protected String indexLocationWorkingDir$str() {
        return "ISPN000625: Index path not provided and global state disabled, will use the current working directory for storage.";
    }

    @Override
    public final void indexRelativeWorkingDir(String path) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.indexRelativeWorkingDir$str(), (Object)path);
    }

    protected String indexRelativeWorkingDir$str() {
        return "ISPN000626: Index path '%s' is not absolute and global state is disabled, will use a dir relative to the current working directory.";
    }

    protected String noSuchGlobalRoles$str() {
        return "ISPN000628: Invalid cache roles '%s'";
    }

    @Override
    public final CacheConfigurationException noSuchGlobalRoles(Set<String> cacheRoles) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noSuchGlobalRoles$str(), cacheRoles));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedPartitionHandlingTxCompletion(GlobalTransaction globalTransaction, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.failedPartitionHandlingTxCompletion$str(), (Object)globalTransaction);
    }

    protected String failedPartitionHandlingTxCompletion$str() {
        return "ISPN000629: Exception completing partial completed transaction %s. Retrying later.";
    }

    protected String invalidXSiteStateTransferMode$str() {
        return "ISPN000633: Cross-site state transfer mode cannot be null.";
    }

    @Override
    public final CacheConfigurationException invalidXSiteStateTransferMode() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidXSiteStateTransferMode$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String autoXSiteStateTransferModeNotAvailableInSync$str() {
        return "ISPN000634: Cross-site automatic state transfer is not compatible with SYNC backup strategy.";
    }

    @Override
    public final CacheConfigurationException autoXSiteStateTransferModeNotAvailableInSync() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.autoXSiteStateTransferModeNotAvailableInSync$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unableToStartXSiteAutStateTransfer(String cacheName, String targetSite, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.unableToStartXSiteAutStateTransfer$str(), (Object)cacheName, (Object)targetSite);
    }

    protected String unableToStartXSiteAutStateTransfer$str() {
        return "ISPN000635: [%s] Failed to receive a response from any nodes. Automatic cross-site state transfer to site '%s' is not started.";
    }

    protected String invalidStateTransferTimeout$str() {
        return "ISPN000636: State transfer timeout (%s) must be greater than or equal to the remote timeout (%s)";
    }

    @Override
    public final CacheConfigurationException invalidStateTransferTimeout(String stateTransferTimeout, String remoteTimeout) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidStateTransferTimeout$str(), stateTransferTimeout, remoteTimeout));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String topologyTimeout$str() {
        return "ISPN000637: Timeout waiting for topology %d, current topology is %d";
    }

    @Override
    public final TimeoutException topologyTimeout(int expectedTopologyId, int currentTopologyId) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.topologyTimeout$str(), expectedTopologyId, currentTopologyId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionDataTimeout$str() {
        return "ISPN000638: Timeout waiting for topology %d transaction data";
    }

    @Override
    public final TimeoutException transactionDataTimeout(int expectedTopologyId) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.transactionDataTimeout$str(), expectedTopologyId));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionAlreadyRolledBack$str() {
        return "ISPN000641: The transaction %s is already rolled back";
    }

    @Override
    public final InvalidTransactionException transactionAlreadyRolledBack(GlobalTransaction gtx) {
        InvalidTransactionException result = new InvalidTransactionException(String.format(this.getLoggingLocale(), this.transactionAlreadyRolledBack$str(), gtx));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void startRecoveringCorruptPersistenceData(String cacheName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startRecoveringCorruptPersistenceData$str(), (Object)cacheName);
    }

    protected String startRecoveringCorruptPersistenceData$str() {
        return "ISPN000642: Attempting to recover possibly corrupted data file %s";
    }

    protected String corruptDataMigrationFailed$str() {
        return "ISPN000644: Failed to recover '%s' persisted data.";
    }

    @Override
    public final PersistenceException corruptDataMigrationFailed(String cacheName, Throwable cause) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.corruptDataMigrationFailed$str(), cacheName), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String invalidTouchMode$str() {
        return "ISPN000645: Asynchronous cache modes, such as %s, cannot use SYNC touch mode for maximum idle expiration.";
    }

    @Override
    public final CacheConfigurationException invalidTouchMode(CacheMode cacheMode) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidTouchMode$str(), new Object[]{cacheMode}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalCapacityFactor$str() {
        return "ISPN000646: capacityFactor must be positive";
    }

    @Override
    public final IllegalArgumentException illegalCapacityFactor() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalCapacityFactor$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUpdateInternalCache$str() {
        return "ISPN000647: The configuration for internal cache '%s' cannot be modified";
    }

    @Override
    public final IllegalArgumentException cannotUpdateInternalCache(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotUpdateInternalCache$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddStore$str() {
        return "ISPN000648: Cache '%s' is non empty, cannot add store.";
    }

    @Override
    public final PersistenceException cannotAddStore(String cacheName) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotAddStore$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String invalidSingleFileStoreData$str() {
        return "ISPN000650: Read invalid data in SingleFileStore file %s, please remove the file and retry";
    }

    @Override
    public final PersistenceException invalidSingleFileStoreData(String path) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.invalidSingleFileStoreData$str(), path));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String maxIdleNotAllowedWithoutPassivation$str() {
        return "ISPN000651: Max idle is not allowed while using a store without passivation";
    }

    @Override
    public final CacheConfigurationException maxIdleNotAllowedWithoutPassivation() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.maxIdleNotAllowedWithoutPassivation$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void maxIdleNotTestedWithPassivation() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.maxIdleNotTestedWithPassivation$str(), new Object[0]);
    }

    protected String maxIdleNotTestedWithPassivation$str() {
        return "ISPN000652: Max idle is not supported when using a store";
    }

    @Override
    public final void attributeDeprecatedUseOther(Enum<?> attr, Enum<?> element, Enum<?> other) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attributeDeprecatedUseOther$str(), attr, element, other);
    }

    protected String attributeDeprecatedUseOther$str() {
        return "ISPN000653: The '%s' attribute on the '%s' element has been deprecated. Please use the '%s' attribute instead";
    }

    protected String problemPreloadingKey$str() {
        return "ISPN000654: Problem encountered when preloading key %s!";
    }

    @Override
    public final PersistenceException problemPreloadingKey(Object key, Throwable t) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.problemPreloadingKey$str(), key), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String invalidJson$str() {
        return "ISPN000655: Unable to convert text content to JSON: '%s'";
    }

    @Override
    public final EncodingException invalidJson(String s) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.invalidJson$str(), s));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidPolicyWithAsyncStrategy$str() {
        return "ISPN000656: The backup '%s' configuration 'failure-policy=%s' is not valid with an ASYNC backup strategy.";
    }

    @Override
    public final CacheConfigurationException invalidPolicyWithAsyncStrategy(String remoteSite, BackupFailurePolicy policy) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidPolicyWithAsyncStrategy$str(), new Object[]{remoteSite, policy}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failurePolicyClassNotCompatibleWith$str() {
        return "ISPN000657: The backup '%s' configuration 'failure-policy-class' is not compatible with 'failure-policy=%s'. Use 'failure-policy=\"CUSTOM\"'";
    }

    @Override
    public final CacheConfigurationException failurePolicyClassNotCompatibleWith(String remoteSite, BackupFailurePolicy policy) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.failurePolicyClassNotCompatibleWith$str(), new Object[]{remoteSite, policy}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String initialStateTransferTimeout$str() {
        return "ISPN000658: Initial state transfer timed out for cache %s on %s";
    }

    @Override
    public final TimeoutException initialStateTransferTimeout(String cacheName, Address localAddress) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.initialStateTransferTimeout$str(), cacheName, localAddress));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentFailedToStart$str() {
        return "ISPN000659: Component %s failed to start";
    }

    @Override
    public final CacheConfigurationException componentFailedToStart(String componentName, Throwable t) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.componentFailedToStart$str(), componentName), t);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void startFailure(String registryName, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.startFailure$str(), (Object)registryName);
    }

    protected String startFailure$str() {
        return "ISPN000660: %s start failed, stopping any running components";
    }

    @Override
    public final void configDeprecated(Enum<?> element) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configDeprecated$str(), element);
    }

    protected String configDeprecated$str() {
        return "ISPN000661: '%s' has been deprecated with no replacement.";
    }

    @Override
    public final void failedToTransferTombstones(Address requestor, IntSet segments, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.failedToTransferTombstones$str(), (Object)requestor, (Object)segments);
    }

    protected String failedToTransferTombstones$str() {
        return "ISPN000662: Failed to transfer cross-site tombstones to %s for segments %s.";
    }

    protected String invalidNameSize$str() {
        return "ISPN000663: Name must be less than 256 bytes, current name '%s' exceeds the size.";
    }

    @Override
    public final CacheConfigurationException invalidNameSize(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidNameSize$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexStartUpMode$str() {
        return "ISPN000664: Invalid index startup mode: %s";
    }

    @Override
    public final CacheConfigurationException invalidIndexStartUpMode(String invalidValue) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidIndexStartUpMode$str(), invalidValue));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void scheduledTaskEncounteredThrowable(Object identifier, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.scheduledTaskEncounteredThrowable$str(), identifier);
    }

    protected String scheduledTaskEncounteredThrowable$str() {
        return "ISPN000665: There was an error in submitted periodic task with %s, not rescheduling.";
    }

    protected String requireNonNullClusterName$str() {
        return "ISPN000666: Transport clusterName cannot be null.";
    }

    @Override
    public final CacheConfigurationException requireNonNullClusterName() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.requireNonNullClusterName$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requireNodeName$str() {
        return "ISPN000667: Transport node-name is not set.";
    }

    @Override
    public final CacheConfigurationException requireNodeName() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.requireNodeName$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nodeNameNotInRaftMembers$str() {
        return "ISPN000668: Transport node-name must be present in raft-members: %s";
    }

    @Override
    public final CacheConfigurationException nodeNameNotInRaftMembers(String members) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.nodeNameNotInRaftMembers$str(), members));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String forkProtocolRequired$str() {
        return "ISPN000669: FORK protocol required on JGroups channel.";
    }

    @Override
    public final IllegalArgumentException forkProtocolRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.forkProtocolRequired$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorCreatingForkChannel(String name, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.errorCreatingForkChannel$str(), (Object)name);
    }

    protected String errorCreatingForkChannel$str() {
        return "ISPN000670: Error creating fork channel for %s";
    }

    @Override
    public final void raftProtocolUnavailable(String reason) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.raftProtocolUnavailable$str(), (Object)reason);
    }

    protected String raftProtocolUnavailable$str() {
        return "ISPN000671: RAFT protocol is not available. Reason: %s";
    }

    @Override
    public final void raftProtocolAvailable() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.raftProtocolAvailable$str(), new Object[0]);
    }

    protected String raftProtocolAvailable$str() {
        return "ISPN000672: RAFT protocol is available.";
    }

    protected String raftGlobalStateDisabled$str() {
        return "ISPN000673: Cannot persist RAFT data as global state is disabled";
    }

    @Override
    public final CacheConfigurationException raftGlobalStateDisabled() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.raftGlobalStateDisabled$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String issueEncounteredResettingIndex$str() {
        return "ISPN000674: There was an error when resetting the SIFS index for cache %s";
    }

    @Override
    public final PersistenceException issueEncounteredResettingIndex(String cacheName, Throwable t) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.issueEncounteredResettingIndex$str(), cacheName), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void failedInvokingEventLoggerListener(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failedInvokingEventLoggerListener$str(), new Object[0]);
    }

    protected String failedInvokingEventLoggerListener$str() {
        return "ISPN000675: Caught exception while invoking a event logger listener!";
    }

    @Override
    public final void storeIsAvailableCheckThrewException(Throwable e, String storeImpl) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.storeIsAvailableCheckThrewException$str(), (Object)storeImpl);
    }

    protected String storeIsAvailableCheckThrewException$str() {
        return "ISPN000676: Store '%s'#isAvailable check threw Exception";
    }

    @Override
    public final void storeIsAvailableCompletedExceptionally(Throwable e, String storeImpl) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.storeIsAvailableCompletedExceptionally$str(), (Object)storeImpl);
    }

    protected String storeIsAvailableCompletedExceptionally$str() {
        return "ISPN000677: Store '%s'#isAvailable completed Exceptionally";
    }

    @Override
    public final void persistenceUnavailable(String storeImpl) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.persistenceUnavailable$str(), (Object)storeImpl);
    }

    protected String persistenceUnavailable$str() {
        return "ISPN000678: Persistence is unavailable because of store %s";
    }

    @Override
    public final void persistenceAvailable() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.persistenceAvailable$str(), new Object[0]);
    }

    protected String persistenceAvailable$str() {
        return "ISPN000679: Persistence is now available";
    }

    protected String expirationNotAllowedWhenStoreDoesNotSupport$str() {
        return "ISPN000680: Expiration (Max idle or Lifespan) is not allowed while using a store '%s' that does not support expiration, unless it is configured as read only";
    }

    @Override
    public final CacheConfigurationException expirationNotAllowedWhenStoreDoesNotSupport(String storeImpl) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.expirationNotAllowedWhenStoreDoesNotSupport$str(), storeImpl));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingRequiredProperty$str() {
        return "ISPN000681: Missing required property '%s' for attribute '%s' at %s";
    }

    @Override
    public final CacheConfigurationException missingRequiredProperty(String property, String name, Location location) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingRequiredProperty$str(), property, name, location));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAttributeValue$str() {
        return "ISPN000686: Attribute '%2$s' of element '%1$s' has an illegal value '%3$s' at %4$s: %5$s";
    }

    @Override
    public final CacheConfigurationException invalidAttributeValue(String element, String attribute, String value, Location location, String message) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidAttributeValue$str(), element, attribute, value, location, message));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAttributeEnumValue$str() {
        return "ISPN000687: Attribute '%2$s' of element '%1$s' has an illegal value '%3$s' at %5$s. Expecting one of %4$s.";
    }

    @Override
    public final CacheConfigurationException invalidAttributeEnumValue(String element, String attribute, String value, String world, Location location) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidAttributeEnumValue$str(), element, attribute, value, world, location));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void attributeDeprecated(String name, String element, int major, int minor) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attributeDeprecated$str(), new Object[]{name, element, major, minor});
    }

    protected String attributeDeprecated$str() {
        return "ISPN000688: Attribute '%s' of element '%s' has been deprecated since schema version %d.%d. Refer to the upgrade guide";
    }

    @Override
    public final void recoverFromStateMissingMembers(String cacheName, List<Address> members, int total) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recoverFromStateMissingMembers$str(), (Object)cacheName, members, (Object)total);
    }

    protected String recoverFromStateMissingMembers$str() {
        return "ISPN000689: Recovering cache '%s' but there are missing members, known members %s of a total of %s";
    }

    @Override
    public final MissingMembersException recoverFromStateMissingMembers(String cacheName, List<Address> members, String total) {
        MissingMembersException result = new MissingMembersException(String.format(this.getLoggingLocale(), this.recoverFromStateMissingMembers$str(), cacheName, members, total));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void configurationNotFound(String cacheName, Collection<String> definedConfigurations) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.configurationNotFound$str(), (Object)cacheName, definedConfigurations);
    }

    protected String configurationNotFound$str() {
        return "ISPN000690: We cannot find a configuration for the cache '%s' in the available configurations: '%s'. This cache has been probably removed by another thread. Skip to writing it.";
    }

    protected String indexedEntityNameMissing$str() {
        return "ISPN000691: Indexed entity name must not be null or empty";
    }

    @Override
    public final CacheConfigurationException indexedEntityNameMissing() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.indexedEntityNameMissing$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void flushedACLCache() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.flushedACLCache$str(), new Object[0]);
    }

    protected String flushedACLCache$str() {
        return "ISPN000692: Flushed ACL Cache";
    }

    protected String globalStateLockFilePresent$str() {
        return "ISPN000693: Dangling lock file '%s' in persistent global state, probably left behind by an unclean shutdown. ";
    }

    @Override
    public final CacheConfigurationException globalStateLockFilePresent(FileSystemLock lockFile) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.globalStateLockFilePresent$str(), lockFile));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingTooManyMembers$str() {
        return "ISPN000694: Cache '%s' has number of owners %d but is missing too many members (%d/%d) to reinstall topology";
    }

    @Override
    public final MissingMembersException missingTooManyMembers(String cacheName, int owners, int missing, int total) {
        MissingMembersException result = new MissingMembersException(String.format(this.getLoggingLocale(), this.missingTooManyMembers$str(), cacheName, owners, missing, total));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String queryNotSupported$str() {
        return "ISPN000695: Query module not found. Add infinispan-query to the classpath.";
    }

    @Override
    public final CacheException queryNotSupported() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.queryNotSupported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String querySimpleCacheNotSupported$str() {
        return "ISPN000696: Simple caches do not support queries. Use standard caches for querying.";
    }

    @Override
    public final CacheException querySimpleCacheNotSupported() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.querySimpleCacheNotSupported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void metricRegistrationFailed(String id, String reason) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.metricRegistrationFailed$str(), (Object)id, (Object)reason);
    }

    protected String metricRegistrationFailed$str() {
        return "ISPN000697: Failed to register metrics with id %s. Reason: %s";
    }

    protected String xsiteCacheManagerDoesNotAllowInvocations$str() {
        return "ISPN000698: Cannot handle cross-site request from site '%s'. CacheManager isn't started yet.";
    }

    @Override
    public final CrossSiteIllegalLifecycleStateException xsiteCacheManagerDoesNotAllowInvocations(String origin) {
        CrossSiteIllegalLifecycleStateException result = new CrossSiteIllegalLifecycleStateException(String.format(this.getLoggingLocale(), this.xsiteCacheManagerDoesNotAllowInvocations$str(), origin));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidTracingCollectorEndpoint$str() {
        return "ISPN000699: Tracing collector endpoint '%s' is not valid.";
    }

    @Override
    public final CacheConfigurationException invalidTracingCollectorEndpoint(String collectorEndpoint, Throwable e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidTracingCollectorEndpoint$str(), collectorEndpoint), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityCacheTracing$str() {
        return "ISPN000701: Security container cannot be enabled/disabled at cache level, since it is configured globally.";
    }

    @Override
    public final CacheConfigurationException securityCacheTracing() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.securityCacheTracing$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateAliasName$str() {
        return "ISPN000702: The alias '%s' is already being used by cache '%s'";
    }

    @Override
    public final CacheConfigurationException duplicateAliasName(String alias, String cacheName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateAliasName$str(), alias, cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void crossSiteViewEvent(String action, String sites) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.crossSiteViewEvent$str(), (Object)action, (Object)sites);
    }

    protected String crossSiteViewEvent$str() {
        return "ISPN000703: Received new cross-site event, site(s) %s: %s";
    }

    protected String marshallerNotOverridden$str() {
        return "ISPN000704: %s marshaller implementation not overridden in SerializationContext";
    }

    @Override
    public final IllegalStateException marshallerNotOverridden(String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.marshallerNotOverridden$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String maxIdleGreaterThanOrEqualLifespan$str() {
        return "ISPN000705: Max idle value must be less than lifespan when configured. Max idle value is %s and lifespan is %s";
    }

    @Override
    public final CacheConfigurationException maxIdleGreaterThanOrEqualLifespan(String maxIdle, String lifespan) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.maxIdleGreaterThanOrEqualLifespan$str(), maxIdle, lifespan));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void maxIdleGreaterThanOrEqualLifespanRuntime(long maxIdle, long lifespan) {
        if (this.log.isEnabled(Logger.Level.DEBUG) && maxIdleGreaterThanOrEqualLifespanRuntime_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.DEBUG, null, this.maxIdleGreaterThanOrEqualLifespanRuntime$str(), (Object)maxIdle, (Object)lifespan);
        }
    }

    protected String maxIdleGreaterThanOrEqualLifespanRuntime$str() {
        return "ISPN000706: Runtime encountered entry with max idle %d ms being greater or equal to lifespan %d ms, ignoring max idle";
    }

    protected String commandNotYeySupportedByAllClusterMembers$str() {
        return "ISPN000707: Command '%s' not yet supported by all cluster members, requires version '%s'";
    }

    @Override
    public final UnsupportedVersionException commandNotYeySupportedByAllClusterMembers(String command, NodeVersion version) {
        UnsupportedVersionException result = new UnsupportedVersionException(String.format(this.getLoggingLocale(), this.commandNotYeySupportedByAllClusterMembers$str(), command, version));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToInitializeCache(String cacheName, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToInitializeCache$str(), (Object)cacheName);
    }

    protected String failedToInitializeCache$str() {
        return "ISPN000708: Failed to initialize cache: '%s'";
    }

    protected String failedToBackupData$str() {
        return "ISPN000709: Failed to backup cache `%s` to one or more remote sites: %s";
    }

    @Override
    public final String failedToBackupData(String cacheName, String siteMessages) {
        return String.format(this.getLoggingLocale(), this.failedToBackupData$str(), cacheName, siteMessages);
    }

    @Override
    public final void failedToInitializeGlobalRegistry(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToInitializeGlobalRegistry$str(), new Object[0]);
    }

    protected String failedToInitializeGlobalRegistry$str() {
        return "ISPN000710: Failed to initialize global registry";
    }

    @Override
    public final void rejectOutdatedView(int viewId, String newView) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.rejectOutdatedView$str(), (Object)viewId, (Object)newView);
    }

    protected String rejectOutdatedView$str() {
        return "ISPN000711: View event rejected. The installed view id '%s' is newer than the received view: %s";
    }

    protected String storeTimeoutBetweenEntries$str() {
        return "ISPN000712: Time between entries/keys retrieved from store exceeded %s ms. Enable TRACE for org.infinispan.PERSISTENCE to track callers of this";
    }

    @Override
    public final TimeoutException storeTimeoutBetweenEntries(long ms) {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.storeTimeoutBetweenEntries$str(), ms));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void warnFallbackToNoOpMetrics(String clazz) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnFallbackToNoOpMetrics$str(), (Object)clazz);
    }

    protected String warnFallbackToNoOpMetrics$str() {
        return "ISPN000714: Fallback to %s as required dependencies are not available";
    }
}

