/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Optional;
import java.util.UUID;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.ch.impl.ConsistentHashFactory;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1039)
public class CacheJoinInfo {
    private final ConsistentHashFactory<?> consistentHashFactory;
    private final int numSegments;
    private final int numOwners;
    private final long timeout;
    private final CacheMode cacheMode;
    private final float capacityFactor;
    private final UUID persistentUUID;
    private final Optional<Integer> persistentStateChecksum;

    public CacheJoinInfo(ConsistentHashFactory consistentHashFactory, int numSegments, int numOwners, long timeout, CacheMode cacheMode, float capacityFactor, UUID persistentUUID, Optional<Integer> persistentStateChecksum) {
        this.consistentHashFactory = consistentHashFactory;
        this.numSegments = numSegments;
        this.numOwners = numOwners;
        this.timeout = timeout;
        this.cacheMode = cacheMode;
        this.capacityFactor = capacityFactor;
        this.persistentUUID = persistentUUID;
        this.persistentStateChecksum = persistentStateChecksum;
    }

    @ProtoFactory
    CacheJoinInfo(MarshallableObject<ConsistentHashFactory<?>> wrappedConsistentHashFactory, int numSegments, int numOwners, long timeout, CacheMode cacheMode, float capacityFactor, UUID persistentUUID, Integer persistentStateChecksum) {
        this(MarshallableObject.unwrap(wrappedConsistentHashFactory), numSegments, numOwners, timeout, cacheMode, capacityFactor, persistentUUID, Optional.ofNullable(persistentStateChecksum));
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.consistentHashFactory;
    }

    @ProtoField(value=1)
    MarshallableObject<ConsistentHashFactory<?>> getWrappedConsistentHashFactory() {
        return MarshallableObject.create(this.consistentHashFactory);
    }

    @ProtoField(value=2)
    public int getNumSegments() {
        return this.numSegments;
    }

    @ProtoField(value=3)
    public int getNumOwners() {
        return this.numOwners;
    }

    @ProtoField(value=4)
    public long getTimeout() {
        return this.timeout;
    }

    @ProtoField(value=6)
    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @ProtoField(value=7)
    public float getCapacityFactor() {
        return this.capacityFactor;
    }

    @ProtoField(value=8)
    public UUID getPersistentUUID() {
        return this.persistentUUID;
    }

    @ProtoField(value=9)
    public Optional<Integer> getPersistentStateChecksum() {
        return this.persistentStateChecksum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.capacityFactor);
        result = 31 * result + (this.consistentHashFactory == null ? 0 : this.consistentHashFactory.hashCode());
        result = 31 * result + this.cacheMode.hashCode();
        result = 31 * result + this.numOwners;
        result = 31 * result + this.numSegments;
        result = 31 * result + Long.hashCode(this.timeout);
        result = 31 * result + (this.persistentUUID == null ? 0 : this.persistentUUID.hashCode());
        result = 31 * result + (this.persistentStateChecksum == null ? 0 : this.persistentStateChecksum.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheJoinInfo other = (CacheJoinInfo)obj;
        if (Float.floatToIntBits(this.capacityFactor) != Float.floatToIntBits(other.capacityFactor)) {
            return false;
        }
        if (this.consistentHashFactory == null ? other.consistentHashFactory != null : !this.consistentHashFactory.equals(other.consistentHashFactory)) {
            return false;
        }
        if (this.cacheMode != other.cacheMode) {
            return false;
        }
        if (this.numOwners != other.numOwners) {
            return false;
        }
        if (this.numSegments != other.numSegments) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        if (this.persistentUUID == null ? other.persistentUUID != null : !this.persistentUUID.equals(other.persistentUUID)) {
            return false;
        }
        if (this.persistentStateChecksum == null) {
            return other.persistentStateChecksum == null;
        }
        return this.persistentStateChecksum.equals(other.persistentStateChecksum);
    }

    public String toString() {
        return "CacheJoinInfo{consistentHashFactory=" + String.valueOf(this.consistentHashFactory) + ", numSegments=" + this.numSegments + ", numOwners=" + this.numOwners + ", timeout=" + this.timeout + ", cacheMode=" + String.valueOf((Object)this.cacheMode) + ", persistentUUID=" + String.valueOf(this.persistentUUID) + ", persistentStateChecksum=" + String.valueOf(this.persistentStateChecksum) + ", capacityFactor=" + this.getCapacityFactor() + "}";
    }
}

