/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import org.infinispan.metrics.impl.NameUtils;

@Deprecated(forRemoval=true, since="16.0")
class BaseMemoryPoolAdditionalMetrics
implements MeterBinder {
    private static final String PREFIX = "vendor.";

    BaseMemoryPoolAdditionalMetrics() {
    }

    public void bindTo(MeterRegistry registry) {
        List<BufferPoolMXBean> bufferPoolBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean bufferPoolBean : bufferPoolBeans) {
            String name = bufferPoolBean.getName();
            String metricName = BaseMemoryPoolAdditionalMetrics.normalizeMetricName(name);
            Gauge.builder((String)("vendor.BufferPool.used.memory." + metricName), (Object)bufferPoolBean, BufferPoolMXBean::getMemoryUsed).baseUnit("bytes").description("The memory used by the NIO pool:" + name).register(registry);
        }
        List<MemoryPoolMXBean> memoryPoolBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolBean : memoryPoolBeans) {
            String name = memoryPoolBean.getName();
            String metricName = BaseMemoryPoolAdditionalMetrics.normalizeMetricName(name);
            Gauge.builder((String)("vendor.memoryPool." + metricName + ".usage"), (Object)memoryPoolBean, mem -> mem.getUsage().getUsed()).baseUnit("bytes").description("Current usage of the " + name + " memory pool").register(registry);
            Gauge.builder((String)("vendor.memoryPool." + metricName + ".usage.max"), (Object)memoryPoolBean, mem -> mem.getPeakUsage().getUsed()).baseUnit("bytes").description("Peak usage of the " + name + " memory pool").register(registry);
        }
    }

    private static String normalizeMetricName(String name) {
        return NameUtils.filterIllegalChars(name).replaceAll("^_", "").replaceAll("_$", "");
    }
}

