/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.MultiTargetRequest;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.RequestTracker;

public class StaggeredRequest<T>
extends MultiTargetRequest<T> {
    private final ReplicableCommand command;
    private final DeliverOrder deliverOrder;
    private final JGroupsTransport transport;
    private final long deadline;
    private int targetIndex;

    StaggeredRequest(ResponseCollector<Address, T> responseCollector, long requestId, RequestRepository repository, Collection<Address> targets, Address excludedTarget, ReplicableCommand command, DeliverOrder deliverOrder, long timeout, TimeUnit unit, JGroupsTransport transport) {
        super(responseCollector, requestId, repository, targets, excludedTarget, transport.metricsManager);
        this.command = command;
        this.deliverOrder = deliverOrder;
        this.transport = transport;
        this.deadline = transport.timeService.expectedEndTime(timeout, unit);
    }

    @Override
    public void setTimeout(ScheduledExecutorService timeoutExecutor, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Timeout can only be set with sendFirstMessage!");
    }

    @Override
    protected void actualOnResponse(Address sender, Response response) {
        super.actualOnResponse(sender, response);
        this.sendNextMessage();
    }

    @Override
    protected void actualOnTimeout() {
        if (this.targetIndex >= this.getTargetsSize()) {
            super.actualOnTimeout();
        } else {
            this.sendNextMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNextMessage() {
        try {
            boolean isFinalTarget;
            RequestTracker target = null;
            ResponseCollector responseCollector = this.responseCollector;
            synchronized (responseCollector) {
                if (this.isDone() || this.targetIndex >= this.getTargetsSize()) {
                    return;
                }
                while (target == null && this.targetIndex < this.getTargetsSize()) {
                    target = this.getTarget(this.targetIndex++);
                }
                if (target == null) {
                    long delayNanos = this.transport.getTimeService().remainingTime(this.deadline, TimeUnit.NANOSECONDS);
                    super.setTimeout(this.transport.getTimeoutExecutor(), delayNanos, TimeUnit.NANOSECONDS);
                    return;
                }
                isFinalTarget = this.targetIndex >= this.getTargetsSize();
            }
            target.resetSendTime();
            this.transport.sendCommandCheckingView(target.destination(), this.command, this.requestId, this.deliverOrder);
            long delayNanos = this.transport.getTimeService().remainingTime(this.deadline, TimeUnit.NANOSECONDS);
            if (!isFinalTarget) {
                delayNanos = delayNanos / 10L / (long)this.getTargetsSize();
            }
            super.setTimeout(this.transport.getTimeoutExecutor(), delayNanos, TimeUnit.NANOSECONDS);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }
}

