/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.util.Objects;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

abstract class AbstractMarshallableWrapper<T> {
    static final Log log = LogFactory.getLog(MarshallableMap.class);
    protected final T object;

    protected AbstractMarshallableWrapper(byte[] bytes) {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    protected AbstractMarshallableWrapper(T object) {
        this.object = object;
    }

    @ProtoField(value=1)
    byte[] getBytes() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    public T get() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMarshallableWrapper other = (AbstractMarshallableWrapper)o;
        return Objects.equals(this.object, other.object);
    }

    public int hashCode() {
        return this.object != null ? this.object.hashCode() : 0;
    }

    public static int size(int objectBytes) {
        int typeId = 2;
        int typeIdSize = AbstractMarshallableWrapper.tagSize(19, 1) + AbstractMarshallableWrapper.computeUInt32SizeNoTag(typeId);
        int userBytesFieldSize = AbstractMarshallableWrapper.tagSize(1, 2) + AbstractMarshallableWrapper.computeUInt32SizeNoTag(objectBytes) + objectBytes;
        int wrappedMessageSize = AbstractMarshallableWrapper.tagSize(17, 2) + AbstractMarshallableWrapper.computeUInt32SizeNoTag(objectBytes);
        return typeIdSize + userBytesFieldSize + wrappedMessageSize;
    }

    private static int tagSize(int fieldNumber, int wireType) {
        return AbstractMarshallableWrapper.computeUInt32SizeNoTag(fieldNumber << 3 | wireType);
    }

    private static int computeUInt32SizeNoTag(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        return (value & 0xF0000000) == 0 ? 4 : 5;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{object=" + Util.toStr(this.object) + "}";
    }
}

