/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.List;
import java.util.Map;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.distribution.topologyaware.TopologyInfo;
import org.infinispan.distribution.topologyaware.TopologyLevel;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=1234)
public class TopologyAwareSyncConsistentHashFactory
extends SyncConsistentHashFactory {
    private static final TopologyAwareSyncConsistentHashFactory INSTANCE = new TopologyAwareSyncConsistentHashFactory();

    protected TopologyAwareSyncConsistentHashFactory() {
    }

    @ProtoFactory
    public static TopologyAwareSyncConsistentHashFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected Builder createBuilder(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        return new Builder(numOwners, numSegments, members, capacityFactors);
    }

    protected static class Builder
    extends SyncConsistentHashFactory.Builder {
        final Map<Address, Float> capacityFactorsMap;
        protected final TopologyInfo topologyInfo;
        final int numSites;
        final int numRacks;
        final int numMachines;
        final int[] siteLookup;
        final int[] rackLookup;
        final int[] machineLookup;
        final int[][] ownerSiteIndices;
        final int[][] ownerRackIndices;
        final int[][] ownerMachineIndices;

        protected Builder(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
            super(numOwners, numSegments, members, capacityFactors);
            this.capacityFactorsMap = capacityFactors;
            this.topologyInfo = new TopologyInfo(numSegments, this.actualNumOwners, members, capacityFactors);
            this.numSites = this.topologyInfo.getDistinctLocationsCount(TopologyLevel.SITE);
            this.numRacks = this.topologyInfo.getDistinctLocationsCount(TopologyLevel.RACK);
            this.numMachines = this.topologyInfo.getDistinctLocationsCount(TopologyLevel.MACHINE);
            this.siteLookup = new int[this.numNodes];
            this.rackLookup = new int[this.numNodes];
            this.machineLookup = new int[this.numNodes];
            for (int n = 0; n < this.numNodes; ++n) {
                Address address = (Address)this.sortedMembers.get(n);
                this.siteLookup[n] = this.topologyInfo.getSiteIndex(address);
                this.rackLookup[n] = this.topologyInfo.getRackIndex(address);
                this.machineLookup[n] = this.topologyInfo.getMachineIndex(address);
            }
            this.ownerSiteIndices = new int[numSegments][];
            this.ownerRackIndices = new int[numSegments][];
            this.ownerMachineIndices = new int[numSegments][];
            for (int s = 0; s < numSegments; ++s) {
                this.ownerSiteIndices[s] = new int[this.actualNumOwners];
                this.ownerRackIndices[s] = new int[this.actualNumOwners];
                this.ownerMachineIndices[s] = new int[this.actualNumOwners];
            }
        }

        @Override
        int[] computeExpectedSegments(int expectedOwners, float totalCapacity, int iteration) {
            TopologyInfo topologyInfo = new TopologyInfo(this.numSegments, expectedOwners, this.sortedMembers, this.capacityFactorsMap);
            int[] expectedSegments = new int[this.numNodes];
            float averageSegments = (float)this.numSegments * (float)expectedOwners / (float)this.numNodes;
            for (int n = 0; n < this.numNodes; ++n) {
                float idealOwnedSegments = topologyInfo.getExpectedOwnedSegments((Address)this.sortedMembers.get(n));
                expectedSegments[n] = Builder.fudgeExpectedSegments(idealOwnedSegments, averageSegments, iteration);
            }
            return expectedSegments;
        }

        @Override
        boolean nodeCanOwnSegment(int segment, int ownerPosition, int nodeIndex) {
            if (ownerPosition == 0) {
                return true;
            }
            if (ownerPosition < this.numSites) {
                return !this.intArrayContains(this.ownerSiteIndices[segment], ownerPosition, this.siteLookup[nodeIndex]);
            }
            if (ownerPosition < this.numRacks) {
                return !this.intArrayContains(this.ownerRackIndices[segment], ownerPosition, this.rackLookup[nodeIndex]);
            }
            if (ownerPosition < this.numMachines) {
                return !this.intArrayContains(this.ownerMachineIndices[segment], ownerPosition, this.machineLookup[nodeIndex]);
            }
            return !this.intArrayContains(this.ownerIndices[segment], ownerPosition, nodeIndex);
        }

        @Override
        protected void assignOwner(int segment, int ownerPosition, int nodeIndex, int[] nodeSegmentsWanted) {
            super.assignOwner(segment, ownerPosition, nodeIndex, nodeSegmentsWanted);
            this.ownerSiteIndices[segment][ownerPosition] = this.siteLookup[nodeIndex];
            this.ownerRackIndices[segment][ownerPosition] = this.rackLookup[nodeIndex];
            this.ownerMachineIndices[segment][ownerPosition] = this.machineLookup[nodeIndex];
        }
    }
}

