/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class MemoryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<MemoryConfiguration> {
    private final AttributeSet attributes = MemoryConfiguration.attributeDefinitionSet();

    MemoryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public MemoryConfigurationBuilder storage(StorageType storageType) {
        this.attributes.attribute(MemoryConfiguration.STORAGE).set((Object)storageType);
        return this;
    }

    public MemoryConfigurationBuilder maxSize(String size) {
        this.attributes.attribute(MemoryConfiguration.MAX_SIZE).set((Object)size);
        return this;
    }

    public MemoryConfigurationBuilder maxSize(long l) {
        this.attributes.attribute(MemoryConfiguration.MAX_SIZE).set((Object)Long.toString(l));
        return this;
    }

    public String maxSize() {
        return (String)this.attributes.attribute(MemoryConfiguration.MAX_SIZE).get();
    }

    public MemoryConfigurationBuilder maxCount(long count) {
        this.attributes.attribute(MemoryConfiguration.MAX_COUNT).set((Object)count);
        return this;
    }

    public long maxCount() {
        return (Long)this.attributes.attribute(MemoryConfiguration.MAX_COUNT).get();
    }

    public StorageType storage() {
        return (StorageType)((Object)this.attributes.attribute(MemoryConfiguration.STORAGE).get());
    }

    public MemoryConfigurationBuilder whenFull(EvictionStrategy strategy) {
        this.attributes.attribute(MemoryConfiguration.WHEN_FULL).set((Object)strategy);
        return this;
    }

    public EvictionStrategy whenFull() {
        return (EvictionStrategy)((Object)this.attributes.attribute(MemoryConfiguration.WHEN_FULL).get());
    }

    boolean isSizeBounded() {
        return this.maxSize() != null;
    }

    boolean isCountBounded() {
        return this.maxCount() > 0L;
    }

    private void checkBinaryRequirement() {
        boolean storageBinary;
        if (!this.storage().canStoreReferences() && this.getBuilder().clustering().hash().groups().isEnabled()) {
            throw Log.CONFIG.groupingOnlyCompatibleWithObjectStorage(this.encoding().key().mediaType(), this.encoding().value().mediaType());
        }
        boolean bl = storageBinary = this.encoding().isStorageBinary() || !this.storage().canStoreReferences();
        if (this.isSizeBounded() && !storageBinary) {
            throw Log.CONFIG.offHeapMemoryEvictionNotSupportedWithObject();
        }
    }

    public void validate() {
        if (this.isSizeBounded() && this.isCountBounded()) {
            throw Log.CONFIG.cannotProvideBothSizeAndCount();
        }
        EvictionStrategy strategy = this.whenFull();
        if (strategy.isEnabled()) {
            TransactionConfigurationBuilder transactionConfiguration;
            TransactionMode transactionMode;
            if (!this.isCountBounded() && !this.isSizeBounded()) {
                throw Log.CONFIG.invalidEvictionSize();
            }
            if (strategy.isExceptionBased() && ((transactionMode = (transactionConfiguration = this.getBuilder().transaction()).transactionMode()) == null || !transactionMode.isTransactional() || transactionConfiguration.useSynchronization() || transactionConfiguration.use1PcForAutoCommitTransactions())) {
                throw Log.CONFIG.exceptionBasedEvictionOnlySupportedInTransactionalCaches();
            }
        } else if (this.getBuilder().persistence().passivation() && strategy != EvictionStrategy.MANUAL && !this.getBuilder().template() && !this.isSizeBounded() && !this.isCountBounded()) {
            Log.CONFIG.passivationWithoutEviction();
        }
        this.checkBinaryRequirement();
    }

    public MemoryConfiguration create() {
        Attribute whenFull = this.attributes.attribute(MemoryConfiguration.WHEN_FULL);
        if (!((EvictionStrategy)((Object)whenFull.get())).isEnabled() && (this.isSizeBounded() || this.isCountBounded())) {
            whenFull.setImplied((Object)EvictionStrategy.REMOVE);
            if (this.isCountBounded()) {
                Log.CONFIG.debugf("Max entries configured (%d) without eviction strategy. Eviction strategy overridden to %s", this.maxCount(), whenFull.get());
            } else {
                Log.CONFIG.debugf("Max size configured (%s) without eviction strategy. Eviction strategy overridden to %s", this.maxSize(), whenFull.get());
            }
        }
        return new MemoryConfiguration(this.attributes.protect());
    }

    public MemoryConfigurationBuilder read(MemoryConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "MemoryConfigurationBuilder{attributes=" + String.valueOf(this.attributes) + "}";
    }
}

