/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

@ProtoTypeId(value=1264)
public class XSiteStatePushCommand
extends BaseRpcCommand {
    private final List<XSiteState> chunk;

    @ProtoFactory
    public XSiteStatePushCommand(ByteString cacheName, List<XSiteState> chunk) {
        super(cacheName);
        this.chunk = chunk;
    }

    @ProtoField(value=2)
    public List<XSiteState> getChunk() {
        return this.chunk;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        BlockingManager bm = componentRegistry.getGlobalComponentRegistry().getComponent(BlockingManager.class);
        return bm.runBlocking(() -> {
            XSiteStateConsumer stateConsumer = componentRegistry.getXSiteStateTransferManager().running().getStateConsumer();
            stateConsumer.applyState(this.chunk);
        }, "xsite-state-push");
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "XSiteStatePushCommand{cacheName=" + String.valueOf(this.cacheName) + " (" + this.chunk.size() + " keys)}";
    }
}

