/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Objects;
import org.infinispan.commons.util.Version;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=14)
public class NodeVersion
implements Comparable<NodeVersion> {
    public static final NodeVersion SIXTEEN = new NodeVersion(16, 0, 0);
    public static final NodeVersion INSTANCE;
    final byte major;
    final byte minor;
    final byte patch;

    @ProtoFactory
    public static NodeVersion from(byte major, byte minor, byte patch) {
        if (NodeVersion.INSTANCE.major == major && NodeVersion.INSTANCE.minor == minor && NodeVersion.INSTANCE.patch == patch) {
            return INSTANCE;
        }
        return new NodeVersion(major, minor, patch);
    }

    public static NodeVersion from(String s) {
        String[] version = s.split("\\.");
        return new NodeVersion(Byte.parseByte(version[0]), Byte.parseByte(version[1]), Byte.parseByte(version[2]));
    }

    private NodeVersion(byte major, byte minor, byte patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @ProtoField(value=1, defaultValue="0")
    public byte getMajor() {
        return this.major;
    }

    @ProtoField(value=2, defaultValue="0")
    public byte getMinor() {
        return this.minor;
    }

    @ProtoField(value=3, defaultValue="0")
    public byte getPatch() {
        return this.patch;
    }

    public boolean lessThan(NodeVersion other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public int compareTo(NodeVersion o) {
        if (this.major != o.major) {
            return this.major - o.major;
        }
        if (this.minor != o.minor) {
            return this.minor - o.minor;
        }
        return this.patch - o.patch;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeVersion that = (NodeVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    static {
        byte major = Byte.parseByte(Version.getMajor());
        byte minor = Byte.parseByte(Version.getMinor());
        byte patch = Byte.parseByte(Version.getPatch());
        INSTANCE = new NodeVersion(major, minor, patch);
    }
}

