/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CachePublisher;
import org.infinispan.CacheSet;
import org.infinispan.LockedStream;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.BiFunctionMapper;
import org.infinispan.cache.impl.CacheBackedEntrySet;
import org.infinispan.cache.impl.CacheBackedKeySet;
import org.infinispan.cache.impl.CachePublisherImpl;
import org.infinispan.cache.impl.ContextBuilder;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.cache.impl.InternalCache;
import org.infinispan.cache.impl.InvocationHelper;
import org.infinispan.cache.impl.QueryProducer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.functions.MergeFunction;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.query.ContinuousQuery;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.expiration.impl.TouchCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.functional.impl.Params;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.StatsImpl;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.LockedStreamImpl;
import org.infinispan.stream.impl.TxLockedStreamImpl;
import org.infinispan.stream.impl.local.ValueCacheCollection;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
@SurvivesRestarts
@MBean(objectName="Cache", description="Component that represents an individual cache instance.")
public class CacheImpl<K, V>
implements AdvancedCache<K, V>,
InternalCache<K, V> {
    private static final Log log = LogFactory.getLog(CacheImpl.class);
    public static final String OBJECT_NAME = "Cache";
    private static final long PFER_FLAGS = EnumUtil.bitSetOf((Enum)Flag.FAIL_SILENTLY, (Enum)Flag.FORCE_ASYNCHRONOUS, (Enum[])new Enum[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.PUT_FOR_EXTERNAL_READ, Flag.IGNORE_RETURN_VALUES});
    @Inject
    protected InvocationContextFactory invocationContextFactory;
    @Inject
    protected CommandsFactory commandsFactory;
    @Inject
    protected AsyncInterceptorChain invoker;
    @Inject
    protected Configuration config;
    @Inject
    protected CacheNotifier<K, V> notifier;
    @Inject
    protected CacheManagerNotifier cacheManagerNotifier;
    @Inject
    protected BatchContainer batchContainer;
    @Inject
    protected ComponentRegistry componentRegistry;
    @Inject
    protected TransactionManager transactionManager;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    EvictionManager<K, V> evictionManager;
    @Inject
    InternalExpirationManager<K, V> expirationManager;
    @Inject
    InternalDataContainer<K, V> dataContainer;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    LockManager lockManager;
    @Inject
    DistributionManager distributionManager;
    @Inject
    TransactionTable txTable;
    @Inject
    AuthorizationManager authorizationManager;
    @Inject
    PartitionHandlingManager partitionHandlingManager;
    @Inject
    GlobalConfiguration globalCfg;
    @Inject
    LocalTopologyManager localTopologyManager;
    @Inject
    StateTransferManager stateTransferManager;
    @Inject
    InvocationHelper invocationHelper;
    @Inject
    StorageConfigurationManager storageConfigurationManager;
    @Inject
    ComponentRef<AdvancedCache> encoderCache;
    @Inject
    GroupManager groupManager;
    protected volatile Metadata defaultMetadata;
    private final String name;
    private volatile boolean stopping = false;
    private boolean transactional;
    private boolean batchingEnabled;
    private final ContextBuilder nonTxContextBuilder = this::nonTxContextBuilder;
    private final ContextBuilder defaultBuilder = i -> this.invocationHelper.createInvocationContextWithImplicitTransaction(i, false);
    private QueryProducer queryProducer;

    public CacheImpl(String name) {
        this.name = name;
    }

    @Inject
    public void preStart() {
        this.updateDefaultMetadata();
        this.config.expiration().attributes().attribute(ExpirationConfiguration.LIFESPAN).addListener((attribute, oldValue) -> this.updateDefaultMetadata());
        this.config.expiration().attributes().attribute(ExpirationConfiguration.MAX_IDLE).addListener((attribute, oldValue) -> this.updateDefaultMetadata());
        this.transactional = this.config.transaction().transactionMode().isTransactional();
        this.batchingEnabled = this.config.invocationBatching().enabled();
    }

    private void updateDefaultMetadata() {
        this.defaultMetadata = Configurations.newDefaultMetadata(this.config);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    private void assertKeyNotNull(Object key) {
        Objects.requireNonNull(key, "Null keys are not supported!");
    }

    private void assertValueNotNull(Object value) {
        Objects.requireNonNull(value, "Null values are not supported!");
    }

    void assertKeyValueNotNull(Object key, Object value) {
        this.assertKeyNotNull(key);
        this.assertValueNotNull(value);
    }

    private void assertFunctionNotNull(Object function) {
        Objects.requireNonNull(function, "Null functions are not supported!");
    }

    public final V put(K key, V value) {
        return this.put(key, value, this.defaultMetadata);
    }

    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.put(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultMetadata);
    }

    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultMetadata);
    }

    public final V replace(K key, V value) {
        return this.replace(key, value, this.defaultMetadata);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, false);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.computeInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.computeInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.computeInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, true);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).build();
        return this.computeInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L));
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.computeInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.computeInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L));
    }

    private V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent) {
        return this.computeInternal(key, remappingFunction, computeIfPresent, this.applyDefaultMetadata(this.defaultMetadata), this.addUnsafeFlags(0L));
    }

    private V computeInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent, Metadata metadata, long flags) {
        return this.computeInternal(key, remappingFunction, computeIfPresent, metadata, flags, this.defaultContextBuilderForWrite());
    }

    V computeInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertFunctionNotNull(remappingFunction);
        ComputeCommand command = this.commandsFactory.buildComputeCommand(key, remappingFunction, computeIfPresent, this.keyPartitioner.getSegment(key), metadata, flags);
        return (V)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    @Override
    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction, this.defaultMetadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).build();
        return this.computeIfAbsent(key, mappingFunction, metadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.computeIfAbsent(key, mappingFunction, metadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return this.computeIfAbsentInternal(key, mappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    V computeIfAbsentInternal(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertFunctionNotNull(mappingFunction);
        ComputeIfAbsentCommand command = this.commandsFactory.buildComputeIfAbsentCommand(key, mappingFunction, this.keyPartitioner.getSegment(key), metadata, flags);
        return (V)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mergeInternal(key, value, remappingFunction, this.defaultMetadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.mergeInternal(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.mergeInternal(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.mergeInternal(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    V mergeInternal(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        DataConversion valueDataConversion;
        DataConversion keyDataConversion;
        this.assertKeyNotNull(key);
        this.assertValueNotNull(value);
        this.assertFunctionNotNull(remappingFunction);
        if (remappingFunction instanceof BiFunctionMapper) {
            BiFunctionMapper biFunctionMapper = (BiFunctionMapper)remappingFunction;
            keyDataConversion = biFunctionMapper.getKeyDataConversion();
            valueDataConversion = biFunctionMapper.getValueDataConversion();
        } else {
            keyDataConversion = this.encoderCache.running().getKeyDataConversion();
            valueDataConversion = this.encoderCache.running().getValueDataConversion();
        }
        ReadWriteKeyCommand command = this.commandsFactory.buildReadWriteKeyCommand(key, new MergeFunction(value, remappingFunction, metadata), this.keyPartitioner.getSegment(key), Params.fromFlagsBitSet(flags), keyDataConversion, valueDataConversion);
        return (V)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    public final CompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.defaultMetadata);
    }

    public final CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.defaultMetadata);
    }

    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, TimeUnit.MILLISECONDS, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.defaultMetadata);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsentAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, this.defaultMetadata);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.defaultMetadata);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(m, this.defaultMetadata);
    }

    public final boolean remove(Object key, Object value) {
        return this.remove(key, value, 0L, this.defaultContextBuilderForWrite());
    }

    final boolean remove(Object key, Object value, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value, this.keyPartitioner.getSegment(key), explicitFlags);
        return (Boolean)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    @Override
    public final int size() {
        return this.size(0L);
    }

    final int size(long explicitFlags) {
        SizeCommand command = this.commandsFactory.buildSizeCommand(null, explicitFlags);
        long size = (Long)this.invocationHelper.invoke(this.invocationContextFactory.createInvocationContext(false, -1), command);
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public CompletableFuture<Long> sizeAsync() {
        return this.sizeAsync(0L);
    }

    final CompletableFuture<Long> sizeAsync(long explicitFlags) {
        SizeCommand command = this.commandsFactory.buildSizeCommand(null, explicitFlags);
        return this.invocationHelper.invokeAsync(this.invocationContextFactory.createInvocationContext(false, -1), command);
    }

    public final boolean isEmpty() {
        return this.isEmpty(0L);
    }

    final boolean isEmpty(long explicitFlags) {
        return this.entrySet(explicitFlags, null).stream().noneMatch(StreamMarshalling.alwaysTruePredicate());
    }

    public final boolean containsKey(Object key) {
        return this.containsKey(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    final boolean containsKey(Object key, long explicitFlags, InvocationContext ctx) {
        return this.get(key, explicitFlags, ctx) != null;
    }

    public final boolean containsValue(Object value) {
        this.assertValueNotNull(value);
        return this.values().stream().anyMatch(StreamMarshalling.equalityPredicate(value));
    }

    public final V get(Object key) {
        return this.get(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    final V get(Object key, long explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        return (V)this.invocationHelper.invoke(ctx, command);
    }

    final CacheEntry<K, V> getCacheEntry(Object key, long explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        return (CacheEntry)this.invocationHelper.invoke(ctx, command);
    }

    @Override
    public final CacheEntry<K, V> getCacheEntry(Object key) {
        return this.getCacheEntry(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        return this.getCacheEntryAsync(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    final CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key, long explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        return this.invocationHelper.invokeAsync(ctx, command);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.getAll(keys, 0L, this.invocationContextFactory.createInvocationContext(false, keys.size()));
    }

    final Map<K, V> getAll(Set<?> keys, long explicitFlags, InvocationContext ctx) {
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, false);
        return this.dropNullEntries((Map)this.invocationHelper.invoke(ctx, command));
    }

    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return this.getAllAsync(keys, 0L, this.invocationContextFactory.createInvocationContext(false, keys.size()));
    }

    final CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys, long explicitFlags, InvocationContext ctx) {
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, false);
        return this.invocationHelper.invokeAsync(ctx, command).thenApply(this::dropNullEntries);
    }

    private Map<K, V> dropNullEntries(Map<K, V> map) {
        Iterator<Map.Entry<K, V>> entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<K, V> entry = entryIterator.next();
            if (entry.getValue() != null) continue;
            entryIterator.remove();
        }
        return map;
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return this.getAllCacheEntries(keys, 0L, this.invocationContextFactory.createInvocationContext(false, keys.size()));
    }

    public final Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys, long explicitFlags, InvocationContext ctx) {
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, true);
        Map map = (Map)this.invocationHelper.invoke(ctx, command);
        map.entrySet().removeIf(entry -> entry.getValue() == null);
        return map;
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.getGroup(groupName, 0L);
    }

    final Map<K, V> getGroup(String groupName, long explicitFlags) {
        return Collections.unmodifiableMap(this.internalGetGroup(groupName, explicitFlags, this.invocationContextFactory.createInvocationContext(false, -1)));
    }

    private Map<K, V> internalGetGroup(String groupName, long explicitFlagsBitSet, InvocationContext ctx) {
        if (this.groupManager == null) {
            return Collections.emptyMap();
        }
        try (Stream stream = this.cacheEntrySet(explicitFlagsBitSet, null).stream();){
            Map map = this.groupManager.collect(stream, ctx, groupName);
            return map;
        }
    }

    @Override
    public void removeGroup(String groupName) {
        this.removeGroup(groupName, 0L);
    }

    final void removeGroup(String groupName, long explicitFlags) {
        if (!this.transactional) {
            this.nonTransactionalRemoveGroup(groupName, explicitFlags);
        } else {
            this.transactionalRemoveGroup(groupName, explicitFlags);
        }
    }

    private void transactionalRemoveGroup(String groupName, long explicitFlagsBitSet) {
        boolean onGoingTransaction;
        boolean bl = onGoingTransaction = this.getOngoingTransaction(true) != null;
        if (!onGoingTransaction) {
            this.tryBegin();
        }
        try {
            InvocationContext context = this.defaultContextBuilderForWrite().create(-1);
            Map<K, V> keys = this.internalGetGroup(groupName, explicitFlagsBitSet, context);
            long removeFlags = this.addIgnoreReturnValuesFlag(explicitFlagsBitSet);
            for (K key : keys.keySet()) {
                this.invocationHelper.invoke(context, this.createRemoveCommand(key, removeFlags, false));
            }
            if (!onGoingTransaction) {
                this.tryCommit();
            }
        }
        catch (RuntimeException e) {
            if (!onGoingTransaction) {
                this.tryRollback();
            }
            throw e;
        }
    }

    private void nonTransactionalRemoveGroup(String groupName, long explicitFlags) {
        InvocationContext context = this.invocationContextFactory.createInvocationContext(false, -1);
        Map<K, V> keys = this.internalGetGroup(groupName, explicitFlags, context);
        long removeFlags = this.addIgnoreReturnValuesFlag(explicitFlags);
        for (K key : keys.keySet()) {
            this.assertKeyNotNull(key);
            this.invocationHelper.invoke(this.createRemoveCommand(key, removeFlags, false), 1);
        }
    }

    public final V remove(Object key) {
        return this.remove(key, 0L, this.defaultContextBuilderForWrite());
    }

    public <T> Query<T> query(String query) {
        if (this.queryProducer == null) {
            throw log.queryNotSupported();
        }
        return this.queryProducer.query(query);
    }

    public ContinuousQuery<K, V> continuousQuery() {
        if (this.queryProducer == null) {
            throw log.queryNotSupported();
        }
        return this.queryProducer.continuousQuery(this);
    }

    final V remove(Object key, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        RemoveCommand command = this.createRemoveCommand(key, explicitFlags, false);
        return (V)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    private RemoveCommand createRemoveCommand(Object key, long explicitFlags, boolean returnEntry) {
        long flags = this.addUnsafeFlags(explicitFlags);
        return this.commandsFactory.buildRemoveCommand(key, null, this.keyPartitioner.getSegment(key), flags, returnEntry);
    }

    @Override
    public CompletableFuture<Boolean> removeLifespanExpired(K key, V value, Long lifespan) {
        return this.removeLifespanExpired(key, value, lifespan, 0L);
    }

    final CompletableFuture<Boolean> removeLifespanExpired(K key, V value, Long lifespan, long explicitFlags) {
        RemoveExpiredCommand command = this.commandsFactory.buildRemoveExpiredCommand(key, value, this.keyPartitioner.getSegment(key), lifespan, explicitFlags | FlagBitSets.SKIP_CACHE_LOAD | FlagBitSets.SKIP_XSITE_BACKUP);
        return this.performVisitableNonTxCommand(command);
    }

    @Override
    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        return this.removeMaxIdleExpired(key, value, 0L);
    }

    final CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value, long explicitFlags) {
        RemoveExpiredCommand command = this.commandsFactory.buildRemoveExpiredCommand(key, value, this.keyPartitioner.getSegment(key), explicitFlags | FlagBitSets.SKIP_CACHE_LOAD);
        return this.performVisitableNonTxCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> performVisitableNonTxCommand(VisitableCommand command) {
        Transaction ongoingTransaction = null;
        try {
            ongoingTransaction = this.suspendOngoingTransactionIfExists();
            CompletableFuture<Boolean> completableFuture = this.invocationHelper.invokeAsync(this.nonTxContextBuilder, command, 1);
            return completableFuture;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception while doing removeExpired()", e);
            }
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            this.resumePreviousOngoingTransaction(ongoingTransaction, "Had problems trying to resume a transaction after removeExpired()");
        }
    }

    @Override
    public <K1, V1> AdvancedCache<K1, V1> withMediaType(MediaType keyMediaType, MediaType valueMediaType) {
        throw new UnsupportedOperationException("Conversion requires EncoderCache");
    }

    @Override
    public AdvancedCache<K, V> withStorageMediaType() {
        throw new UnsupportedOperationException("Conversion requires EncoderCache");
    }

    @Override
    public DataConversion getKeyDataConversion() {
        throw new UnsupportedOperationException("Conversion requires EncoderCache");
    }

    @Override
    public DataConversion getValueDataConversion() {
        throw new UnsupportedOperationException("Conversion requires EncoderCache");
    }

    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public final void clearOperation() {
        this.clear(0L);
    }

    @Override
    public final void clear() {
        this.clear(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clear(long explicitFlags) {
        Transaction tx = this.suspendOngoingTransactionIfExists();
        try {
            InvocationContext context = this.invocationContextFactory.createClearNonTxInvocationContext();
            ClearCommand command = this.commandsFactory.buildClearCommand(explicitFlags);
            this.invocationHelper.invoke(context, command);
        }
        finally {
            this.resumePreviousOngoingTransaction(tx, "Had problems trying to resume a transaction after clear()");
        }
    }

    @Override
    public CacheSet<K> keySet() {
        return this.keySet(0L, null);
    }

    CacheSet<K> keySet(long explicitFlags, Object lockOwner) {
        return new CacheBackedKeySet(this, lockOwner, explicitFlags);
    }

    @Override
    public CacheCollection<V> values() {
        return this.values(0L, null);
    }

    CacheCollection<V> values(long explicitFlags, Object lockOwner) {
        return new ValueCacheCollection<K, V>(this, this.cacheEntrySet(explicitFlags, lockOwner));
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cacheEntrySet(0L, null);
    }

    @Override
    public LockedStream<K, V> lockedStream() {
        if (this.transactional) {
            if (this.config.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                throw new UnsupportedOperationException("Method lockedStream is not supported in OPTIMISTIC transactional caches!");
            }
            return new TxLockedStreamImpl(this.transactionManager, this.cacheEntrySet().stream(), this.config.locking().lockAcquisitionTimeout(), TimeUnit.MILLISECONDS);
        }
        return new LockedStreamImpl(this.cacheEntrySet().stream(), this.config.locking().lockAcquisitionTimeout(), TimeUnit.MILLISECONDS);
    }

    CacheSet<CacheEntry<K, V>> cacheEntrySet(long explicitFlags, Object lockOwner) {
        return new CacheBackedEntrySet(this, lockOwner, explicitFlags);
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.entrySet(0L, null);
    }

    CacheSet<Map.Entry<K, V>> entrySet(long explicitFlags, Object lockOwner) {
        return new CacheBackedEntrySet(this, lockOwner, explicitFlags);
    }

    @Override
    public final void putForExternalRead(K key, V value) {
        this.putForExternalRead(key, value, 0L);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        this.putForExternalRead(key, value, lifespan, lifespanUnit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        this.putForExternalRead(key, value, metadata);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        this.putForExternalRead(key, value, merged, 0L);
    }

    final void putForExternalRead(K key, V value, long explicitFlags) {
        this.putForExternalRead(key, value, this.defaultMetadata, explicitFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void putForExternalRead(K key, V value, Metadata metadata, long explicitFlags) {
        Transaction ongoingTransaction = null;
        try {
            ongoingTransaction = this.suspendOngoingTransactionIfExists();
            this.putIfAbsent(key, value, metadata, EnumUtil.mergeBitSets((long)PFER_FLAGS, (long)explicitFlags), this.nonTxContextBuilder);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception while doing putForExternalRead()", e);
            }
        }
        finally {
            this.resumePreviousOngoingTransaction(ongoingTransaction, "Had problems trying to resume a transaction after putForExternalRead()");
        }
    }

    @Override
    public final void evict(K key) {
        this.evict(key, 0L);
    }

    final void evict(K key, long explicitFlags) {
        this.assertKeyNotNull(key);
        if (!this.config.memory().isEvictionEnabled() && this.config.memory().whenFull() != EvictionStrategy.MANUAL) {
            log.evictionDisabled(this.name);
        }
        InvocationContext ctx = this.createSingleKeyNonTxInvocationContext();
        EvictCommand command = this.commandsFactory.buildEvictCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        this.invocationHelper.invoke(ctx, command);
    }

    private InvocationContext createSingleKeyNonTxInvocationContext() {
        return this.invocationContextFactory.createSingleKeyNonTxInvocationContext();
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.config;
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        return this.notifier.addListenerAsync(listener);
    }

    CompletionStage<Void> addListenerAsync(ListenerHolder listenerHolder) {
        return this.notifier.addListenerAsync(listenerHolder, null, null, null);
    }

    <C> CompletionStage<Void> addListenerAsync(ListenerHolder listenerHolder, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        return this.notifier.addListenerAsync(listenerHolder, filter, converter, null);
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        return this.notifier.addListenerAsync(listener, filter, converter);
    }

    @Override
    public CompletionStage<Void> removeListenerAsync(Object listener) {
        return this.notifier.removeListenerAsync(listener);
    }

    @Override
    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.notifier.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.notifier.addStorageFormatFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    <C> CompletionStage<Void> addFilteredListenerAsync(ListenerHolder listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.notifier.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    private InvocationContext nonTxContextBuilder(int keyCount) {
        return this.transactional ? this.invocationContextFactory.createSingleKeyNonTxInvocationContext() : this.invocationContextFactory.createInvocationContext(true, keyCount);
    }

    @Override
    public boolean lock(K ... keys) {
        this.assertKeyNotNull(keys);
        return this.lock((Collection<? extends K>)Arrays.asList(keys), 0L);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.lock(keys, 0L);
    }

    boolean lock(Collection<? extends K> keys, long flagsBitSet) {
        if (!this.transactional) {
            throw new UnsupportedOperationException("Calling lock() on non-transactional caches is not allowed");
        }
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        keys = List.copyOf(keys);
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext(true, -1);
        LockControlCommand command = this.commandsFactory.buildLockControlCommand(keys, flagsBitSet);
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(command.getKeyLockOwner());
        }
        return (Boolean)this.invocationHelper.invoke(ctx, command);
    }

    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.componentRegistry.start();
        this.componentRegistry.postStart();
        this.queryProducer = this.componentRegistry.getComponent(QueryProducer.class);
        if (this.stateTransferManager != null) {
            try {
                this.stateTransferManager.waitForInitialStateTransferToComplete();
            }
            catch (Throwable t) {
                log.debugf("Stopping cache as exception encountered waiting for state transfer", t);
                this.componentRegistry.stop();
                throw t;
            }
        }
        this.componentRegistry.blameInitialization();
        log.debugf("Started cache %s on %s", this.getName(), this.managerIdentifier());
    }

    @Override
    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        this.performImmediateShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Shuts down the cache across the cluster", displayName="Clustered cache shutdown")
    public void shutdown() {
        log.debugf("Shutting down cache %s on %s", this.getName(), this.managerIdentifier());
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            if (!this.stopping && this.componentRegistry.getStatus() == ComponentStatus.RUNNING) {
                this.stopping = true;
                this.requestClusterWideShutdown();
            }
        }
    }

    private void requestClusterWideShutdown() {
        if (this.config.clustering().cacheMode().isClustered()) {
            try {
                this.localTopologyManager.cacheShutdown(this.name);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.performImmediateShutdown();
    }

    private void performImmediateShutdown() {
        log.debugf("Stopping cache %s on %s", this.getName(), this.managerIdentifier());
        this.componentRegistry.stop();
    }

    @Override
    public ExpirationManager<K, V> getExpirationManager() {
        return this.expirationManager;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.distributionManager;
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    @Override
    public AdvancedCache<K, V> lockAs(Object lockOwner) {
        return new DecoratedCache(this, Objects.requireNonNull(lockOwner, "lockOwner can't be null"), 0L);
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    @Override
    public AvailabilityMode getAvailability() {
        return this.partitionHandlingManager.getAvailabilityMode();
    }

    @Override
    public void setAvailability(AvailabilityMode availability) {
        if (this.localTopologyManager != null) {
            try {
                this.localTopologyManager.setCacheAvailability(this.getName(), availability);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @ManagedAttribute(description="Returns the cache availability", displayName="Cache availability", dataType=DataType.TRAIT, writable=true)
    public String getCacheAvailability() {
        return this.getAvailability().toString();
    }

    @ManagedAttribute(description="Returns whether cache rebalancing is enabled", displayName="Cache rebalacing", dataType=DataType.TRAIT, writable=true)
    public boolean isRebalancingEnabled() {
        if (this.localTopologyManager != null) {
            try {
                return this.localTopologyManager.isCacheRebalancingEnabled(this.getName());
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        return false;
    }

    public void setRebalancingEnabled(boolean enabled) {
        if (this.localTopologyManager != null) {
            try {
                this.localTopologyManager.setCacheRebalancingEnabled(this.getName(), enabled);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    public boolean startBatch() {
        if (!this.batchingEnabled) {
            throw Log.CONFIG.invocationBatchingNotEnabled();
        }
        return this.batchContainer.startBatch();
    }

    public void endBatch(boolean successful) {
        if (!this.batchingEnabled) {
            throw Log.CONFIG.invocationBatchingNotEnabled();
        }
        this.batchContainer.endBatch(successful);
    }

    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT)
    public String getCacheName() {
        return this.getName() + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT)
    public String getVersion() {
        return Version.getVersion();
    }

    public String toString() {
        return "Cache '" + this.name + "'@" + this.managerIdentifier();
    }

    private String managerIdentifier() {
        if (this.rpcManager != null) {
            return this.rpcManager.getAddress().toString();
        }
        if (this.globalCfg.transport().nodeName() != null) {
            return this.globalCfg.transport().nodeName();
        }
        return this.globalCfg.cacheManagerName();
    }

    @Override
    public CompletionStage<Boolean> touch(Object key, boolean touchEvenIfExpired) {
        return this.touch(key, -1, touchEvenIfExpired, 0L);
    }

    @Override
    public CompletionStage<Boolean> touch(Object key, int segment, boolean touchEvenIfExpired) {
        return this.touch(key, segment, touchEvenIfExpired, 0L);
    }

    public CompletionStage<Boolean> touch(Object key, int segment, boolean touchEvenIfExpired, long flagBitSet) {
        if (segment < 0) {
            segment = this.keyPartitioner.getSegment(key);
        }
        TouchCommand command = this.commandsFactory.buildTouchCommand(key, segment, touchEvenIfExpired, flagBitSet);
        return this.performVisitableNonTxCommand(command);
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.batchContainer;
    }

    @Override
    public DataContainer<K, V> getDataContainer() {
        return this.dataContainer;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Stats getStats() {
        return StatsImpl.create(this.config, this.invoker);
    }

    @Override
    public XAResource getXAResource() {
        return new TransactionXaAdapter((XaTransactionTable)this.txTable);
    }

    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.put(key, value, metadata);
    }

    final V put(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.createPutCommand(key, value, metadata, explicitFlags, false);
        return (V)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    private PutKeyValueCommand createPutCommand(K key, V value, Metadata metadata, long explicitFlags, boolean returnEntry) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.commandsFactory.buildPutKeyValueCommand(key, value, this.keyPartitioner.getSegment(key), merged, flags, returnEntry);
    }

    private long addIgnoreReturnValuesFlag(long flagBitSet) {
        return EnumUtil.mergeBitSets((long)flagBitSet, (long)FlagBitSets.IGNORE_RETURN_VALUES);
    }

    private long addUnsafeFlags(long flagBitSet) {
        return this.config.unsafe().unreliableReturnValues() ? this.addIgnoreReturnValuesFlag(flagBitSet) : flagBitSet;
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.putIfAbsent(key, value, metadata, 0L);
    }

    private V putIfAbsent(K key, V value, Metadata metadata, long explicitFlags) {
        return this.putIfAbsent(key, value, metadata, explicitFlags, this.defaultContextBuilderForWrite());
    }

    final V putIfAbsent(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.createPutIfAbsentCommand(key, value, metadata, explicitFlags, false);
        return (V)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    private PutKeyValueCommand createPutIfAbsentCommand(K key, V value, Metadata metadata, long explicitFlags, boolean returnEntry) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, this.keyPartitioner.getSegment(key), merged, flags, returnEntry);
        command.setPutIfAbsent(true);
        command.setValueMatcher(ValueMatcher.MATCH_EXPECTED);
        return command;
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        this.putAll(map, metadata);
    }

    final void putAll(Map<? extends K, ? extends V> map, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        explicitFlags = EnumUtil.mergeBitSets((long)explicitFlags, (long)FlagBitSets.IGNORE_RETURN_VALUES);
        PutMapCommand command = this.createPutAllCommand(map, metadata, explicitFlags);
        this.invocationHelper.invoke(contextBuilder, command, map.size());
    }

    @Override
    public final Map<K, V> getAndPutAll(Map<? extends K, ? extends V> map) {
        return this.getAndPutAll(map, this.defaultMetadata, 0L, this.defaultContextBuilderForWrite());
    }

    final Map<K, V> getAndPutAll(Map<? extends K, ? extends V> map, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        PutMapCommand command = this.createPutAllCommand(map, metadata, explicitFlags);
        return this.dropNullEntries((Map)this.invocationHelper.invoke(contextBuilder, command, map.size()));
    }

    private PutMapCommand createPutAllCommand(Map<? extends K, ? extends V> map, Metadata metadata, long explicitFlags) {
        InfinispanCollections.assertNotNullEntries(map, (String)"map");
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.commandsFactory.buildPutMapCommand(map, merged, explicitFlags);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.replace(key, value, metadata);
    }

    final V replace(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        ReplaceCommand command = this.createReplaceCommand(key, value, metadata, explicitFlags, false);
        return (V)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    private ReplaceCommand createReplaceCommand(K key, V value, Metadata metadata, long explicitFlags, boolean returnEntry) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.commandsFactory.buildReplaceCommand(key, null, value, this.keyPartitioner.getSegment(key), merged, flags, returnEntry);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.replace(key, oldValue, value, metadata);
    }

    final boolean replace(K key, V oldValue, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        this.assertValueNotNull(oldValue);
        ReplaceCommand command = this.createReplaceConditionalCommand(key, oldValue, value, metadata, explicitFlags);
        return (Boolean)this.invocationHelper.invoke(contextBuilder, command, 1);
    }

    private ReplaceCommand createReplaceConditionalCommand(K key, V oldValue, V value, Metadata metadata, long explicitFlags) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.commandsFactory.buildReplaceCommand(key, oldValue, value, this.keyPartitioner.getSegment(key), merged, explicitFlags);
    }

    public final CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAsync(key, value, metadata);
    }

    final CompletableFuture<V> putAsync(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.createPutCommand(key, value, metadata, explicitFlags, false);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    final CompletableFuture<CacheEntry<K, V>> putAsyncEntry(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.createPutCommand(key, value, metadata, explicitFlags, true);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAllAsync(data, metadata);
    }

    @Override
    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, Metadata metadata) {
        return this.putAllAsync(data, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        explicitFlags = EnumUtil.mergeBitSets((long)explicitFlags, (long)FlagBitSets.IGNORE_RETURN_VALUES);
        PutMapCommand command = this.createPutAllCommand(data, metadata, explicitFlags);
        return this.invocationHelper.invokeAsync(contextBuilder, command, data.size());
    }

    public final CompletableFuture<Void> clearAsync() {
        return this.clearAsync(0L);
    }

    final CompletableFuture<Void> clearAsync(long explicitFlags) {
        InvocationContext context = this.invocationContextFactory.createClearNonTxInvocationContext();
        ClearCommand command = this.commandsFactory.buildClearCommand(explicitFlags);
        return this.invocationHelper.invokeAsync(context, command).thenApply(nil -> null);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putIfAbsentAsync(key, value, metadata);
    }

    @Override
    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        return this.putIfAbsentAsync(key, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.createPutIfAbsentCommand(key, value, metadata, explicitFlags, false);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> putIfAbsentAsyncEntry(K key, V value, Metadata metadata) {
        return this.putIfAbsentAsyncEntry(key, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<CacheEntry<K, V>> putIfAbsentAsyncEntry(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.createPutIfAbsentCommand(key, value, metadata, explicitFlags, true);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<V> removeAsync(Object key) {
        return this.removeAsync(key, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<V> removeAsync(Object key, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        RemoveCommand command = this.createRemoveCommand(key, explicitFlags, false);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> removeAsyncEntry(Object key) {
        return this.removeAsyncEntry(key, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<CacheEntry<K, V>> removeAsyncEntry(Object key, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        RemoveCommand command = this.createRemoveCommand(key, explicitFlags, true);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.removeAsync(key, value, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<Boolean> removeAsync(Object key, Object value, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value, this.keyPartitioner.getSegment(key), explicitFlags);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, value, metadata);
    }

    @Override
    public final CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        return this.replaceAsync(key, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        ReplaceCommand command = this.createReplaceCommand(key, value, metadata, explicitFlags, false);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> replaceAsyncEntry(K key, V value, Metadata metadata) {
        return this.replaceAsyncEntry(key, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<CacheEntry<K, V>> replaceAsyncEntry(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        ReplaceCommand command = this.createReplaceCommand(key, value, metadata, explicitFlags, true);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, oldValue, newValue, metadata);
    }

    @Override
    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return this.replaceAsync(key, oldValue, newValue, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, newValue);
        this.assertValueNotNull(oldValue);
        ReplaceCommand command = this.createReplaceConditionalCommand(key, oldValue, newValue, metadata, explicitFlags);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    public CompletableFuture<V> getAsync(K key) {
        return this.getAsync(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    CompletableFuture<V> getAsync(K key, long explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        return this.invocationHelper.invokeAsync(ctx, command);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsync(key, remappingFunction, false);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.computeAsyncInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L));
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.computeAsyncInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeAsyncInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsync(key, remappingFunction, true);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.computeAsyncInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L));
    }

    private CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent) {
        return this.computeAsyncInternal(key, remappingFunction, computeIfPresent, this.applyDefaultMetadata(this.defaultMetadata), this.addUnsafeFlags(0L));
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.computeAsyncInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeAsyncInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    private CompletableFuture<V> computeAsyncInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent, Metadata metadata, long flags) {
        return this.computeAsyncInternal(key, remappingFunction, computeIfPresent, metadata, flags, this.defaultContextBuilderForWrite());
    }

    CompletableFuture<V> computeAsyncInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertFunctionNotNull(remappingFunction);
        ComputeCommand command = this.commandsFactory.buildComputeCommand(key, remappingFunction, computeIfPresent, this.keyPartitioner.getSegment(key), metadata, flags);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentAsync(key, mappingFunction, this.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return this.computeIfAbsentAsyncInternal(key, mappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.computeIfAbsentAsyncInternal(key, mappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeIfAbsentAsyncInternal(key, mappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    CompletableFuture<V> computeIfAbsentAsyncInternal(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertFunctionNotNull(mappingFunction);
        ComputeIfAbsentCommand command = this.commandsFactory.buildComputeIfAbsentCommand(key, mappingFunction, this.keyPartitioner.getSegment(key), metadata, flags);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mergeInternalAsync(key, value, remappingFunction, this.defaultMetadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.mergeInternalAsync(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.mergeInternalAsync(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.mergeInternalAsync(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.defaultContextBuilderForWrite());
    }

    CompletableFuture<V> mergeInternalAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        DataConversion valueDataConversion;
        DataConversion keyDataConversion;
        this.assertKeyNotNull(key);
        this.assertValueNotNull(value);
        this.assertFunctionNotNull(remappingFunction);
        if (remappingFunction instanceof BiFunctionMapper) {
            BiFunctionMapper biFunctionMapper = (BiFunctionMapper)remappingFunction;
            keyDataConversion = biFunctionMapper.getKeyDataConversion();
            valueDataConversion = biFunctionMapper.getValueDataConversion();
        } else {
            keyDataConversion = this.encoderCache.running().getKeyDataConversion();
            valueDataConversion = this.encoderCache.running().getValueDataConversion();
        }
        ReadWriteKeyCommand command = this.commandsFactory.buildReadWriteKeyCommand(key, new MergeFunction(value, remappingFunction, metadata), this.keyPartitioner.getSegment(key), Params.fromFlagsBitSet(flags), keyDataConversion, valueDataConversion);
        return this.invocationHelper.invokeAsync(contextBuilder, command, 1);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag flag) {
        return new DecoratedCache(this, EnumUtil.bitSetOf((Enum)flag));
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return this;
        }
        return new DecoratedCache(this, EnumUtil.bitSetOf((Enum[])flags));
    }

    @Override
    public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this;
        }
        return new DecoratedCache(this, EnumUtil.bitSetOf(flags));
    }

    @Override
    public AdvancedCache<K, V> noFlags() {
        return this;
    }

    @Override
    public AdvancedCache<K, V> transform(Function<AdvancedCache<K, V>, ? extends AdvancedCache<K, V>> transformation) {
        return transformation.apply(this);
    }

    @Override
    public AdvancedCache<K, V> withSubject(Subject subject) {
        return this;
    }

    private Transaction getOngoingTransaction(boolean includeBatchTx) {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null) {
                transaction = this.transactionManager.getTransaction();
                if (includeBatchTx && transaction == null && this.batchingEnabled) {
                    transaction = this.batchContainer.getBatchTransaction();
                }
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", (Throwable)e);
        }
    }

    private void tryBegin() {
        if (this.transactionManager == null) {
            return;
        }
        try {
            this.transactionManager.begin();
            Transaction transaction = this.getOngoingTransaction(true);
            if (log.isTraceEnabled()) {
                log.tracef("Implicit transaction started! Transaction: %s", transaction);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException("Unable to begin implicit transaction.", (Throwable)e);
        }
    }

    private void tryRollback() {
        block3: {
            try {
                if (this.transactionManager != null) {
                    this.transactionManager.rollback();
                }
            }
            catch (Throwable t) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Could not rollback", t);
            }
        }
    }

    private void tryCommit() {
        if (this.transactionManager == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Committing transaction as it was implicit: %s", this.getOngoingTransaction(true));
        }
        try {
            this.transactionManager.commit();
        }
        catch (Throwable e) {
            log.couldNotCompleteInjectedTransaction(e);
            throw new CacheException("Could not commit implicit transaction", e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.globalCfg.classLoader();
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.put(key, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.putAll(map, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    private Metadata applyDefaultMetadata(Metadata metadata) {
        if (metadata == null) {
            return this.defaultMetadata;
        }
        Metadata.Builder builder = metadata.builder();
        return builder != null ? builder.merge(this.defaultMetadata).build() : metadata;
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.replace(key, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.replace(key, oldValue, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.putIfAbsent(key, value, metadata, 0L);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.putAsync(key, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> putAsyncEntry(K key, V value, Metadata metadata) {
        return this.putAsyncEntry(key, value, metadata, 0L, this.defaultContextBuilderForWrite());
    }

    private Transaction suspendOngoingTransactionIfExists() {
        Transaction tx = this.getOngoingTransaction(false);
        if (tx != null) {
            try {
                this.transactionManager.suspend();
            }
            catch (SystemException e) {
                throw new CacheException("Unable to suspend transaction.", (Throwable)e);
            }
        }
        return tx;
    }

    private void resumePreviousOngoingTransaction(Transaction transaction, String failMessage) {
        block3: {
            if (transaction != null) {
                try {
                    this.transactionManager.resume(transaction);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug(failMessage);
                }
            }
        }
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.config);
    }

    public ContextBuilder defaultContextBuilderForWrite() {
        return this.defaultBuilder;
    }

    @Override
    public CachePublisher<K, V> cachePublisher() {
        return new CachePublisherImpl(this, 0L);
    }
}

